from easy import camera
from easy import eagle

def play(app, button):
    camera.play(filename=app['file_name'])

def pause(app, button):
    camera.pause()

def stop(app, button):
    camera.stop_playing()

def select_file(app, button, value):
    app['file_name'] = value

app = eagle.App(title='Easy Player',

                top=(eagle.Entry(id='file_name', value=''),
                     eagle.OpenFileButton(id='select_file', callback=select_file),
                     eagle.Button(id='play', label='Play',  callback=play),
                     eagle.Button(id='pause', label='Pause', callback=pause),
                     eagle.Button(id='stop', label='Stop', callback=stop)),

                center=eagle.XWindow(id='xwindow'))

camera.set_window_id(app['xwindow'].get_window_id())
eagle.run()