import os
from easy import eagle
from easy import camera

global picture_number
picture_number = 0
folder = '/home/user/MyDocs/.images/'
file_list = []
image_index = 0
image_object = ""
cam = 0
snapshot = 1
mode = snapshot

class EasySlideShow(object):
    
    def __init__(self): pass
        
    def list_files(self, app): 
        global file_list, folder, image_index
        if folder:
            file_list = [filename for filename in os.listdir(folder) if '.jpg' in filename]
            if not file_list:
                app.status_message("This folder has no pictures.")
            else:
                app.status_message("Folder: " + str(len(file_list)) + " pictures")
        else:
            app.status_message("Folder not set. Please set a folder by pressing the button 'Open'.")
        if file_list:
            self.set_biggest_index(app)
            
    def set_biggest_index(self, app):        
        global file_list, picture_number
        file_list.sort()
        last_image = file_list[-1]
        split_name = last_image.split('.')
        split_name = split_name[0].split('Image')
        picture_number = int(split_name[1]) + 1
        app['file_name'] = 'Image' + str(picture_number) + '.jpg'
      
    def start(self, app, button):
        global mode, cam
        self.set_mode(app, cam)
        camera.start()
    
    def click(self, app, button):
        global picture_number, folder
        camera.click(folder + app['file_name'])
        picture_number += 1
        app['file_name'] = 'Image' + str(picture_number) + '.jpg'
    
    def exit(self, app, button):
        if camera.is_started():
            camera.stop_displaying()
    
    def last(self, app, button):
        global image_index, file_list, mode, cam
        if mode == cam:
            self.set_mode(app, snapshot)        
        if not file_list or not len(file_list):
            app.status_message("This folder has no pictures.")
            return
        if image_index == 0:
            image_index = len(file_list)-1
        else:
            image_index -= 1
            self.image_refresh(app) 
            
    def next(self, app, button):
        global image_index, file_list, mode, cam
        if mode == cam:
            self.set_mode(app, snapshot)
        if not file_list or not len(file_list):
            app.status_message("This folder has no pictures.")
            return
        if image_index == len(file_list)-1:
            image_index = 0
        else:
            image_index += 1
        self.image_refresh(app)
            
    def set_mode(self, app, new_mode):
        global mode, cam, snapshot
        mode = new_mode
        if mode == cam:
            app['canvas'].set_visible(False)
            app['xwindow'].set_visible(True)
        elif mode == snapshot:
            self.list_files(app)
            camera.stop_displaying()
            app['canvas'].set_visible(True)
            app['xwindow'].set_visible(False)
            
    def image_refresh(self, app):
        global image_object, image_index, file_list
        if file_list and image_index:
            try: 
                image_object = eagle.Image(filename=folder+file_list[image_index])
            except:
                app.status_message('Error: ' + file_list[image_index] + ' is  too big. Please choose one snapshot taken with camera_snapshot.')
        app['canvas'].clear()
        if image_object:
            app['canvas'].draw_image(image_object)
            app.status_message('File: ' + file_list[image_index] + '(' + str(image_index+1) + ' of ' + str(len(file_list)) + ')')
        else:
            app.status_message('File ' + file_list[image_index] + ' could not be open.')
           
    def select_folder(self, app, button, name):
        global folder, file_list
        if name:
            folder = name
        else:
            app.status_message("Default folder: Images")        
        self.list_files(app)
    
ess = EasySlideShow()
app = eagle.App(title='Easy SlideShow',
                top=(eagle.SelectFolderButton(id='select_folder', callback=ess.select_folder),
                     eagle.QuitButton()),
                center=(eagle.XWindow(id='xwindow'),
                        eagle.Canvas(id='canvas', label='Canvas Area', width=176, height=144, bgcolor=0xffffff, scrollbars=False, callback=None, resize_callback=None, expand_policy=None, )),
                bottom=(eagle.Button(id='last', label='Last', callback=ess.last),
                        eagle.Button(id='next', label='Next', callback=ess.next)),
                right=(eagle.Label(id='cameralabel', label='Camera'),
                       eagle.Entry(id='file_name', label='File name:', value='Image'+str(picture_number)+'.jpg'),
                       eagle.Button(id='start', label='Start', callback=ess.start),
                     eagle.Button(id='click', label='Click', callback=ess.click),
                     eagle.Button(id='exit', label='Stop', callback=ess.exit),
                     ),
                statusbar=True)
ess.list_files(app)
app.status_message("Easy Slide Show")
camera.set_window_id(app['xwindow'].get_window_id())
eagle.run()