from easy import eagle
from easy import e_mail
from easy import contact

def login(app, button):
    try:
        e_mail.connect(app['user'],app['password'],app['smtp_server'])

        app['email_tab'].active = True
        app['contacts_tab'].active = True
        app['login'].active = False
        app['status'] = 'Connected!'
        contact_list = []
#        contacts = app.Email.contacts()

        book = contact.ContactBook.get_instance()
        contacts = book.all()

        for eash in contacts:
            contact_list.append((eash.name, eash.family_name, eash.email))
        
        t = app['contacts_table']
        t[:] = contact_list
    except:
        pass

def logout(app, button):
    if e_mail.connected:
        e_mail.disconnect()
    l = []
    t = app['contacts_table']
    t[:] = l
    app.emails = ""
    app['user'] = ""
    app['password'] = ""
    app['to'] = ""
    app['attach'] = ""
    app['subject'] = ""
    app['text'] = ""
    app['email_tab'].active = False
    app['contacts_tab'].active = False
    app['login'].active = True
    app['status'] = 'Not Connected'

def open_file(app, button, value):
    app['attach'] = value

def send_email(app, button):
    email = e_mail.create_email()
    email.to = app['to']
    email.subject = app['subject']
    email.message = app['text']
    
    if app['attach']:
        email.add_attachment(app['attach'])
    
    e_mail.send_mail(email)
    app['to'] = ""
    app['attach'] = ""
    app['subject'] = ""
    app['text'] = ""

def to_callback(app, widget, value):
    app.emails = value

def selected_contact(app, info_table, rows):
    rows = app['contacts_table'].selected()
    if rows:
        id, (name, family, email) = rows[0]
        app.emails += "%s," % email
        app['to'] = app.emails
        app['add_label'] = "Added contact %s %s" % (name, family)

login_widgets = (

    eagle.Group( id="login_group",
                 border=False,
                 children=( eagle.Entry( id="user",
                                         label="User",
                                         value="qualquerumserve",
                                         ),
                            eagle.Password( id="password",
                                            label="Password",
                                            persistent=True,
                                            value="todas123",
                                            ),
                            eagle.Entry( id="smtp_server",
                                         label="Smtp Server",
                                         value="smtp.gmail.com"
                                         ),
                            eagle.HSeparator(),
                            eagle.Button( id="login",
                                          label="Login",
                                          callback=login,
                                          ),
                            eagle.Button( id="logout",
                                          label="Logout",
                                          callback=logout,
                                          ),
                            eagle.Label( id="status",
                                         label="Not Connected",
                                         ),
                            ),
                    ),
        )

email_widgets = (

     eagle.Group( id="message_group",
                   border=False,
        
                   children=( eagle.Entry( id="to",
                                           label="To",
                                           callback=to_callback
                                           ),
                              
                              eagle.Group( id="attach_group",
                                           horizontal=True,
                                           children=( eagle.Entry( id="attach",
                                                                   label="Attach",
                                                                   ),
                                                      eagle.OpenFileButton( id="open",
                                                                            callback=open_file,
                                                                            ),
                                                        ),
                                     ),
                              eagle.Entry( id="subject",
                                           label="Subject",
                                           ),
                              eagle.Group( id="s_group",
                                           horizontal=True,
                                           children=( eagle.Entry( id="text",
                                                                   label="Message",
                                                                   multiline=True,
                                                                   ),
                                                      eagle.Button( id="send_email",
                                                                    label="Send Email",
                                                                    callback=send_email,
                                                                    ),
                                                    ),
                                            ),
                             ),
                    )
     )

contacts_widgets = (
     eagle.Table( id="contacts_table",
                label="Contacts",
                headers=("Name", "Family Name", "E-mail"), 
                types=(str, str, str),
                selection_callback=selected_contact,
                ),
     eagle.Label( id="add_label",
                ),
    )

app = eagle.App(title='Email with contact', 
                #window_size=(800, 600),
                center=eagle.Tabs( id="tabs",
                                   children=(eagle.Tabs.Page( id="login_tab",
                                                              label="Enter",
                                                              active=True,
                                                              children=login_widgets,
                                                              ),
 
                                             eagle.Tabs.Page( id="email_tab",
                                                              label="Email",
                                                              active=False,
                                                              children=email_widgets,
                                                              ),
                                             eagle.Tabs.Page( id="contacts_tab",
                                                              label="Contacts",
                                                              active=False,
                                                              children=contacts_widgets,
                                                            ),
                                            ),
                                    )
                )

app.emails = ""

eagle.run()