from easy import camera
from easy import eagle

def start(app, button):
    camera.start()

def record(app, button):
    camera.record_async(app['file_name'])

def stop(app, button):
    camera.stop_recording()

def play(app, button):
    camera.set_window_id(app['xwindow'].get_window_id())
    camera.play(filename=app['file_name'])

def pause(app, button):
    camera.pause()

app = eagle.App(title='Easy Player',

                top=(eagle.Entry(id='file_name', value='./rec.avi'),
                    eagle.Button(id='start', label='Start',  callback=start),
                    eagle.Button(id='record', label='Record', callback=record),
                    eagle.Button(id='stop', label='Stop Record', callback=stop),
                    eagle.Button(id='play', label='Play', callback=play),
                    eagle.Button(id='pause', label='Pause', callback=pause)),

                center=eagle.XWindow(id='xwindow'))

camera.set_window_id(app['xwindow'].get_window_id())
eagle.run()