from easy import bluetooth
from easy import eagle

def find_devices(app, button):
    app.devices = bluetooth.finddevices()
    for dev in app.devices:
        mac, name, value = dev
        app['playlist'].append(name)

def send_file(app, button, value):
    rows = app['playlist'].selected()
    if rows:
        idx, row = rows[0]
        mac, name, id = app.devices[idx]
        # 1-Maemo 9-Phone
        mac, channel, service_name = bluetooth.findservices(mac, u'OBEX Object Push')[0]
        bluetooth.obex.sendfile(mac, channel, value)

app = eagle.App(title='Easy Bluetooth', 
                
                top = eagle.Button(id='find_devices', label='Find devices', callback=find_devices),
                        
                center = eagle.Table(id='playlist', label=None, show_headers=False, types=(str,)),

                bottom = eagle.OpenFileButton(id='send_file', callback=send_file))

app.devices = []

eagle.run()