import time

from easy import audio
from easy import eagle

is_running = False
timeout_id = None

def play(app, button):
    global is_running, timeout_id

    if is_running is True:
        stop(app, button)

    rows = app['playlist'].selected()
    if rows:
        idx, row = rows[0]
        file_name = row[0]
        audio.play(file_name)

    is_running = True
    timeout_id = app.timeout_add(100, update_time_label)

def pause(app, button):
    if is_running:
        audio.pause()
    
        if app['pause'].label == 'Pause':
            app['pause'].label = 'Resume'
        else:
            app['pause'].label = 'Pause'

def stop(app, button):
    global is_running

    if is_running:
        is_running = False
        time.sleep(0.1)
        app.remove_event_source(timeout_id)

        audio.stop()
        app['time_label'] = ' ' * 20

def add_file(app, button, value):
    app['playlist'].append(value)

def update_time_label(app):
    try:        
        position = audio.get_current_position()
        total = audio.get_length()

        if position < total:            
            app['time_label'] = str(convert_time(position)) + ' / ' +  str(convert_time(total))
        else:
            app['time_label'] = ' ' * 20
    except:
        pass

    return is_running

def forward(app, button):
    if is_running:
        new_position = audio.get_current_position() + 5 * 10**9
        
        if new_position < audio.get_length():
            audio.seek(new_position)

def backward(app, button):
    if is_running:
        new_position = audio.get_current_position() - 5 * 10**9
    
        if new_position > 0:
            audio.seek(new_position)

def convert_time(time_int):
    tmin, tsec = divmod(time_int / 1000000000.0, 60)

    return '%02d:%02d' % (tmin, tsec)

app = eagle.App(title='Easy Player',
                top=eagle.OpenFileButton(id='add_file', callback=add_file),

                center=eagle.Table(id='playlist', label=None,
                                   show_headers=False, types=(str,)),

                bottom=(eagle.Button(id='play', label='Play',  callback=play),
                        eagle.Button(id='pause', label='Pause', callback=pause),
                        eagle.Button(id='stop', label='Stop', callback=stop),
                        eagle.Label(id='time_label', label=' ' * 20),
                        eagle.Button(id='backward', label='<<', callback=backward),
                        eagle.Button(id='forward', label='>>', callback=forward)))

eagle.run()