/*
 * Canola Cleanup
 * Copyright (C) 2008 Instituto Nokia de Tecnologia
 * Author: Gustavo Barbieri <gustavo.barbieri@openbossa.org>
 *         Eduardo Lima (Etrunko) <eduardo.lima@indt.org.br>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <unistd.h>

int
main (int argc, char *argv[])
{
    int ret = 0;

    setuid(geteuid());
    printf("%s - Called with %d arguments\n", argv[0], argc);
    if (argc != 2)
        return 1;

    printf("%s - Adding /usr/local/sbin:/usr/sbin:/sbin to env\n", argv[0]);
    putenv("PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin:/usr/bin/X11");
    printf("%s - getenv(\"PATH\") = '%s'\n", argv[0], getenv("PATH"));
    printf("%s - Launching '%s'\n",argv[0], argv[1]);
    ret = execlp(argv[1], argv[1], NULL);

    if (ret == -1)
        perror("Error");

    return ret;
}
