#if HAVE_CONFIG_H
#include <config.h>
#endif

#include "ui-impl.h"
#if HILDON_VERSION <= 3
#include <hildon-widgets/hildon-program.h>
#elif HILDON_VERSION == 4
#include <hildon/hildon-program.h>
#endif

GtkWidget *
create_window(void)
{
    return hildon_window_new();
}

UiProgram *
program_new(void)
{
    HildonProgram *p;

    p = hildon_program_get_instance();
    g_set_application_name("Canola2 Utility");
    return (UiProgram *)p;
}

void
program_add_window(UiProgram *program,
                   GtkWidget *window)
{
    hildon_program_add_window(HILDON_PROGRAM(program), HILDON_WINDOW(window));
}
