/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the EAL package.
 *
 * The Initial Developer of the Original Code is Nokia Corporation.
 * Portions created by the Initial Developer are Copyright (C) 2005
 * the Initial Developer. All Rights Reserved.
 *
 * Contact: Leonid Zolotarev <leonid.zolotarev@nokia.com>
 *
 * ***** END LICENSE BLOCK ***** */

#include <glib-object.h>

#ifndef __GWEBTRANSFERITEMLIST_H__
#define __GWEBTRANSFERITEMLIST_H__

G_BEGIN_DECLS

/** GWebTransferItemList
  */

#define G_TYPE_WEB_TRANSFER_ITEM_LIST             (g_web_transfer_item_get_type ())
#define G_WEB_TRANSFER_ITEM_LIST(obj)             (G_TYPE_CHECK_INSTANCE_CAST ((obj), G_TYPE_WEB_TRANSFER_ITEM_LIST, GWebTransferItemList))
#define G_WEB_TRANSFER_ITEM_LIST_CLASS(vtable)    (G_TYPE_CHECK_CLASS_CAST ((vtable), G_TYPE_WEB_TRANSFER_ITEM_LIST, GWebTransferItemListIface))
#define G_IS_WEB_TRANSFER_ITEM_LIST(obj)          (G_TYPE_CHECK_INSTANCE_TYPE ((obj), G_TYPE_WEB_TRANSFER_ITEM_LIST))
#define G_IS_WEB_TRANSFER_ITEM_LIST_CLASS(vtable) (G_TYPE_CHECK_CLASS_TYPE ((vtable), G_TYPE_WEB_TRANSFER_ITEM_LIST))
#define G_WEB_TRANSFER_ITEM_LIST_GET_CLASS(inst)  (G_TYPE_INSTANCE_GET_INTERFACE ((inst), G_TYPE_WEB_TRANSFER_ITEM_LIST, GWebTransferItemListIface))

typedef struct _GWebTransferItemList GWebTransferItemList; /* dummy object */
typedef struct _GWebTransferItemListIface GWebTransferItemListIface;

/** @struct GWebTransferItemListIface.
  * Defines web transfer item list interface.
  */
struct _GWebTransferItemListIface {
	GTypeInterface parent;

	void (*destroy) (GWebTransferItemList *self);
	GObject** (*get_items) (GWebTransferItemList *self);
	gint (*get_items_count) (GWebTransferItemList *self);
};

GType g_web_transfer_item_list_get_type (void);

void g_web_transfer_item_list_destroy (GWebTransferItemList *self);
GObject** g_web_transfer_item_list_get_items (GWebTransferItemList *self);
gint g_web_transfer_item_list_get_items_count (GWebTransferItemList *self);

G_END_DECLS

#endif /* __GWEBTRANSFERITEMLIST_H__ */
