/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the EAL package.
 *
 * The Initial Developer of the Original Code is Nokia Corporation.
 * Portions created by the Initial Developer are Copyright (C) 2005
 * the Initial Developer. All Rights Reserved.
 *
 * Contact: Leonid Zolotarev <leonid.zolotarev@nokia.com>
 *
 * ***** END LICENSE BLOCK ***** */

#include <glib-object.h>

#ifndef __GWEBHISTORYLIST_H__
#define __GWEBHISTORYLIST_H__

G_BEGIN_DECLS

/** GWebHistoryList
  */

#define G_TYPE_WEB_HISTORY_LIST             (g_web_history_list_get_type ())
#define G_WEB_HISTORY_LIST(obj)             (G_TYPE_CHECK_INSTANCE_CAST ((obj), G_TYPE_WEB_HISTORY_LIST, GWebHistoryList))
#define G_WEB_HISTORY_LIST_CLASS(vtable)    (G_TYPE_CHECK_CLASS_CAST ((vtable), G_TYPE_WEB_HISTORY_LIST, GWebHistoryListIface))
#define G_IS_WEB_HISTORY_LIST(obj)          (G_TYPE_CHECK_INSTANCE_TYPE ((obj), G_TYPE_WEB_HISTORY_LIST))
#define G_IS_WEB_HISTORY_LIST_CLASS(vtable) (G_TYPE_CHECK_CLASS_TYPE ((vtable), G_TYPE_WEB_HISTORY_LIST))
#define G_WEB_HISTORY_LIST_GET_CLASS(inst)  (G_TYPE_INSTANCE_GET_INTERFACE ((inst), G_TYPE_WEB_HISTORY_LIST, GWebHistoryListIface))

typedef struct _GWebHistoryList GWebHistoryList; /* dummy object */
typedef struct _GWebHistoryListIface GWebHistoryListIface;

/** @struct GWebHistoryListIface.
  * Defines web history list interface.
  */
struct _GWebHistoryListIface {
	GTypeInterface parent;

	void (*destroy) (GWebHistoryList *self);
	void (*delete_item) (GWebHistoryList *self, GObject *item);
	GObject* (*get_items) (GWebHistoryList *self);
	gint (*get_items_count) (GWebHistoryList *self);
	const gchar* (*get_item_title) (GWebHistoryList *self, gint pos);
	const gchar* (*get_item_url) (GWebHistoryList *self, gint pos);
	GTime (*get_item_time) (GWebHistoryList *self, gint pos);
};

GType g_web_history_list_get_type (void);

void g_web_history_list_destroy (GWebHistoryList *self);
void g_web_history_list_delete_item (GWebHistoryList *self, GObject *item);
GObject* g_web_history_list_get_items (GWebHistoryList *self);
gint g_web_history_list_get_items_count (GWebHistoryList *self);
const gchar* g_web_history_list_get_item_title (GWebHistoryList *self, gint pos);
const gchar* g_web_history_list_get_item_url (GWebHistoryList *self, gint pos);
GTime g_web_history_list_get_item_time (GWebHistoryList *self, gint pos);

G_END_DECLS

#endif /* __GWEBHISTORYLIST_H__ */
