#include <dirent.h>
#include <errno.h>
#include <string.h>
#include <glib.h>

#include "util.h"
#include "xmame.h"


#define NUM_EXTENSIONS 3
static const char* extensions[] = {"",".zip",".gz"};


int taksort(const void *a, const void *b);
GList* get_installed_roms_in_path(const char *path, xmaeme_rom_type romtype);
char* is_rom_in_path(const char* romname, const char* path);


GList* get_installed_roms(xmaeme_rom_type romtype){
	int i=0;
	const char	*subpath = get_rom_subpath(romtype);
	char *currpath = NULL;
	GList	*rv = NULL,
		*tmp = NULL;
	gboolean mame_rom = FALSE;

	if(XMAEME_ROMTYPE_MAME == romtype){
		int j = 0;
		for(; j<XMAME_RC_PATH_COUNT; ++j) {
			currpath = xmame_get_rompath_from_xmamerc(XMAME_RC_PATHS[j]);
			if(currpath) {
				tmp = get_installed_roms_in_path(currpath, romtype);
				rv = g_list_concat(rv,tmp);
				g_free(currpath);
			}// got another rompath
		}// check xmamercs for rompaths

		mame_rom = TRUE;
	}//MAME!

	for(i=0;i<XMAEME_SEARCH_PATHS_COUNT;++i){
		currpath = g_strdup_printf("%s%s",XMAEME_SEARCH_PATHS[i],subpath);
		tmp = get_installed_roms_in_path(currpath,romtype);
		rv = g_list_concat(rv, tmp);
		// I don't think I need to g_list_free tmp,
		// since c_list_concat reuses tmp's nodes
		g_free(currpath);

		if(mame_rom){
			tmp = get_installed_roms_in_path(XMAEME_SEARCH_PATHS[i],romtype);
			rv = g_list_concat(rv,tmp);
		}//check base roms/ dir as well
	}//for each search path

	currpath = g_strdup_printf("%s%s",g_get_home_dir(),"/MyDocs/.documents/.games/");
	tmp = get_installed_roms_in_path(currpath,romtype);
	g_free(currpath);
	rv = g_list_concat(rv,tmp);

	currpath = g_strdup_printf("%s%s",g_get_home_dir(),"/MyDocs/.games/");
	tmp = get_installed_roms_in_path(currpath,romtype);
	g_free(currpath);
	rv = g_list_concat(rv,tmp);

	return rv;
}//get_installed_roms


GList* get_installed_roms_in_path(const char *path, xmaeme_rom_type romtype){
	GList	*romlist = NULL;
	gchar	*name = NULL;
	struct dirent	**dirlist = NULL;
	int	numentries = 0,
		i = 0;

	numentries = scandir(path, &dirlist, NULL, taksort);
	
	if(0 > numentries){
		fprintf(stderr,"Error opening %s: %s\n", path, strerror(errno));
		return romlist;
	}//can't read path


	for(i=0;i<numentries;++i){
		if('.' != *(dirlist[i]->d_name)){
			if((!strcmp(dirlist[i]->d_name, "nes")) || 
			(!strcmp(dirlist[i]->d_name, "gba")) ||
			(!strcmp(dirlist[i]->d_name, "neogeo")) ||
			(!strcmp(dirlist[i]->d_name, "mame"))){
				continue; //don't add "nes" or "gba" to the dropdown
			}//if

			name = g_strdup(dirlist[i]->d_name);
			if(romtype == XMAEME_ROMTYPE_MAME){
				strip_extension(name);
			}
			romlist = g_list_prepend(romlist,name);
		}//if filename doestn't start with .
		g_free(dirlist[i]);
	}//for each entry
	
	g_free(dirlist);

	return romlist;
}//get_installed_roms_in_path


int strip_extension(char *filename){
	char	*cursor = strrchr(filename,'.');
	int	found = FALSE;

	if(cursor){
		found = TRUE;
		*cursor='\0';
	}//strip file extension

	return found;
}//strip_extension


void gfunc_g_free(gpointer data, gpointer user_data){
	g_free(data);
}//gfunc_g_free


int gtk_combo_box_text_populate(GtkComboBox *box, const GList *items){
	int i = 0;
	GList *cursor = (GList*)items;

	for(;cursor;cursor = cursor->next, ++i){
		gtk_combo_box_prepend_text(box, (const gchar*)(cursor->data));
	}//for each item

	if(items){
		gtk_combo_box_set_active(box, 0);
	}//if non-empty list

	return i;
}//gtk_combo_box_text_populate

// I guess not every arch has alphasort in dirent.h
int taksort(const void *a, const void *b){
	return strcoll((*(struct dirent **)a)->d_name, (*(struct dirent **)b)->d_name);
}//taksort


//Returned value must be freed!
char* get_rom_full_path(const char* romname, xmaeme_rom_type romtype){
	int	i=0,
		j=0;
	char	*fullrom=NULL,
		*path=NULL;
	const char *subpath=get_rom_subpath(romtype);
	
	// If filename is relative, prepend rompath
	if(!g_path_is_absolute(romname)){
	//if(('/' != *romname) && ('\0' != *romname)){
		//hackish win32 check, as if anyone will use this on win32
		//if(':' != romname[1]){	
		//Duh, glib to the rescue!
			for(i=0;i<XMAEME_SEARCH_PATHS_COUNT;++i){
				path=g_strdup_printf("%s%s",XMAEME_SEARCH_PATHS[i],subpath);
				fullrom = is_rom_in_path(romname,path);
				g_free(path);

				if((!fullrom) &&
				(XMAEME_ROMTYPE_MAME == romtype)){
					fullrom = is_rom_in_path(romname,XMAEME_SEARCH_PATHS[i]);
				}//Check base path for mame roms

				if(fullrom){
					return fullrom;
				}//Found!
			}//for each base path
		//}//if
	}//if not absolute path

	return fullrom;
}//get_rom_full_path


//Returned value needs to be freed!
char* is_rom_in_path(const char* romname, const char* path){
	gchar	*name = NULL;
	struct dirent	**dirlist = NULL;
	int	numentries = 0,
		i = 0,
		j = 0;
	char *rv = NULL;

	numentries = scandir(path, &dirlist, NULL, NULL);
	
	if(0 > numentries){
		fprintf(stderr,"Error opening %s: %s\n", path, strerror(errno));
		return rv;
	}//can't read path


	for(i=0;i<numentries;++i){
		if('.' != *(dirlist[i]->d_name)){
			for(j=0;j<NUM_EXTENSIONS;++j){
				name = g_strdup_printf("%s%s",romname,extensions[j]);
				if(!strcmp(dirlist[i]->d_name, name)){
					//Found!
					rv = g_strdup_printf("%s%s",path,name);
					g_free(name);
					for(;i<numentries;++i){
						g_free(dirlist[i]);
					}//clean up the rest of dirlist
					g_free(dirlist);
					return rv;
				}//if
				g_free(name);
			}//for each possible file extension
		}//if filename doestn't start with .
		g_free(dirlist[i]);
	}//for each entry
	
	g_free(dirlist);
	return rv;
}//is_rom_in_path


const char* get_rom_subpath(xmaeme_rom_type romtype){
	return XMAEME_SUBPATHS[romtype];

	/*
	char *subpath = NULL;

	switch(romtype){
		case XMAEME_ROMTYPE_MAME:
			subpath=XMAEME_ROMPATH_MAME;
			break;
		case XMAEME_ROMTYPE_NES:
			subpath=XMAEME_ROMPATH_NES;
			break;
		case XMAEME_ROMTYPE_GBA:
			subpath=XMAEME_ROMPATH_GBA;
			break;
	}//switch

	return subpath;
	*/
}//get_rom_subpath
