#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <errno.h>

#include <sys/types.h>
#include <sys/wait.h>

#include "fceu.h"
#include "util.h"


#define XMAEME_FCEU_EXE		"fceu"
#define XMAEME_FCEU_SOUND	"-sound"
#define XMAEME_FCEU_FULLSCREEN	"-fs"
#define XMAEME_FCEU_XSCALE	"-xres"
#define XMAEME_FCEU_YSCALE	"-yres"
#define XMAEME_FCEU_FSKIP	"-frameskip"
#define XMAEME_FCEU_BPP		"-bpp"
#define XMAEME_FCEU_BPPFS	"-bppfs"
#define XMAEME_FCEU_NOTHROTTLE	"-nothrottle"


gint launch_fceu(const gchar *romname, gboolean use_sound, gboolean fullscreen, gboolean maxscale, gint frameskip){
	int	status = 0,
		pid = 0;

	if(!romname){
		return 1;
	}//if romname is NULL

	if((pid=fork())){
		waitpid(pid, &status, 0);
	}//parent
	else{
		int	i = 1;
		char*	args[17] = { XMAEME_FCEU_EXE, NULL, NULL, NULL, NULL, NULL, NULL, NULL , NULL , NULL , NULL, NULL, NULL, NULL, NULL };
		char	*fullrom = NULL,
	       		*fskip = NULL;	

		fullrom = get_rom_full_path(romname, XMAEME_ROMTYPE_NES);

		if(!fullrom){
			fullrom = g_strdup(romname);
		}//if

		args[i++] = XMAEME_FCEU_NOTHROTTLE;
		args[i++] = "1";

		args[i++] = XMAEME_FCEU_SOUND;
		args[i++] = use_sound?"1":"0";

		args[i++] = XMAEME_FCEU_FULLSCREEN;
		args[i++] = "1";
		//args[i++] = fullscreen?"1":"0";

		//if(maxscale){
		args[i++] = XMAEME_FCEU_XSCALE;
		args[i++] = "800";
		args[i++] = XMAEME_FCEU_YSCALE;
		args[i++] = "480";
		//}//if

		if(frameskip>0){
			args[i++] = XMAEME_FCEU_FSKIP;
			fskip = g_strdup_printf("%d",frameskip);
			args[i++] = fskip;
		}//skip frames

		args[i++] = fullscreen?XMAEME_FCEU_BPPFS:XMAEME_FCEU_BPP;
		args[i++] = "8";

		args[i++] = (char*)fullrom;
		
 		{ //debug
			int j = 0;

			printf("Child: running ");
			for(j=0;j<15;++j){
				printf("%s ", args[j]);
			}//for
			printf("\n");
		} //debug

		putenv("SDL_VIDEO_X11_WMCLASS=fceu");
		status=execvp(XMAEME_FCEU_EXE,args);
		if(status<0){
			fprintf(stderr,"Unable to run %s: %s\n",XMAEME_FCEU_EXE,strerror(errno));
		}//if an error occurred

		g_free(fullrom);
		g_free(fskip);

		exit(0);
	}//child

	return status;
}//launch_fceu
