#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>

#ifdef HILDON
#  include <hildon-widgets/hildon-program.h>
#  include <hildon-widgets/hildon-file-chooser-dialog.h>
#  include <hildon-widgets/hildon-number-editor.h>
#endif

#include "interface.h"
#include "callbacks.h"
#include "util.h"
#include "glade.h"

int main (int argc, char *argv[]) {
#ifdef ENABLE_NLS
  bindtextdomain (GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
  bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
  textdomain (GETTEXT_PACKAGE);
#endif

  gtk_set_locale ();
  gtk_init (&argc, &argv);

  // load the interface
  glade = glade_xml_new_from_buffer(glade_buf, sizeof(glade_buf), NULL, NULL);
  
  // connect the signals in the interface
  glade_xml_signal_autoconnect(glade);

  xmaeme_init();

  gtk_main ();
  return 0;
}//main


xmaeme_init() {
  #define num_romtypes 4
  const xmaeme_rom_type romtypes[num_romtypes] = {	XMAEME_ROMTYPE_MAME,
							XMAEME_ROMTYPE_NES,
							XMAEME_ROMTYPE_GBA,
							XMAEME_ROMTYPE_NEOGEO };
  const char	*list_names[num_romtypes] = {	"mame_romlist",
  						"nes_romlist",
						"gba_romlist",
						"ng_romlist" },
		*emulators[num_romtypes] = {	"xmame",
						"fceu",
						"vba",
						"gngeoNOTREADYYET" },
		*tabs[num_romtypes] = {	"mame_panel",
					"nes_panel",
					"gba_panel",
					"ng_panel" };
  gchar *result = NULL;
  GtkComboBox	*romlist = NULL;
  GList		*filelist = NULL;
  int	i = 0,
  	visible_tabs = 0;
  GtkWidget	*mainwindow = glade_xml_get_widget(glade, "mainwindow"),
		*helptab = glade_xml_get_widget(glade, "help_about");
  GtkNotebook *notebook = GTK_NOTEBOOK(glade_xml_get_widget(glade, "notebook1"));
#ifdef HILDON
#define NUM_SPINS 2
  HildonProgram *hprogram = hildon_program_get_instance();
  GtkWidget	*ned = NULL,
  		*spin = NULL,
		*hbox = NULL;
  double	min = 0.0,
		max = 0.0;
  const char	*spins[NUM_SPINS] = { "nes_frameskip", "gba_frameskip" };
  char		*name = NULL;

  hildonwindow = HILDON_WINDOW(hildon_window_new());
  gtk_window_set_title(GTK_WINDOW(hildonwindow), gtk_window_get_title(GTK_WINDOW(mainwindow)));
  gtk_widget_reparent(GTK_WIDGET(notebook), GTK_WIDGET(hildonwindow));
  g_signal_connect ((gpointer) hildonwindow, "key_press_event", G_CALLBACK (key_press_cb), (gpointer)hildonwindow);

  /// Set up HildonNumberEditors
  for(i=0; i<NUM_SPINS; ++i) {
	  name = g_strdup_printf("%s%s", spins[i], "_hildon");
	  spin = glade_xml_get_widget(glade, spins[i]);
	  hbox = gtk_widget_get_ancestor(spin, GTK_TYPE_HBOX);
	  gtk_spin_button_get_range(GTK_SPIN_BUTTON(spin), &min, &max);
	  ned = hildon_number_editor_new((int)min, (int)max);
	  gtk_widget_set_name(ned, name);
	  hildon_number_editor_set_value(HILDON_NUMBER_EDITOR(ned), gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin)));
	  gtk_box_pack_start_defaults(GTK_BOX(hbox), ned);
	  gtk_widget_hide_all(spin);
	  gtk_widget_show_all(ned);
	  g_free(name);
  }//for each spinner


  hildon_program_add_window(hprogram, hildonwindow);
  gtk_widget_show(GTK_WIDGET(hildonwindow));
#else
  gtk_widget_show_all(mainwindow);
#endif

  for(i=0; i<num_romtypes; ++i) {
  	  if(result = g_find_program_in_path(emulators[i])) {
	  	//printf("Found %s\n", result);
	  	g_free(result);
		++visible_tabs;
	  } else {
	  	GtkWidget	*tab = glade_xml_get_widget(glade, tabs[i]);
		//printf("Couldn't find %s\n", emulators[i]);
		if(tab){ gtk_widget_hide_all(tab); }
		else{ printf("Couldn't find %s\n", tabs[i]); }
	  	continue;
	  }//if
	  filelist = get_installed_roms(romtypes[i]);
	  romlist = GTK_COMBO_BOX(glade_xml_get_widget(glade, list_names[i]));
	  gtk_combo_box_text_populate(romlist, filelist);
	  g_list_free(filelist);
  }//for each rom type, populate list

  if(!visible_tabs) {
	//printf("No visible tabs\n");
	if(notebook){ gtk_notebook_set_show_tabs(notebook, FALSE); }
	if(helptab){ gtk_widget_show_all(helptab); }
	else{ printf("Couldn't get tab %s\n", helptab); }
  }//No emulators installed in PATH
  else{ gtk_widget_hide_all(helptab); }
}//xmaeme_init
