#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>

#ifdef HILDON
#  include <hildon-widgets/hildon-banner.h>
#  include <hildon-widgets/hildon-file-chooser-dialog.h>
#  include <hildon-widgets/hildon-number-editor.h>

HildonNumberEditor* get_ned(const char *spin_name);
gint get_hildon_value(const char *spin_name);
void set_hildon_value(const char *spin_name, gint val);
gint check_name(gconstpointer list_node, gconstpointer name);
#endif

#include "callbacks.h"
#include "interface.h"
#include "support.h"
#include "xmame.h"
#include "fceu.h"
#include "gngeo.h"
#include "util.h"


void show_error_dialog(GtkWidget *mainwindow, const char *error_msg);

// MAME
void on_mame_launch_clicked                    (GtkButton       *button,
                                        gpointer         user_data) {
	gchar	*romname = NULL,
		*cursor = NULL;
	GtkWidget	*w = NULL,
			*romlist = glade_xml_get_widget(glade, "mame_romlist"),
			*mainwindow = glade_xml_get_widget(glade, "mainwindow");
	const char*	wnames[4] = { "mame_sound", "mame_fullscreen", "mame_rotate", "mame_double" };
	gboolean	flags[4] = { TRUE, TRUE, TRUE, TRUE };
	gint	i = 0,
		status = 0;

	for(i=0;i<4;++i){
		w=glade_xml_get_widget(glade, wnames[i]);
		if(w){ flags[i] = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(w)); }
	}//for

	romname = gtk_combo_box_get_active_text(GTK_COMBO_BOX(romlist));
	//strip_extension(romname);

#ifdef HILDON
	hildon_banner_show_information(GTK_WIDGET(hildonwindow), NULL, _("Launching xmame"));
#endif

	status = launch_xmame(romname, flags[0], flags[1], flags[2], flags[3]);

	if(status<0){
		show_error_dialog(mainwindow,_("Unable to launch xmame"));
	}//error launching xmame
	else if(status>0){
		show_error_dialog(mainwindow,_("Unable to load ROM"));
	}//xmame exited unsuccessfully

	g_free(romname);
}//on_b_ok_clicked


//NES
void on_nes_launch_clicked                   (GtkButton       *button,
                                        gpointer         user_data) {
	gchar	*romname = NULL,
		*wname = NULL;
	GtkWidget	*w = NULL,
			*romlist = glade_xml_get_widget(glade, "nes_romlist"),
			*mainwindow = glade_xml_get_widget(glade, "mainwindow");
	const char*	wnames[4] = { "nes_sound", "nes_fullscreen", "nes_double", "nes_frameskip" };
	gint	flags[4] = { TRUE, TRUE, TRUE, 2 };
	gint	i = 0,
		status = 0;
	GList	*list = NULL,
		*cursor = NULL;

	for(i=0;i<3;++i){
		w=glade_xml_get_widget(glade, wnames[i]);
		if(w){ flags[i] = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(w)); }//if
	}//for


#ifdef HILDON
	flags[3] = get_hildon_value(wnames[3]);
#else
	w=glade_xml_get_widget(glade, wnames[3]);
	flags[3] = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(w));
#endif

	romname = gtk_combo_box_get_active_text(GTK_COMBO_BOX(romlist));

#ifdef HILDON
	hildon_banner_show_information(GTK_WIDGET(hildonwindow), NULL, _("Launching fceu"));
#endif

	status = launch_fceu(romname, flags[0], flags[1], flags[2], flags[3]);

	if(status<0){
		show_error_dialog(mainwindow,_("Unable to launch fceu"));
	}//error launching fceu
	else if(status>0){
		show_error_dialog(mainwindow,_("Unable to load ROM"));
	}//fceu exited unsuccessfully

	g_free(romname);
}//on_b_ok2_clicked


// GBA
void on_gba_launch_clicked                   (GtkButton       *button,
                                        gpointer         user_data) {
	gchar	*romname = NULL,
		*cursor = NULL;
	GtkWidget	*w = NULL,
			*romlist = glade_xml_get_widget(glade, "gba_romlist"),
			*mainwindow = glade_xml_get_widget(glade, "mainwindow");
	const char*	wnames[3] = { "gba_fullscreen", "gba_double", "gba_frameskip" };
	gint	flags[3] = { TRUE, TRUE, 5 };
	gint	i = 0,
		status = 0;

	for(i=0;i<2;++i){
		w=glade_xml_get_widget(glade, wnames[i]);
		if(w){ flags[i] = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(w)); }//if
	}//for

#ifdef HILDON
	flags[2] = get_hildon_value(wnames[2]);
#else
	w=glade_xml_get_widget(glade, wnames[2]);
	flags[2] = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(w));
#endif

	romname = gtk_combo_box_get_active_text(GTK_COMBO_BOX(romlist));

#ifdef HILDON
	hildon_banner_show_information(GTK_WIDGET(hildonwindow), NULL, _("Launching vba"));
#endif

	status = launch_vba(romname, FALSE, flags[0], flags[1], flags[2]);

	if(status<0){
		show_error_dialog(mainwindow,_("Unable to launch vba"));
	}//error launching vba
	else if(status>0){
		show_error_dialog(mainwindow,_("Unable to load ROM"));
	}//vba exited unsuccessfully

	g_free(romname);
}//on_b_ok3_clicked


// NeoGeo
void on_ng_launch_clicked                   (GtkButton       *button,
                                        gpointer         user_data) {
	gchar	*romname = NULL,
		*cursor = NULL,
		*biospath = NULL;
	GtkWidget	*w = NULL,
			*romlist = glade_xml_get_widget(glade, "ng_romlist"),
			*mainwindow = glade_xml_get_widget(glade, "mainwindow");
	const char*	wnames[2] = { "ng_sound", "ng_double" };
	gint	flags[3] = { TRUE, TRUE };
	gint	i = 0,
		status = 0;

	for(i=0;i<2;++i){
		w=glade_xml_get_widget(glade, wnames[i]);
		if(w){ flags[i] = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(w)); }//if
	}//for

	romname = gtk_combo_box_get_active_text(GTK_COMBO_BOX(romlist));

#ifdef HILDON
	hildon_banner_show_information(GTK_WIDGET(hildonwindow), NULL, _("Launching gngeo"));
#endif

	status = launch_gngeo(romname, biospath, flags[0], flags[1]);

	if(status<0){
		show_error_dialog(mainwindow,_("Unable to launch gngeo"));
	}//error launching gngeo
	else if(status>0){
		show_error_dialog(mainwindow,_("Unable to load ROM"));
	}//gngeo exited unsuccessfully

	g_free(romname);
}//on_b_ok4_clicked


// MAME
void on_mame_browse_clicked(GtkButton *button, gpointer user_data) {
	GtkWidget	*filedialog = NULL,
			*romlist = glade_xml_get_widget(glade, "mame_romlist"),
			*parent = glade_xml_get_widget(glade, "mainwindow");
	GList	*cursor = NULL;

#ifdef HILDON
	gchar *defaultpath = g_strdup_printf("%s%s",XMAEME_SEARCH_PATHS[0],XMAEME_SUBPATHS[XMAEME_ROMTYPE_MAME]);
	filedialog = hildon_file_chooser_dialog_new(GTK_WINDOW(parent), GTK_FILE_CHOOSER_ACTION_OPEN);
	gtk_file_chooser_set_current_folder(GTK_FILE_CHOOSER(filedialog), defaultpath);
	g_free(defaultpath);
#else
	filedialog = gtk_file_chooser_dialog_new(_("Choose ROM"), GTK_WINDOW(parent), GTK_FILE_CHOOSER_ACTION_OPEN, 
			GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, GTK_STOCK_OPEN, GTK_RESPONSE_OK, NULL);
#endif

	if(GTK_RESPONSE_OK == gtk_dialog_run(GTK_DIALOG(filedialog))){
		gchar	*filename = gtk_file_chooser_get_filename(GTK_FILE_CHOOSER(filedialog));
		
		cursor = g_list_find_custom(filelist, filename, strcmp);  
		if(!cursor){
			//add rom to start of list and select it
			strip_extension(filename);
			gtk_combo_box_prepend_text(GTK_COMBO_BOX(romlist),filename);
			gtk_combo_box_set_active(GTK_COMBO_BOX(romlist), 0);
		}//if rom isn't already in list
		g_free(filename);
	}//if file chosen

	gtk_widget_destroy(filedialog);
}//on_file_browse_clicked


// NES
void on_nes_browse_clicked(GtkButton *button, gpointer user_data) {
	GtkWidget	*filedialog = NULL,
			*romlist = glade_xml_get_widget(glade, "nes_romlist"),
			*parent = glade_xml_get_widget(glade, "mainwindow");
	GList	*cursor = NULL;

#ifdef HILDON
	gchar *defaultpath = g_strdup_printf("%s%s",XMAEME_SEARCH_PATHS[0],XMAEME_SUBPATHS[XMAEME_ROMTYPE_NES]);
	filedialog = hildon_file_chooser_dialog_new(GTK_WINDOW(parent), GTK_FILE_CHOOSER_ACTION_OPEN);
	gtk_file_chooser_set_current_folder(GTK_FILE_CHOOSER(filedialog), defaultpath);
	g_free(defaultpath);
#else
	filedialog = gtk_file_chooser_dialog_new(_("Choose ROM"), GTK_WINDOW(parent), GTK_FILE_CHOOSER_ACTION_OPEN, 
			GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, GTK_STOCK_OPEN, GTK_RESPONSE_OK, NULL);
#endif

	if(GTK_RESPONSE_OK == gtk_dialog_run(GTK_DIALOG(filedialog))){
		gchar	*filename = gtk_file_chooser_get_filename(GTK_FILE_CHOOSER(filedialog));
		
		cursor = g_list_find_custom(filelist, filename, strcmp);  
		if(!cursor){
			//add rom to start of list and select it
			gtk_combo_box_prepend_text(GTK_COMBO_BOX(romlist),filename);
			gtk_combo_box_set_active(GTK_COMBO_BOX(romlist), 0);
		}//if rom isn't already in list
		g_free(filename);
	}//if file chosen

	gtk_widget_destroy(filedialog);
}//on_file_browse2_clicked


// GBA
void on_gba_browse_clicked(GtkButton *button, gpointer user_data) {
	GtkWidget	*filedialog = NULL,
			*romlist = glade_xml_get_widget(glade, "gba_romlist"),
			*parent = glade_xml_get_widget(glade, "mainwindow");
	GList	*cursor = NULL;

#ifdef HILDON
	gchar *defaultpath = g_strdup_printf("%s%s",XMAEME_SEARCH_PATHS[0],XMAEME_SUBPATHS[XMAEME_ROMTYPE_NES]);
	filedialog = hildon_file_chooser_dialog_new(GTK_WINDOW(parent), GTK_FILE_CHOOSER_ACTION_OPEN);
	gtk_file_chooser_set_current_folder(GTK_FILE_CHOOSER(filedialog), defaultpath);
	g_free(defaultpath);
#else
	filedialog = gtk_file_chooser_dialog_new(_("Choose ROM"), GTK_WINDOW(parent), GTK_FILE_CHOOSER_ACTION_OPEN, 
			GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, GTK_STOCK_OPEN, GTK_RESPONSE_OK, NULL);
#endif

	if(GTK_RESPONSE_OK == gtk_dialog_run(GTK_DIALOG(filedialog))){
		gchar	*filename = gtk_file_chooser_get_filename(GTK_FILE_CHOOSER(filedialog));
		
		cursor = g_list_find_custom(filelist, filename, strcmp);  
		if(!cursor){
			//add rom to start of list and select it
			gtk_combo_box_prepend_text(GTK_COMBO_BOX(romlist),filename);
			gtk_combo_box_set_active(GTK_COMBO_BOX(romlist), 0);
		}//if rom isn't already in list
		g_free(filename);
	}//if file chosen

	gtk_widget_destroy(filedialog);
}//on_file_browse3_clicked


// NeoGeo
void on_ng_browse_clicked(GtkButton *button, gpointer user_data) {
	GtkWidget	*filedialog = NULL,
			*romlist = glade_xml_get_widget(glade, "ng_romlist"),
			*parent = glade_xml_get_widget(glade, "mainwindow");
	GList	*cursor = NULL;

#ifdef HILDON
	gchar *defaultpath = g_strdup_printf("%s%s",XMAEME_SEARCH_PATHS[0],XMAEME_SUBPATHS[XMAEME_ROMTYPE_NEOGEO]);

	filedialog = hildon_file_chooser_dialog_new(GTK_WINDOW(parent), GTK_FILE_CHOOSER_ACTION_OPEN);
	gtk_file_chooser_set_current_folder(GTK_FILE_CHOOSER(filedialog), defaultpath);
	g_free(defaultpath);
#else
	filedialog = gtk_file_chooser_dialog_new(_("Choose ROM"), GTK_WINDOW(parent), GTK_FILE_CHOOSER_ACTION_OPEN, 
			GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, GTK_STOCK_OPEN, GTK_RESPONSE_OK, NULL);
#endif

	if(GTK_RESPONSE_OK == gtk_dialog_run(GTK_DIALOG(filedialog))){
		gchar	*filename = gtk_file_chooser_get_filename(GTK_FILE_CHOOSER(filedialog));
		
		cursor = g_list_find_custom(filelist, filename, strcmp);  
		if(!cursor){
			//add rom to start of list and select it
			gtk_combo_box_prepend_text(GTK_COMBO_BOX(romlist),filename);
			gtk_combo_box_set_active(GTK_COMBO_BOX(romlist), 0);
		}//if rom isn't already in list
		g_free(filename);
	}//if file chosen

	gtk_widget_destroy(filedialog);
}//on_file_browse4_clicked


// NES Sound toggle clicked
void on_nes_sound_toggled(GtkToggleButton *button, gpointer user_data) {
	gboolean	checked = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(button));

#ifdef HILDON
	gint		fsvalue = get_hildon_value("nes_frameskip");
#else
	GtkWidget	*spinner= glade_xml_get_widget(glade, "nes_frameskip");
	gint		fsvalue = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spinner));
#endif

	if(checked){
		fsvalue = (fsvalue>9)?fsvalue:fsvalue+1;
	}else{
		fsvalue = (fsvalue<=0)?fsvalue:fsvalue-1;
	}

#ifdef HILDON
	set_hildon_value("nes_frameskip", fsvalue);
#else
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(spinner), fsvalue);
#endif
}//on_cb_sound2_clicked

gboolean key_press_cb(GtkWidget * widget, GdkEventKey * event,
		                      gpointer window)
{
#ifdef HILDON
	gint	width = 0,
		height = 0;

	switch(event->keyval){
		case GDK_F6:
			gtk_window_get_size(GTK_WINDOW(window), &width, &height);
			if(width >= 800 && height >= 480){
				gtk_window_unfullscreen(GTK_WINDOW(window));
			}//fullscreen?
			else{
				gtk_window_fullscreen(GTK_WINDOW(window));
			}
			return TRUE;
			break;
	}//switch on key pressed

#endif
	return FALSE;
}

void show_error_dialog(GtkWidget *mainwindow, const char *error_msg){
#ifdef HILDON
		hildon_banner_show_information(GTK_WIDGET(hildonwindow), NULL, error_msg);
#else
		GtkWidget *msgdialog = gtk_message_dialog_new(NULL, 0, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, "Error: %s",error_msg);
		gtk_dialog_run(GTK_DIALOG(msgdialog));
		gtk_widget_destroy(msgdialog);
#endif
}//show_error_dialog



#ifdef HILDON
HildonNumberEditor* get_ned(const char *spin_name) {
	GtkWidget	*w = glade_xml_get_widget(glade, spin_name);
	gchar *wname = g_strdup_printf("%s%s", spin_name, "_hildon");
	GList *list = gtk_container_get_children(GTK_CONTAINER(gtk_widget_get_ancestor(w, GTK_TYPE_HBOX))),
	      *cursor = NULL;

	if(cursor = g_list_find_custom(list, wname, check_name)) {
		w = GTK_WIDGET(cursor->data);
	}//if found
	
	g_list_free(list);
	g_free(wname);

	return HILDON_NUMBER_EDITOR(w);
}//get_ned


gint get_hildon_value(const char *spin_name) {
	HildonNumberEditor *ned = get_ned(spin_name);
	return ned? hildon_number_editor_get_value(ned): 0;
}//get_hildon_value


void set_hildon_value(const char *spin_name, gint val){
	HildonNumberEditor *ned = get_ned(spin_name);
	if(ned){ hildon_number_editor_set_value(ned, val); }
}//set_hildon_value


gint check_name(gconstpointer widget, gconstpointer name) {
	return widget?
		strcmp(gtk_widget_get_name(GTK_WIDGET(widget)), (char*)name):
		1;
}//check_name
#endif

