#ifndef _WINDOW_IPC_H_
#define _WINDOW_IPC_H_

#include <glib.h>

#if defined(GDK_WINDOWING_X11)
	#include <gdk/gdkx.h>
	#define GDK_NATIVE_WINDOW(wnd) ((guint)GDK_WINDOW_XID((wnd)))
#elif defined(GDK_WINDOWING_WIN32)
	#include <gdk/gdkwin32.h>
	#define GDK_NATIVE_WINDOW(wnd) ((guint)GDK_WINDOW_HWND((wnd)))
#else
	#define GDK_NATIVE_WINDOW(wnd) ((guint)(wnd))
#endif /* kind of windowing system */

#if defined(G_OS_UNIX)
#	define g_io_channel_new(fd) (g_io_channel_unix_new((fd)))
#elif defined(G_OS_WIN32)
#	define g_io_channel_new(fd) (g_io_channel_win32_new_fd((fd)))
#else
# define g_io_channel_new(fd) g_io_channel_new_is_not_supported
#endif

void write_window_id(int fd, guint window_id);
guint read_window_id(int fd);
char *read_string(int fd);

#endif /* !_WINDOW_IPC_H_ */
