#include <string.h>
#include <unistd.h>
#include <gtk/gtk.h>
#include "pleasewaitdialog.h"
#include "window-ipc.h"

#define PLEASE_WAIT_DIALOG_BIN_NAME "pidgin-otr-please-wait-dialog"

int 
please_wait_dialog_new(GtkWindow *parent, const char *account, const char *protocol)
{
    char *child_argv[] = {PLEASE_WAIT_DIALOG_BIN_NAME, NULL};
    gint child_stdin = -1;
    GError *error = NULL;
    guint window_id = 0;

    if (!gdk_spawn_on_screen_with_pipes(gdk_screen_get_default(), NULL, child_argv, NULL,
	G_SPAWN_SEARCH_PATH, NULL, NULL, NULL, &child_stdin, NULL, NULL, &error)) {
	g_warning("please_wait_dialog_new: Unable to spawn dialog: %s\n", error->message);
	g_error_free(error);
	return -1;
    }

    if (parent)
    	if (GTK_WIDGET(parent)->window)
	    window_id = GDK_NATIVE_WINDOW(GTK_WIDGET(parent)->window);

    write_window_id(child_stdin, window_id);
    write(child_stdin, account, strlen(account));
    write(child_stdin, "\0", 1);
    write(child_stdin, protocol, strlen(protocol));
    write(child_stdin, "\0", 1);

    return child_stdin;
}

void
please_wait_dialog_destroy(int please_wait_dialog)
{
    if (-1 == please_wait_dialog) return;

    write(please_wait_dialog, "Die!\n", 5);

    close(please_wait_dialog);
}
