/*
 * This is peekaboo ui source file
 *
 */

# include <string.h>
#include <sys/ioctl.h>
#include <net/if.h>
#include <unistd.h>
#include <arpa/inet.h>
#include <stdio.h>
#include <hildon-widgets/hildon-program.h>
#include <gtk/gtkmain.h>
#include <gtk/gtkbutton.h>
#include <gtk/gtk.h>            /* XXX: Change gtkmain to gtk */


int pid = 0;
int stream_on = 0;
GtkWidget *start_button;
GtkWidget *text_ipaddress;
GtkWidget *onair_ani_eb;
GtkWidget *onair_text_eb;

/* Check running peekaboo instances */
/*TODO*/






 /* take control of the camera at startup */
void hold_cam(void){
pid_t pid = fork();
        if (pid==0)  {
	  
	execl ("/usr/bin/peekaboo_hold_cam", "peekaboo_hold_cam", "", NULL);

	}
        else if (pid>0){
	}

}



/* Get local IP-address */
char *get_ipaddress(void)

{

	
	


    /* Create needed variables */
    char *retstr[22];
    char ifa[32];
    struct sockaddr_in *i;
    int fd;

    strcpy (retstr, "No network");

    strcpy (ifa, "wlan0");        /* Change 'wlan0' for maemo */

    if ((fd = socket (AF_INET, SOCK_DGRAM, 0)) == -1) return (retstr);

    if (ioctl (fd, SIOCGIFADDR, (struct ifreq *) ifa)) return (retstr);

    i = (struct sockaddr_in *) &ifa[16];
    strcpy (retstr, "http://");

    strcat (retstr, inet_ntoa (i->sin_addr));
    close (fd);

    return (retstr);
}

/* Write HTMl-file for incoming stream request */
void write_html_file(char * local_ip)
	
{
    FILE * fp;
    fp = fopen("/var/tmp/peekaboo/index.html","w");
    fprintf(fp,"<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd>\"\n");
    fprintf(fp,"<HTML>\n");
    fprintf(fp,"<link rel=\"icon\" href=\"favicon.ico\">\n");
    fprintf(fp,"<meta http-equiv=\"content-language\" content=\"en\">\n");
    fprintf(fp,"<TITLE>Peekaboo</TITLE>\n");
    fprintf(fp,"<body background=\"web_bg.png\">\n");
    fprintf(fp,"<center>\n");
    fprintf(fp,"<table id=\"Table_01\" width=\"448\" height=\"389\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\">\n");
    fprintf(fp,"<tr>\n");
    fprintf(fp,"<td colspan=\"3\"><img src=\"1.gif\" width=\"448\" height=\"84\" alt=\"\"></td>\n");
    fprintf(fp,"</tr>\n");
    fprintf(fp,"<tr>\n");
    fprintf(fp,"<td><img src=\"2.gif\" width=\"64\" height=\"241\" alt=\"\"></td>\n");
    fprintf(fp,"<td>\n");
    fprintf(fp,"<OBJECT id=\"mediaPlayer\" width=\"320\" height=\"241\" CLASSID=\"CLSID:22d6f312-b0f6-11d0-94ab-0080c74c7e95\" codebase=\"http://activex.microsoft.com/activex/controls/mplayer/en/nsmp2inf.cab#Version=5,1,52,701\" standby=\"Loading Microsoft Windows Media Player components...\" type=\"application/x-oleobject\">\n");
    fprintf(fp,"<PARAM NAME=\"filename\" VALUE=\"%s:8888\">\n", local_ip);
    fprintf(fp,"<PARAM NAME=\"animationatStart\" VALUE=\"true\">\n");
    fprintf(fp,"<PARAM NAME=\"transparentatStart\" VALUE=\"true\">\n");
    fprintf(fp,"<PARAM NAME=\"autoStart\" VALUE=\"true\">\n");
    fprintf(fp,"<PARAM NAME=\"showControls\" VALUE=\"false\">\n");
    fprintf(fp,"<PARAM name=\"loop\" VALUE=\"false\">\n");
    fprintf(fp,"<EMBED type=\"application/x-mplayer2\" pluginspage=\"http://microsoft.com/windows/mediaplayer/en/download/\" id=\"mediaPlayer\" name=\"mediaPlayer\" displaysize=\"4\" autosize=\"-1\" bgcolor=\"darkblue\" showcontrols=\"false\" showtracker=\"-1\" showdisplay=\"0\" showstatusbar=\"-1\" videoborder3d=\"-1\" width=\"320\" height=\"241\" src=\"%s:8888\" autostart=\"true\" designtimesp=\"5311\" loop=\"false\">\n", local_ip);
    fprintf(fp,"</EMBED>\n");
    fprintf(fp,"</OBJECT>\n");
    fprintf(fp,"</td>\n");
    fprintf(fp,"<td><img src=\"3.gif\" width=\"64\" height=\"241\" alt=\"\"></td>\n");
    fprintf(fp,"</tr>\n");
    fprintf(fp,"<tr>\n");
    fprintf(fp,"<td colspan=\"3\"><img src=\"4.gif\" width=\"448\" height=\"64\" alt=\"\"><td>\n");
    fprintf(fp,"</tr>\n");
    fprintf(fp,"</table>\n");
    fprintf(fp,"</body>");
    fprintf(fp,"</HTML>");
    fclose(fp);

}
/* Callback for "Close" menu entry and button */
void item_close_cb()
{
    g_print("Closing application...\n");

	pid =fork();
	if( pid == 0 )
	{
	g_print("prosessi vlc kill luotu.\n %s", pid);
	execl ("/usr/bin/killall", "killall", "", "vlc", NULL);

	}
    gtk_main_quit();
}

/* Callback for "Info" menu entry and button */
void item_help_cb(HildonWindow * main_window)
{
    GtkDialog *dialog;

    char * help_text = "Peekaboo 0.5\n\nhttp\://peekaboo.garage.maemo.org\n";

    dialog = hildon_note_new_information_with_icon_name(NULL, help_text, NULL);

    gtk_dialog_run(dialog);
    gtk_widget_destroy(dialog);


}

/* Callback for "Start" button */
void item_start_cb(HildonWindow * main_window)
{
    char *local_ip[25];
    char *local_ip_port[25];


    if (stream_on == 0) {

        strcpy (local_ip, get_ipaddress());
	strcpy (local_ip_port, get_ipaddress());
 	strcat (local_ip_port, ":8080");

        if (strcmp(local_ip, "No network") == 0) {

             hildon_banner_show_information(GTK_WIDGET(main_window), NULL, "No network");
             gtk_entry_set_text (GTK_ENTRY (text_ipaddress), "No network");

        } else {

             gtk_entry_set_text (GTK_ENTRY (text_ipaddress), local_ip_port);
             gtk_image_set_from_file (GTK_IMAGE(start_button), "/usr/var/peekaboo/graphics/nappi_stream_on.png");
	     gtk_widget_show (GTK_EVENT_BOX (onair_ani_eb));
             gtk_widget_show (GTK_EVENT_BOX (onair_text_eb));

             write_html_file(local_ip);

             g_print("Start stream...\n");
             stream_on = 1;
		        pid =fork();
		if( pid == 0 )
		{
		g_print("prosessi  vlc startup streamer luotu.\n", pid);
		execl ("/usr/bin/vlc_startup_streamer", "vlc_startup_streamer", "", NULL);
		}
        }
    } else {
        g_print("Stop stream...\n");
        stream_on = 0;
	pid =fork();
	if( pid == 0 )
	{
	g_print("prosessi vlc kill luotu.\n %s", pid);
	execl ("/usr/bin/killall", "killall", "", "vlc", NULL);

	}
        gtk_image_set_from_file (GTK_IMAGE(start_button), "/usr/var/peekaboo/graphics/nappi_stream_off.png");
	gtk_widget_hide (GTK_EVENT_BOX (onair_ani_eb));
        gtk_widget_hide (GTK_EVENT_BOX (onair_text_eb));

    }

}


/* Create the menu items needed for the main view */
static void create_menu(HildonWindow * main_window) 
{
    /* Create needed variables */
    GtkWidget *main_menu;
    GtkWidget *item_help;
    GtkWidget *item_close;

    /* Create new main menu */
    main_menu = gtk_menu_new();

    /* Create menu items */
    item_help = gtk_menu_item_new_with_label("Info");
    item_close = gtk_menu_item_new_with_label("Close");

    /* Add menu items to right menus */
    gtk_menu_append(main_menu, item_help);
    gtk_menu_append(main_menu, item_close);

    /* Add mainmenu to the window */
    hildon_window_set_menu(HILDON_WINDOW(main_window), GTK_MENU(main_menu));


    /* Attach the callback functions to the activate signal */
    g_signal_connect (G_OBJECT(item_close), "activate",
                     GTK_SIGNAL_FUNC(item_close_cb), NULL);

    /* Attach the callback functions to the activate signal */
    g_signal_connect (G_OBJECT(item_help), "activate",
                     GTK_SIGNAL_FUNC(item_help_cb), main_window);

    /* Make all menu widgets visible */
    gtk_widget_show_all (GTK_WIDGET(main_menu));

}


int main(int argc, char *argv[])
{
    /* Create needed variables */
    HildonProgram *program;
    HildonWindow *window;
    GtkWidget *fixed;
    GtkWidget *bground;
    GtkWidget *info_button;
    GtkWidget *info_button_eb;
    GtkWidget *close_button;
    GtkWidget *close_button_eb;
    GtkWidget *start_button_eb;
    GtkWidget *onair_ani;
    GtkWidget *onair_text;
    char *local_ip[25];

    /* Initialize the GTK. */
    gtk_init(&argc, &argv);


   /*copy html graphics and make temp http root folder if not exist */
   int ret1 = system("mkdir /var/tmp/peekaboo");
   int ret2 = system("cp /usr/var/peekaboo/html/* /var/tmp/peekaboo/");
   int ret3 = system("chmod 777 /var/tmp/peekaboo/");




   /* Create the hildon program and setup the title */
    program = HILDON_PROGRAM(hildon_program_get_instance());
    g_set_application_name("Peekaboo");

    /* Create HildonWindow and set it to HildonProgram */
    window = HILDON_WINDOW(hildon_window_new());
    hildon_program_add_window(program, window);

    /* Create fixed container */
    fixed = gtk_fixed_new ();
    gtk_container_add (GTK_CONTAINER (window), fixed);

    /* Create background and add it to main view */
    bground = gtk_image_new_from_file ("/usr/var/peekaboo/graphics/bg.png");
    gtk_fixed_put (GTK_FIXED (fixed), bground, 1, 1);

    /* Create infoe_button with eventbox and add it to main view */
    info_button = gtk_image_new_from_file ("/usr/var/peekaboo/graphics/nappi_info.png");
    info_button_eb = gtk_event_box_new ();
    gtk_event_box_set_visible_window (GTK_EVENT_BOX (info_button_eb), FALSE);
    gtk_container_add (GTK_CONTAINER (info_button_eb), info_button);
    gtk_fixed_put (GTK_FIXED (fixed), info_button_eb, 1, 1);

    /* Create close_button with eventbox and add it to main view */
    close_button = gtk_image_new_from_file ("/usr/var/peekaboo/graphics/nappi_sulje.png");
    close_button_eb = gtk_event_box_new ();
    gtk_event_box_set_visible_window (GTK_EVENT_BOX (close_button_eb), FALSE);
    gtk_container_add (GTK_CONTAINER (close_button_eb), close_button);
    gtk_fixed_put (GTK_FIXED (fixed), close_button_eb, 737, 1);

    /* Create start_button with eventbox and add it to main view */
    start_button = gtk_image_new_from_file ("/usr/var/peekaboo/graphics/nappi_stream_off.png");
    start_button_eb = gtk_event_box_new ();
    gtk_event_box_set_visible_window (GTK_EVENT_BOX (start_button_eb), FALSE);
    gtk_container_add (GTK_CONTAINER (start_button_eb), start_button);
    gtk_fixed_put (GTK_FIXED (fixed), start_button_eb, 631, 179);

    /* Create onair_ani with eventbox and add it to main view */
    onair_ani = gtk_image_new_from_file ("/usr/var/peekaboo/graphics/onair_ani.gif");
    onair_ani_eb = gtk_event_box_new ();
    gtk_event_box_set_visible_window (GTK_EVENT_BOX (onair_ani_eb), FALSE);
    gtk_container_add (GTK_CONTAINER (onair_ani_eb), onair_ani);
    gtk_fixed_put (GTK_FIXED (fixed), onair_ani_eb, 293, 210);

    /* Create onair_text with eventbox and add it to main view */
    onair_text = gtk_image_new_from_file ("/usr/var/peekaboo/graphics/onair_text.png");
    onair_text_eb = gtk_event_box_new ();
    gtk_event_box_set_visible_window (GTK_EVENT_BOX (onair_text_eb), FALSE);
    gtk_container_add (GTK_CONTAINER (onair_text_eb), onair_text);
    gtk_fixed_put (GTK_FIXED (fixed), onair_text_eb, 274, 248);

    /* Connect signal to X in the upper corner */
    g_signal_connect (G_OBJECT(window), "delete_event", G_CALLBACK (gtk_main_quit), NULL);

    /* Connect signal to info_button */
    g_signal_connect (G_OBJECT (info_button_eb), "button_release_event", GTK_SIGNAL_FUNC (item_help_cb), window);

    /* Connect signal to close_button */
    g_signal_connect (G_OBJECT (close_button_eb), "button_release_event", GTK_SIGNAL_FUNC (item_close_cb), NULL);

    /* Connect signal to start_button */
    g_signal_connect (G_OBJECT (start_button_eb), "button_release_event", GTK_SIGNAL_FUNC (item_start_cb), window);

    /* Create menu for view */
    create_menu(window);

    /* Show IP-address */
    text_ipaddress = gtk_entry_new ();
    gtk_fixed_put (GTK_FIXED (fixed), text_ipaddress, 237, 437);
    gtk_entry_set_editable (GTK_ENTRY (text_ipaddress), FALSE);
    gtk_entry_set_activates_default (GTK_ENTRY (text_ipaddress), FALSE);
    gtk_entry_set_max_length (GTK_ENTRY (text_ipaddress), 30);
    gtk_entry_set_has_frame (GTK_ENTRY (text_ipaddress), FALSE);
    gtk_entry_set_width_chars (GTK_ENTRY (text_ipaddress), 21);
    gtk_widget_set_sensitive (GTK_WIDGET (text_ipaddress), FALSE);
    strcpy (local_ip, get_ipaddress());
	
   

    /* if network is not available, do not display port number after text "No network" */
    if (strcmp(local_ip, "No network") != 0) {
        strcat (local_ip, ":8080");
    }
    gtk_entry_set_text (GTK_ENTRY (text_ipaddress), local_ip);


    /* Begin the main application */	
    gtk_widget_show_all (GTK_WIDGET (window));
    gtk_window_fullscreen (GTK_WINDOW (window));
    gtk_widget_hide (GTK_EVENT_BOX (onair_ani_eb));
    gtk_widget_hide (GTK_EVENT_BOX (onair_text_eb));


	
  hold_cam();




    gtk_main();



    /* Exit */
    return 0;
}
