#!/usr/bin/env python

# $HeadURL: http://svn.berlios.de/svnroot/repos/mirageiv/trunk/setup.py $
# $Id: setup.py 179 2007-01-17 19:21:55Z stonecrest $

from distutils.core import setup, Extension

setup(name='Mirage',
		version='0.8.3',
		description='A fast GTK+ image viewer',
		author='Scott Horowitz',
		author_email='stonecrest@gmail.com',
		url='http://mirageiv.berlios.de',
		classifiers=[
			'Environment :: X11 Applications',
			'Intended Audience :: End Users/Desktop',
			'License :: GNU General Public License (GPL)',
			'Operating System :: Linux',
			'Programming Language :: Python',
			'Topic :: Multimedia :: Graphics :: Viewers'
			],
#		py_modules = ['mirage'],
#		ext_modules = [Extension('imgfuncs', ['imgfuncs.c'])],
#		scripts = ['mirage'],
		data_files=[('share/mirage', ['README', 'COPYING', 'CHANGELOG', 'TRANSLATORS', 'pixmaps/stock_shuffle.png', 'pixmaps/stock_leave-fullscreen.png', 'pixmaps/stock_fullscreen.png', 'pixmaps/logo.png', 'build/lib.linux-i686-2.5/imgfuncs.so', 'mirage', 'mirage.py']),
			('share/applications/hildon', ['mirage.desktop']),
			('share/icons/hicolor/26x26/hildon', ['mirage.png']),
			('share/icons/hicolor/scalable/hildon', ['pixmaps/mirage.png']),
			('share/dbus-1/services', ['mirage.service']),			
			('share/locale/ru/LC_MESSAGES', ['locale/ru/LC_MESSAGES/mirage.mo']),
			('share/locale/pl/LC_MESSAGES', ['locale/pl/LC_MESSAGES/mirage.mo']),
			('share/locale/fr/LC_MESSAGES', ['locale/fr/LC_MESSAGES/mirage.mo']),
			('share/locale/es/LC_MESSAGES', ['locale/es/LC_MESSAGES/mirage.mo']),
			('share/locale/de/LC_MESSAGES', ['locale/de/LC_MESSAGES/mirage.mo']),
			('share/locale/it/LC_MESSAGES', ['locale/it/LC_MESSAGES/mirage.mo'])],
		)
