#! /bin/sh
# postinst script for osso-ic-test
#
# see: dh_installdeb(1)

set -e

# summary of how this script can be called:
#        * <postinst> `configure' <most-recently-configured-version>
#        * <old-postinst> `abort-upgrade' <new version>
#        * <conflictor's-postinst> `abort-remove' `in-favour' <package>
#          <new-version>
#        * <deconfigured's-postinst> `abort-deconfigure' `in-favour'
#          <failed-install-package> <version> `removing'
#          <conflicting-package> <version>
# for details, see http://www.debian.org/doc/debian-policy/ or
# the debian-policy package
#
# quoting from the policy:
#     Any necessary prompting should almost always be confined to the
#     post-installation script, and should be protected with a conditional
#     so that unnecessary prompting doesn't happen if a package's
#     installation fails and the `postinst' is called with `abort-upgrade',
#     `abort-remove' or `abort-deconfigure'.



case "configure" in
    configure)
  	# Setup default IAP in case it does not exists
  	# required during development with USB LAN adapter
	gconftool-2 --dir-exists "/system/osso/connectivity/IAP/DEFAULT" ||
		gconftool-2 --type string --set "/system/osso/connectivity/IAP/DEFAULT/type" "DUMMY"
  
	gconftool-2 --dir-exists "/system/osso/connectivity/IAP/GPRS@32@internet" ||
		(gconftool-2 --type string --set "/system/osso/connectivity/IAP/GPRS@32@internet/type" "DUN_GSM_PS" &&
		 gconftool-2 --type string --set "/system/osso/connectivity/IAP/GPRS@32@internet/ipv4_type" "AUTO" &&
		 gconftool-2 --type string --set "/system/osso/connectivity/IAP/GPRS@32@internet/proxytype" "NONE" &&
		 gconftool-2 --type string --set "/system/osso/connectivity/IAP/GPRS@32@internet/dun_ps_accesspointname" "internet" &&
		 gconftool-2 --type string --set "/system/osso/connectivity/IAP/GPRS@32@internet/dun_phonenumber" "*99***1#" &&
		 gconftool-2 --type string --set "/system/osso/connectivity/IAP/GPRS@32@internet/dun_username" "" &&
		 gconftool-2 --type string --set "/system/osso/connectivity/IAP/GPRS@32@internet/dun_password" "" &&
		 gconftool-2 --type bool --set "/system/osso/connectivity/IAP/GPRS@32@internet/dun_ppp_pap" true &&
		 gconftool-2 --type bool --set "/system/osso/connectivity/IAP/GPRS@32@internet/dun_ppp_compression" true &&
		 gconftool-2 --type bool --set "/system/osso/connectivity/IAP/GPRS@32@internet/ask_password" false)

	gconftool-2 --dir-exists "/system/osso/connectivity/IAP/Nokia@32@Test@32@Network" ||
		(gconftool-2 --type string --set "/system/osso/connectivity/IAP/Nokia@32@Test@32@Network/type" "DUN_GSM_PS" &&
		 gconftool-2 --type string --set "/system/osso/connectivity/IAP/Nokia@32@Test@32@Network/ipv4_type" "AUTO" &&
		 gconftool-2 --type string --set "/system/osso/connectivity/IAP/Nokia@32@Test@32@Network/proxytype" "NONE" &&
		 gconftool-2 --type string --set "/system/osso/connectivity/IAP/Nokia@32@Test@32@Network/dun_ps_accesspointname" "wirelessfuture.com" &&
		 gconftool-2 --type string --set "/system/osso/connectivity/IAP/Nokia@32@Test@32@Network/dun_phonenumber" "*99***1#" &&
		 gconftool-2 --type string --set "/system/osso/connectivity/IAP/Nokia@32@Test@32@Network/dun_username" "" &&
		 gconftool-2 --type string --set "/system/osso/connectivity/IAP/Nokia@32@Test@32@Network/dun_password" "" &&
		 gconftool-2 --type bool --set "/system/osso/connectivity/IAP/Nokia@32@Test@32@Network/dun_ppp_pap" true &&
		 gconftool-2 --type bool --set "/system/osso/connectivity/IAP/Nokia@32@Test@32@Network/dun_ppp_compression" true &&
		 gconftool-2 --type bool --set "/system/osso/connectivity/IAP/Nokia@32@Test@32@Network/ask_password" false)

	gconftool-2 --dir-exists "/system/osso/connectivity/IAP/osso@46@net@32@Tampere" ||
		(gconftool-2 --type string --set "/system/osso/connectivity/IAP/osso@46@net@32@Tampere/type" "WLAN_INFRA" &&
		 gconftool-2 --type string --set "/system/osso/connectivity/IAP/osso@46@net@32@Tampere/wlan_ssid" "osso.net" &&
		 gconftool-2 --type string --set "/system/osso/connectivity/IAP/osso@46@net@32@Tampere/ipv4_type" "AUTO" &&
		 gconftool-2 --type string --set "/system/osso/connectivity/IAP/osso@46@net@32@Tampere/proxytype" "NONE" &&
		 gconftool-2 --type string --set "/system/osso/connectivity/IAP/osso@46@net@32@Tampere/wlan_security" "NONE")

	gconftool-2 --dir-exists "/system/osso/connectivity/IAP/osso@46@net@32@Helsinki" ||
		(gconftool-2 --type string --set "/system/osso/connectivity/IAP/osso@46@net@32@Helsinki/type" "WLAN_INFRA" &&
		 gconftool-2 --type string --set "/system/osso/connectivity/IAP/osso@46@net@32@Helsinki/ipv4_type" "AUTO" &&
		 gconftool-2 --type string --set "/system/osso/connectivity/IAP/osso@46@net@32@Helsinki/wlan_ssid" "osso.net" &&
		 gconftool-2 --type string --set "/system/osso/connectivity/IAP/osso@46@net@32@Helsinki/proxytype" "MANUAL" &&
		 gconftool-2 --type string --set "/system/osso/connectivity/IAP/osso@46@net@32@Helsinki/proxy_http" "195.134.224.95" &&
		 gconftool-2 --type int --set "/system/osso/connectivity/IAP/osso@46@net@32@Helsinki/proxy_http_port" 3128 &&
		 gconftool-2 --type string --set "/system/osso/connectivity/IAP/osso@46@net@32@Helsinki/proxy_https" "195.134.224.95" &&
		 gconftool-2 --type int --set "/system/osso/connectivity/IAP/osso@46@net@32@Helsinki/proxy_https_port" 3128 &&
		 gconftool-2 --type string --set "/system/osso/connectivity/IAP/osso@46@net@32@Helsinki/proxy_ftp" "195.134.224.95" &&
		 gconftool-2 --type int --set "/system/osso/connectivity/IAP/osso@46@net@32@Helsinki/proxy_ftp_port" 3128 &&
		 gconftool-2 --type string --set "/system/osso/connectivity/IAP/osso@46@net@32@Helsinki/proxy_rtsp" "195.134.224.95" &&
		 gconftool-2 --type int --set "/system/osso/connectivity/IAP/osso@46@net@32@Helsinki/proxy_rtsp_port" 3128 &&

		 gconftool-2 --type int --set "/system/osso/connectivity/IAP/osso@46@net@32@Helsinki/wlan_wepdefkey" 1 &&
		 gconftool-2 --type string --set "/system/osso/connectivity/IAP/osso@46@net@32@Helsinki/wlan_wepkey1" "ACDC123456" &&
		 gconftool-2 --type string --set "/system/osso/connectivity/IAP/osso@46@net@32@Helsinki/wlan_security" "WEP" &&

		 gconftool-2 --type string --set "/system/osso/connectivity/IAP/ossoapapfr/wlan_wepkey1" "riiLoo9wophie" &&
		 gconftool-2 --type string --set "/system/osso/connectivity/IAP/ossoapapfr/wlan_security" "WEP" &&
		 gconftool-2 --type string --set "/system/osso/connectivity/IAP/ossoapapfr/type" "WLAN_INFRA" &&
		 gconftool-2 --type string --set "/system/osso/connectivity/IAP/ossoapapfr/ipv4_type" "AUTO" &&
		 gconftool-2 --type string --set "/system/osso/connectivity/IAP/ossoapapfr/wlan_ssid" "osso-ap-apf-r" &&
		 gconftool-2 --type string --set "/system/osso/connectivity/IAP/ossoapapfr/proxytype" "NONE")
		 
		 gconftool-2 --type int --set /apps/osso/applet/osso-applet-display/turn_off_display 6000000  
		 gconftool-2 --type int --set /apps/osso/applet/osso-applet-display/brightness_period 6000000
		 gconftool-2 --type int --set /system/osso/dsm/display/display_dim_timeout 6000000
		 gconftool-2 --type int --set /system/osso/dsm/display/display_blank_timeout 6000000
		 
        ;;

    abort-upgrade|abort-remove|abort-deconfigure)
        ;;

    *)
        echo "postinst called with unknown argument \`$1'" >&2
        exit 1
        ;;
esac

# dh_installdeb will replace this with shell code automatically
# generated by other debhelper scripts.

gconftool-2 --type string --set "/system/osso/connectivity/IAP/DEFAULT/type" "DUMMY"

gconftool-2 --type string --set "/system/osso/connectivity/IAP/DEFAULT/use_proxy" "true"

gconftool-2 --type string --set "/system/osso/connectivity/IAP/DEFAULT/use_http_proxy" "true"
gconftool-2 --type string --set "/system/osso/connectivity/IAP/DEFAULT/use_ftp_proxy" "true"
gconftool-2 --type string --set "/system/osso/connectivity/IAP/DEFAULT/use_https_proxy" "true"

gconftool-2 --type string --set "/system/osso/connectivity/IAP/DEFAULT/ipv4_type" "AUTO" &&
gconftool-2 --type string --set "/system/osso/connectivity/IAP/DEFAULT/proxytype" "MANUAL" &&

gconftool-2 --type string --set "/system/osso/connectivity/IAP/DEFAULT/proxy_http" "131.228.55.140"
gconftool-2 --type int --set "/system/osso/connectivity/IAP/DEFAULT/proxy_http_port" 8080

gconftool-2 --type string --set "/system/osso/connectivity/IAP/DEFAULT/proxy_https" "131.228.55.140" 
gconftool-2 --type int --set "/system/osso/connectivity/IAP/DEFAULT/proxy_https_port" 8080

gconftool-2 --type string --set "/system/osso/connectivity/IAP/DEFAULT/proxy_rtsp" "131.228.55.140"
gconftool-2 --type int --set "/system/osso/connectivity/IAP/DEFAULT/proxy_rtsp_port" 8080

gconftool-2 --type string --set "/system/osso/connectivity/IAP/DEFAULT/proxy_ftp" "131.228.55.140"
gconftool-2 --type int --set "/system/osso/connectivity/IAP/DEFAULT/proxy_ftp_port" 8080

gconftool-2 --type bool --set /system/http_proxy/use_http_proxy true
gconftool-2 --type string --set /system/http_proxy/host 131.228.55.140
gconftool-2 --type int --set /system/http_proxy/port 8080
		       
gconftool-2 --type string --set /system/proxy/secure_host 131.228.55.140
gconftool-2 --type int --set /system/proxy/secure_port 8080
gconftool-2 --type string --set /system/proxy/mode manual
			       
gconftool-2 --type string --set /system/proxy/ftp_host 131.228.55.140
gconftool-2 --type int --set /system/proxy/ftp_port 8080
gconftool-2 --type string --set /system/https_proxy/host 131.228.55.140
gconftool-2 --type int --set /system/https_proxy/port 8080


exit 0

