from Observable import Observable

import urllib2
import threading
import gobject


class Downloader(Observable):

    OBS_CONNECTING = 0
    OBS_SIZE_AVAILBLE = 1
    OBS_DOWNLOAD_STARTED = 2
    OBS_DOWNLOAD_FINISHED = 3
    OBS_DOWNLOAD_STATUS = 4
    OBS_DOWNLOAD_CANCELLED = 5
    OBS_ERROR = 6
    

    def __init__(self):
    
        self.__is_cancelled = False
        self.__keep_alive = None


    def __notify(self, *args):
    
        gobject.idle_add(self.update_observer, *args)


    def __stop_keep_alive(self):
    
        gobject.idle_add(gobject.source_remove, self.__keep_alive)


    def cancel(self):
    
        self.__is_cancelled = True
        
        
    def get(self, url):
    
        # argh! threads!
        t = threading.Thread(target = self.__download_thread,
                             args = [url])
        t.start()

        # this is a safer alternative to gtk.threads_init()
        # threading in Python is broken with GTK, so calling gtk.threads_init()
        # should be avoided at all cost!        
        self.__keep_alive = gobject.idle_add(lambda x:True, 0)


    def __download_thread(self, url):
          
        self.__is_cancelled = False
        
        self.__notify(self.OBS_CONNECTING)
        try:
            fd = urllib2.urlopen(url)
        except:
            import traceback; traceback.print_exc()
            self.__notify(self.OBS_ERROR)
            self.__stop_keep_alive()
            return
            
        self.__notify(self.OBS_DOWNLOAD_STARTED)
        total_size = fd.info().get("Content-Length", 0)
        if (total_size):
            self.__notify(self.OBS_SIZE_AVAILABLE, total_size)
        
        data = ""
        bytes_read = 0
        while (not self.__is_cancelled):
            new_data = fd.read(4096)
            if (not new_data):
                break
            
            data += new_data
            bytes_read += len(new_data)
            percentage = (100 * bytes_read / max(0.1, float(total_size)))
            self.__notify(self.OBS_DOWNLOAD_STATUS,
                          bytes_read, total_size, percentage)
        #end while
        
        fd.close()
        if (not self.__is_cancelled):
            self.__notify(self.OBS_DOWNLOAD_FINISHED, data)
        else:
            self.__notify(self.OBS_DOWNLOAD_CANCELLED)
        self.__stop_keep_alive()

