#!/usr/bin/env python
# -*- coding: UTF8 -*-
import gtk
import gtk.gdk
import hildon
import osso
import gobject
import bugz
import base64
import os
import sys
import cPickle
import locale
import thread
import ConfigParser
import os.path
import re
import urllib2

(
    COLUMN_NUMBER,
    COLUMN_DESCRIPTION,
	COLUMN_STATUS,
    COLUMN_SEVERITY,
	COLUMN_PRODUCT
) = range(5)

(COLUMN_FIXED, COLUMN_ATTACH, COLUMN_AID) = range(3)

data = []
status_list = []
severity_list = []
priority_list = []
attach_list = []
attach_gets = []
gtk.gdk.threads_init()

osso_c = osso.Context("py_mabugz", "0.0.2", False)

class PyBugz(hildon.Program):
	def __init__(self):
		self.MainWindow = hildon.Window()
		self.MainWindow.set_default_size(800, 480)
		self.MainWindow.set_title('Bug Search')
		self.MainWindow.connect("destroy", self.quit)
		self.MainWindow.connect("key-press-event", self.on_key_press)
		self.MainWindow.connect("window-state-event", self.on_window_state_change)
		self.window_in_fullscreen = False 

		## Get settings
		self.dat_file = os.path.join(sys.path[0], "/home/user/.mabugz/settings.dat")
		self.Settings = Settings(self.dat_file)
			
## Create menu       
		self.menubar = gtk.Menu()
		self.menubar.show()
		for child in self.menubar.get_children():
			child.reparent(menu)
		self.MainWindow.set_menu(self.menubar)

		self.menu_exit = gtk.ImageMenuItem("Exit")		
		exit_img = gtk.Image()
		if os.path.exists("/usr/share/mabugz/pixmaps/gtk-quit.png"):
			exit_img.set_from_file("/usr/share/mabugz/pixmaps/gtk-quit.png")
		else:
			exit_img.set_from_file("pixmaps/gtk-quit.png")
		self.menu_exit.set_image(exit_img)
		self.menu_exit.show()
		self.menu_exit.connect("activate", self.quit)

#Submenu settings
		self.menu_settings=gtk.ImageMenuItem("Settings")
		settings_img = gtk.Image()
		if os.path.exists("/usr/share/mabugz/pixmaps/gtk-preferences.png"):
			settings_img.set_from_file("/usr/share/mabugz/pixmaps/gtk-preferences.png")
		else:
			settings_img.set_from_file("pixmaps/gtk-preferences.png")			
		self.menu_settings.set_image(settings_img)
		self.menu_settings.show()
		self.menu_settings.connect("activate",self.on_settings_clicked)
		
#Submenu about		
		self.menu_about=gtk.ImageMenuItem("About")
		about_img = gtk.Image()
		if os.path.exists("/usr/share/mabugz/pixmaps/gtk-about.png"):
			about_img.set_from_file("/usr/share/mabugz/pixmaps/gtk-about.png")
		else:
			about_img.set_from_file("pixmaps/gtk-about.png")		
		self.menu_about.set_image(about_img)
		self.menu_about.show()
		self.menu_about.connect("activate", Credits)		

		self.menubar.append(self.menu_settings)
		self.menubar.append(self.menu_about)
		self.menubar.append(self.menu_exit)

		self.vbox1 = gtk.VBox(False, 0)
		self.vbox1.set_spacing(0)

		self.scrolledwindow1 = gtk.ScrolledWindow()
		self.scrolledwindow1.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_AUTOMATIC)
		self.scrolledwindow1.set_shadow_type(gtk.SHADOW_ETCHED_IN)

		# create tree model
		model = self.__create_model()

		self.treeview1 = gtk.TreeView(model)
		self.treeview1.add_events(gtk.gdk.BUTTON_PRESS_MASK)
		self.treeview1.connect("button-press-event", self.on_button_press, model)
		self.treeview1.set_rules_hint(True)
		self.treeview1.set_headers_visible(True)
		self.treeview1.set_search_column(COLUMN_DESCRIPTION)

		self.scrolledwindow1.add(self.treeview1)

		# add columns to the tree view
		self.__add_columns(self.treeview1)

		self.vbox1.pack_start(self.scrolledwindow1, True, True, 0)

		self.hbox1 = gtk.HBox(False, 0)
		self.hbox1.set_spacing(0)

		self.entry1 = gtk.Entry()
		self.entry1.set_text("")
		self.entry1.set_editable(True)
		self.entry1.set_visibility(True)
		self.entry1.set_activates_default(True)
		self.entry1.connect("activate", self.on_search_clicked, model)
		self.hbox1.pack_start(self.entry1, True, True, 0)

		self.hbuttonbox1 = gtk.HButtonBox()
		self.hbuttonbox1.set_spacing(0)
		self.hbuttonbox1.set_layout(gtk.BUTTONBOX_DEFAULT_STYLE)

		# Search button
		self.button1 = gtk.Button()
		search_img = gtk.Image()
		if os.path.exists("/usr/share/mabugz/pixmaps/gtk-search.png"):
			search_img.set_from_file("/usr/share/mabugz/pixmaps/gtk-search.png")
		else:
			search_img.set_from_file("pixmaps/gtk-search.png")
		self.button1.add(search_img)
		self.button1.connect("clicked", self.on_search_clicked, model)
		self.button1.set_size_request(50, -1)

		#Clear button
		self.button2 = gtk.Button()
		clear_img = gtk.Image()
		if os.path.exists("/usr/share/mabugz/pixmaps/gtk-clear.png"):
			clear_img.set_from_file("/usr/share/mabugz/pixmaps/gtk-clear.png")
		else:
			clear_img.set_from_file("pixmaps/gtk-clear.png")
		self.button2.add(clear_img)		
		self.button2.connect("clicked", self.on_clear_menu, model)
		self.button2.set_size_request(50, -1)

		# Get button
		self.button3 = gtk.Button()
		get_img = gtk.Image()
		if os.path.exists("/usr/share/mabugz/pixmaps/gtk-get.png"):
			get_img.set_from_file("/usr/share/mabugz/pixmaps/gtk-get.png")
		else:
			get_img.set_from_file("pixmaps/gtk-get.png")
		self.button3.add(get_img)				
		self.button3.connect("clicked", self.on_get_clicked, model)
		self.button3.set_size_request(50, -1)

		#Filter button
		self.button4 = gtk.Button()
		filter_img = gtk.Image()
		if os.path.exists("/usr/share/mabugz/pixmaps/gtk-filter.png"):
			filter_img.set_from_file("/usr/share/mabugz/pixmaps/gtk-filter.png")
		else:
			filter_img.set_from_file("pixmaps/gtk-filter.png")
		self.button4.add(filter_img)			
		self.button4.connect("clicked", self.on_filter_menu)		
		self.button4.set_size_request(50, -1)

		#add buttons to hbuttonbox
		self.hbuttonbox1.pack_start(self.button1)
		self.hbuttonbox1.pack_start(self.button2)
		self.hbuttonbox1.pack_start(self.button4)
		self.hbuttonbox1.pack_start(self.button3)

		self.hbox1.pack_start(self.hbuttonbox1, False, False, 0)

		self.vbox1.pack_start(self.hbox1, False, True, 0)

		self.MainWindow.add(self.vbox1)

		self.MainWindow.show_all()

	#Functions for fullscreen
	def on_window_state_change(self, widget, event, *args):           
		if event.new_window_state & gtk.gdk.WINDOW_STATE_FULLSCREEN:
			self.window_in_fullscreen = True
		else:
			self.window_in_fullscreen = False

	def on_key_press(self, widget, event, *args):            
		if event.keyval == gtk.keysyms.F6:
			if self.window_in_fullscreen:
				self.MainWindow.unfullscreen ()
			else:
				self.MainWindow.fullscreen ()

	def on_button_press(self, widget, event, model):
		if event.button == 1 and event.type == gtk.gdk._2BUTTON_PRESS:
			self.on_get_clicked(widget, model)
			

	def quit(self, widget):
		"""Quit yourself"""
		self.Settings.save(self.dat_file)
		gtk.main_quit()
		
	def on_clear_menu(self, widget, lstore):
		clearMenu = gtk.Menu()
		clearMenu1 = gtk.ImageMenuItem('Clear All')
		clearMenu1.connect('activate', self.on_clear_all, lstore)
		clearMenu2 = gtk.ImageMenuItem('Clear Search')
		clearMenu2.connect('activate', self.on_clear_search, lstore)
		
		clearfilterMenu = gtk.Menu()
		clearMenu3 = gtk.MenuItem("Clear Filters")
		clearMenu3.set_submenu(clearfilterMenu)

		clearfilterMenuAll = gtk.ImageMenuItem("Clear All") 
		clearfilterMenuAll.connect("activate",self.on_clear_all_filters)

		clearfilterMenuSta = gtk.ImageMenuItem("Clear Status") 
		clearfilterMenuSta.connect("activate",self.on_clear_status)

		clearfilterMenuSev = gtk.ImageMenuItem("Clear Severity")
		clearfilterMenuSev.connect("activate",self.on_clear_severity)

		clearfilterMenuPri = gtk.ImageMenuItem("Clear Priority")
		clearfilterMenuPri.connect("activate",self.on_clear_priority)

		clearfilterMenuAsi = gtk.ImageMenuItem("Clear Assignee")
		clearfilterMenuAsi.connect("activate",self.on_clear_assignee)

		clearfilterMenuRep = gtk.ImageMenuItem("Clear Reporter")
		clearfilterMenuRep.connect("activate",self.on_clear_reporter)

		clearfilterMenuComp = gtk.ImageMenuItem("Clear Component")
		clearfilterMenuComp.connect("activate",self.on_clear_component)

		clearfilterMenuPro = gtk.ImageMenuItem("Clear Product")
		clearfilterMenuPro.connect("activate",self.on_clear_product)

		clearfilterMenu.append(clearfilterMenuPro)
		clearfilterMenu.append(clearfilterMenuComp)
		clearfilterMenu.append(clearfilterMenuRep)
		clearfilterMenu.append(clearfilterMenuAsi)
		clearfilterMenu.append(clearfilterMenuPri)
		clearfilterMenu.append(clearfilterMenuSev)
		clearfilterMenu.append(clearfilterMenuSta)
		clearfilterMenu.append(clearfilterMenuAll)		
		
		clearMenu.add(clearMenu3)
		clearMenu.add(clearMenu1)
		clearMenu.add(clearMenu2)

		clearMenu.show_all()
# parent_menu_shell, parent_menu_item, func, button, activate_time, data=None
		clearMenu.popup(None, None, None, 1, 0)		
		
	def on_clear_all(self, widget, lstore):
		lstore.clear()
		self.entry1.set_text("")	
		del status_list[:]
		del severity_list[:]
		del priority_list[:]
		self.enAsisearch = None		
		self.enRepSearch = None
		self.enCompSearch = None
		self.enProSearch = None

	def on_clear_search(self, widget, lstore):
		lstore.clear()
		self.entry1.set_text("")

	def on_clear_all_filters(self, widget):
		del status_list[:]			
		del severity_list[:]
		del priority_list[:]
		self.enAsisearch = None
		self.enRepSearch = None
		self.enCompSearch = None
		self.enProSearch = None

	def on_clear_status(self, widget):
		del status_list[:]	

	def on_clear_severity(self, widget):
		del severity_list[:]
		
	def on_clear_priority(self, widget):
		del priority_list[:]		

	def on_clear_assignee(self, widget):
		self.enAsisearch = None

	def on_clear_reporter(self, widget):
		self.enRepSearch = None

	def on_clear_component(self, widget):
		self.enCompSearch = None

	def on_clear_product(self, widget):
		self.enProSearch = None
		
	def on_filter_menu(self, widget):
		filterMenu = gtk.Menu()
		filterMenu1 = gtk.ImageMenuItem('Filter Status')
		filterMenu1.connect('activate', self.on_filter_status)
		filterMenu2 = gtk.ImageMenuItem('Filter Severity')
		filterMenu2.connect('activate', self.on_filter_severity)		
		filterMenu3 = gtk.ImageMenuItem('Filter Priority')
		filterMenu3.connect('activate', self.on_filter_priority)		
		filterMenu4 = gtk.ImageMenuItem('Filter Assignee')
		filterMenu4.connect('activate', self.on_filter_assignee)		
		filterMenu5 = gtk.ImageMenuItem('Filter Reporter')
		filterMenu5.connect('activate', self.on_filter_reporter)
		filterMenu6 = gtk.ImageMenuItem('Filter Component')
		filterMenu6.connect('activate', self.on_filter_component)		
		filterMenu7 = gtk.ImageMenuItem('Filter Product')
		filterMenu7.connect('activate', self.on_filter_product)
		
		filterMenu.add(filterMenu1)
		filterMenu.add(filterMenu2)
		filterMenu.add(filterMenu3)
		filterMenu.add(filterMenu4)
		filterMenu.add(filterMenu5)
		filterMenu.add(filterMenu6)
		filterMenu.add(filterMenu7)
	
		filterMenu.show_all()
# parent_menu_shell, parent_menu_item, func, button, activate_time, data=None
		filterMenu.popup(None, None, None, 1, 0)

	def on_filter_status(self, widget):
		self.FilterSta_dlg = gtk.Dialog(title='Filter Status', parent=None, flags=gtk.DIALOG_MODAL | gtk.WIN_POS_CENTER, buttons=(gtk.STOCK_OK, gtk.RESPONSE_OK, gtk.STOCK_CANCEL, gtk.RESPONSE_CLOSE))
		
		checkbutton1 = gtk.CheckButton('Unconfirmed')
		checkbutton2 = gtk.CheckButton('New')		
		checkbutton3 = gtk.CheckButton('Assigned')	
		checkbutton4 = gtk.CheckButton('Reopened')
		checkbutton5 = gtk.CheckButton('Resolved')		
		checkbutton6 = gtk.CheckButton('Verified')			
		checkbutton7 = gtk.CheckButton('Closed')			
			
		self.FilterSta_dlg.vbox.pack_start(checkbutton1, False, False, 0)
		self.FilterSta_dlg.vbox.pack_start(checkbutton2, False, False, 0)	
		self.FilterSta_dlg.vbox.pack_start(checkbutton3, False, False, 0)
		self.FilterSta_dlg.vbox.pack_start(checkbutton4, False, False, 0)
		self.FilterSta_dlg.vbox.pack_start(checkbutton5, False, False, 0)	
		self.FilterSta_dlg.vbox.pack_start(checkbutton6, False, False, 0)		
		self.FilterSta_dlg.vbox.pack_start(checkbutton7, False, False, 0)	
		del status_list[:]

		self.FilterSta_dlg.show_all()
		result = self.FilterSta_dlg.run()
		if (result == gtk.RESPONSE_OK):
			if checkbutton1.get_active() == True:
				status_list.append('Unconfirmed')
			if checkbutton2.get_active() == True:
				status_list.append('New')
			if checkbutton3.get_active() == True:
				status_list.append('Assigned')
			if checkbutton4.get_active() == True:
				status_list.append('Reopened')
			if checkbutton5.get_active() == True:
				status_list.append('Resolved')
			if checkbutton6.get_active() == True:
				status_list.append('Verified')	
			if checkbutton7.get_active() == True:
				status_list.append('Closed')								
			print status_list
			self.FilterSta_dlg.destroy()
		self.FilterSta_dlg.destroy()
		
	def on_filter_severity(self, widget):
		self.FilterSev_dlg = gtk.Dialog(title='Filter Severity', parent=None, flags=gtk.DIALOG_MODAL | gtk.WIN_POS_CENTER, buttons=(gtk.STOCK_OK, gtk.RESPONSE_OK, gtk.STOCK_CANCEL, gtk.RESPONSE_CLOSE))
		
		checkbutton1 = gtk.CheckButton('Blocker')
		checkbutton2 = gtk.CheckButton('Critical')		
		checkbutton3 = gtk.CheckButton('Major')	
		checkbutton4 = gtk.CheckButton('Normal')
		checkbutton5 = gtk.CheckButton('Minor')		
		checkbutton6 = gtk.CheckButton('Trivial')			
		checkbutton7 = gtk.CheckButton('Enhancement')			
			
		self.FilterSev_dlg.vbox.pack_start(checkbutton1, False, False, 0)
		self.FilterSev_dlg.vbox.pack_start(checkbutton2, False, False, 0)	
		self.FilterSev_dlg.vbox.pack_start(checkbutton3, False, False, 0)
		self.FilterSev_dlg.vbox.pack_start(checkbutton4, False, False, 0)
		self.FilterSev_dlg.vbox.pack_start(checkbutton5, False, False, 0)	
		self.FilterSev_dlg.vbox.pack_start(checkbutton6, False, False, 0)		
		self.FilterSev_dlg.vbox.pack_start(checkbutton7, False, False, 0)	
		del severity_list[:]

		self.FilterSev_dlg.show_all()
		result = self.FilterSev_dlg.run()
		if (result == gtk.RESPONSE_OK):
			if checkbutton1.get_active() == True:
				severity_list.append('Blocker')
			if checkbutton2.get_active() == True:
				severity_list.append('Critical')
			if checkbutton3.get_active() == True:
				severity_list.append('Major')
			if checkbutton4.get_active() == True:
				severity_list.append('Normal')
			if checkbutton5.get_active() == True:
				severity_list.append('Minor')
			if checkbutton6.get_active() == True:
				severity_list.append('Trivial')	
			if checkbutton7.get_active() == True:
				severity_list.append('Enhancement')								
			print severity_list
			self.FilterSev_dlg.destroy()
		self.FilterSev_dlg.destroy()

	def on_filter_priority(self, widget):
		self.FilterPri_dlg = gtk.Dialog(title='Filter Priority', parent=None, flags=gtk.DIALOG_MODAL | gtk.WIN_POS_CENTER, buttons=(gtk.STOCK_OK, gtk.RESPONSE_OK, gtk.STOCK_CANCEL, gtk.RESPONSE_CLOSE))
		
		checkbutton1 = gtk.CheckButton('P1')
		checkbutton2 = gtk.CheckButton('P2')		
		checkbutton3 = gtk.CheckButton('P3')	
		checkbutton4 = gtk.CheckButton('P4')
		checkbutton5 = gtk.CheckButton('P5')		
			
			
		self.FilterPri_dlg.vbox.pack_start(checkbutton1, False, False, 0)
		self.FilterPri_dlg.vbox.pack_start(checkbutton2, False, False, 0)	
		self.FilterPri_dlg.vbox.pack_start(checkbutton3, False, False, 0)
		self.FilterPri_dlg.vbox.pack_start(checkbutton4, False, False, 0)
		self.FilterPri_dlg.vbox.pack_start(checkbutton5, False, False, 0)	
	
		del priority_list[:]

		self.FilterPri_dlg.show_all()
		result = self.FilterPri_dlg.run()
		if (result == gtk.RESPONSE_OK):
			if checkbutton1.get_active() == True:
				priority_list.append('P1')
			if checkbutton2.get_active() == True:
				priority_list.append('P2')
			if checkbutton3.get_active() == True:
				priority_list.append('P3')
			if checkbutton4.get_active() == True:
				priority_list.append('P4')
			if checkbutton5.get_active() == True:
				priority_list.append('P5')							
			print priority_list
			self.FilterPri_dlg.destroy()
		self.FilterPri_dlg.destroy()	

	def on_filter_assignee(self, widget):
		self.FilterAsi_dlg = gtk.Dialog(title='Filter Assignee', parent=None, flags=gtk.DIALOG_MODAL | gtk.WIN_POS_CENTER, buttons=(gtk.STOCK_OK, gtk.RESPONSE_OK, gtk.STOCK_CANCEL, gtk.RESPONSE_CLOSE))
		
		
		self.enAssignee = gtk.Entry()
		self.enAssignee.set_text('')
		self.enAssignee.set_editable(True)
		
		self.FilterAsi_dlg.vbox.pack_start(self.enAssignee, False, False, 0)	
	
		self.FilterAsi_dlg.show_all()
		
		result = self.FilterAsi_dlg.run()
		if (result == gtk.RESPONSE_OK):
			self.enAsisearch = self.enAssignee.get_text()
			self.FilterAsi_dlg.destroy()
		self.FilterAsi_dlg.destroy()	

	def on_filter_reporter(self, widget):
		self.FilterRep_dlg = gtk.Dialog(title='Filter Reporter', parent=None, flags=gtk.DIALOG_MODAL | gtk.WIN_POS_CENTER, buttons=(gtk.STOCK_OK, gtk.RESPONSE_OK, gtk.STOCK_CANCEL, gtk.RESPONSE_CLOSE))
		
		self.enReporter = gtk.Entry()
		self.enReporter.set_text('')
		self.enReporter.set_editable(True)
		
		self.FilterRep_dlg.vbox.pack_start(self.enReporter, False, False, 0)	
	
		self.FilterRep_dlg.show_all()
		
		result = self.FilterRep_dlg.run()
		if (result == gtk.RESPONSE_OK):
			self.enRepSearch = self.enReporter.get_text()
			self.FilterRep_dlg.destroy()
		self.FilterRep_dlg.destroy()

	def on_filter_component(self, widget):
		self.FilterComp_dlg = gtk.Dialog(title='Filter Component', parent=None, flags=gtk.DIALOG_MODAL | gtk.WIN_POS_CENTER, buttons=(gtk.STOCK_OK, gtk.RESPONSE_OK, gtk.STOCK_CANCEL, gtk.RESPONSE_CLOSE))
		
		#TODO: Treeview with component list
		self.enComponent = gtk.Entry()
		self.enComponent.set_text('')
		self.enComponent.set_editable(True)
		
		self.FilterComp_dlg.vbox.pack_start(self.enComponent, False, False, 0)	
	
		self.FilterComp_dlg.show_all()
		
		result = self.FilterComp_dlg.run()
		if (result == gtk.RESPONSE_OK):
			self.enCompSearch = self.enComponent.get_text()
			self.FilterComp_dlg.destroy()
		self.FilterComp_dlg.destroy()

	def on_filter_product(self, widget):
		self.FilterPro_dlg = gtk.Dialog(title='Filter Product', parent=None, flags=gtk.DIALOG_MODAL | gtk.WIN_POS_CENTER, buttons=(gtk.STOCK_OK, gtk.RESPONSE_OK, gtk.STOCK_CANCEL, gtk.RESPONSE_CLOSE))
		
		#TODO: Treeview with product list
		self.enProduct = gtk.Entry()
		self.enProduct.set_text('')
		self.enProduct.set_editable(True)
		
		self.FilterPro_dlg.vbox.pack_start(self.enProduct, False, False, 0)	
	
		self.FilterPro_dlg.show_all()
		
		result = self.FilterPro_dlg.run()
		if (result == gtk.RESPONSE_OK):
			self.enProSearch = self.enProduct.get_text()
			self.FilterPro_dlg.destroy()
		self.FilterPro_dlg.destroy()


	def on_settings_clicked(self, widget):
		"""Called when the settings button is clicked.  It will
		show the Settings dialog and let the user set the Bugzilla
		settings."""

		result = gtk.RESPONSE_CANCEL		
	
		self.settings_dlg = gtk.Dialog(title='Settings', parent=None, flags=gtk.DIALOG_MODAL | gtk.WIN_POS_CENTER, buttons=(gtk.STOCK_OK, gtk.RESPONSE_OK, gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL))
		self.settings_dlg.set_border_width(6)
		self.settings_dlg.set_default_size(480, 200)

		self.table1 = gtk.Table()
		self.table1.show()
		self.table1.set_row_spacings(0)
		self.table1.set_col_spacings(0)

		self.label1 = gtk.Label("URL:")
		self.label1.set_alignment(0, 0.5)
		self.label1.set_padding(0, 0)
		self.label1.show()
		self.table1.attach(self.label1, 0, 1, 0, 1, gtk.FILL, 0, 0, 0)

		self.label2 = gtk.Label("Username:")
		self.label2.set_alignment(0, 0.5)
		self.label2.set_padding(0, 0)
		self.label2.show()
		self.table1.attach(self.label2, 0, 1, 1, 2, gtk.FILL, 0, 0, 0)

		self.label3 = gtk.Label("Password")
		self.label3.set_alignment(0, 0.5)
		self.label3.set_padding(0, 0)
		self.label3.show()
		self.table1.attach(self.label3, 0, 1, 2, 3, gtk.FILL, 0, 0, 0)

		self.enURL = gtk.Entry()
		self.enURL.set_text(self.Settings.URL)
		self.enURL.set_editable(True)
		self.enURL.show()
		self.enURL.set_visibility(True)
		self.table1.attach(self.enURL, 1, 2, 0, 1, gtk.EXPAND|gtk.FILL, 0, 0, 0)

		self.enUsername = gtk.Entry()
		self.enUsername.set_text(self.Settings.Username)
		self.enUsername.set_editable(True)
		self.enUsername.show()
		self.enUsername.set_visibility(True)
		self.table1.attach(self.enUsername, 1, 2, 1, 2, gtk.EXPAND|gtk.FILL, 0, 0, 0)

		self.enPassword = gtk.Entry()
		self.enPassword.set_text(self.Settings.Password)
		self.enPassword.set_editable(True)
		self.enPassword.show()
		self.enPassword.set_visibility(False)
		self.enPassword.set_invisible_char('*')
		self.table1.attach(self.enPassword, 1, 2, 2, 3, gtk.EXPAND|gtk.FILL, 0, 0, 0)

		self.label4 = gtk.Label("Color Text")
		self.label4.set_alignment(0, 0.5)
		self.label4.set_padding(0, 0)
		self.label4.show()
		self.table1.attach(self.label4, 0, 1, 3, 4, gtk.FILL, 0, 0, 0)

		self.color_button = gtk.ColorButton()
		try:
			get_gdk_color = gtk.gdk.color_parse(self.Settings.Text_Color)
			self.color_button.set_color(get_gdk_color)
		except:
			get_gdk_color = gtk.gdk.color_parse("#0000FE")
			self.color_button.set_color(get_gdk_color)
		self.color_button.show()
		self.table1.attach(self.color_button, 1, 2, 3, 4, gtk.EXPAND|gtk.EXPAND, 0, 0, 0)

		self.label5 = gtk.Label("Search comments:")
		self.label5.set_alignment(0, 0.5)
		self.label5.set_padding(0, 0)
		self.label5.show()
		self.table1.attach(self.label5, 0, 1, 4, 5, gtk.FILL, 0, 0, 0)

		self.comm_button = gtk.CheckButton()
		try:
			if self.Settings.Comments == 'True':
				self.comm_button.set_active(True)
		except:
			self.Settings.Comments == 'False'
			self.comm_button.set.active(False)
		self.comm_button.show()
		self.table1.attach(self.comm_button, 1, 2, 4, 5, gtk.EXPAND|gtk.EXPAND, 0, 0, 0)

		self.settings_dlg.vbox.pack_start(self.table1, True, True, 0)
		
		self.settings_dlg.show_all()

		result = self.settings_dlg.run()
		if (result==gtk.RESPONSE_OK):
			#get the value of the entry fields
			self.Settings.URL = self.enURL.get_text()
			self.Settings.Username = self.enUsername.get_text()
			self.Settings.Password = self.enPassword.get_text()
			text_color = gtk.color_selection_palette_to_string([self.color_button.get_color()])
			self.Settings.Text_Color = text_color
			self.Settings.Comments = str(self.comm_button.get_active())

		#we are done with the dialog, destroy it
		self.settings_dlg.destroy()

		#return the result
		return result
		
	def __create_model(self):
		lstore = gtk.ListStore(
			gobject.TYPE_UINT,
			gobject.TYPE_STRING,
			gobject.TYPE_STRING,
			gobject.TYPE_STRING,
			gobject.TYPE_STRING)

		for item in data:
			iter = lstore.append()
			lstore.set(iter,
				COLUMN_NUMBER, item[COLUMN_NUMBER],
				COLUMN_DESCRIPTION, item[COLUMN_DESCRIPTION],
				COLUMN_STATUS, item[COLUMN_STATUS],
				COLUMN_SEVERITY, item[COLUMN_SEVERITY],
				COLUMN_PRODUCT, item[COLUMN_PRODUCT])
		return lstore

	def __add_columns(self, treeview):
		model = treeview.get_model()

		# column for bug numbers
		column = gtk.TreeViewColumn('Bug', gtk.CellRendererText(),
                                    text=COLUMN_NUMBER)
		column.set_sort_column_id(COLUMN_NUMBER)
		treeview.append_column(column)

		# column for description
		column = gtk.TreeViewColumn('Description', gtk.CellRendererText(),
                                     text=COLUMN_DESCRIPTION)
		column.set_sort_column_id(COLUMN_DESCRIPTION)
		column.set_min_width(400)
		column.set_sizing(gtk.TREE_VIEW_COLUMN_FIXED)
		column.set_resizable(True)
		treeview.append_column(column)

		# columns for status
		column = gtk.TreeViewColumn('Status', gtk.CellRendererText(),
                                    text=COLUMN_STATUS)
		column.set_sort_column_id(COLUMN_STATUS)
		treeview.append_column(column)

		# columns for severities
		column = gtk.TreeViewColumn('Severity', gtk.CellRendererText(),
                                    text=COLUMN_SEVERITY)
		column.set_sort_column_id(COLUMN_SEVERITY)
		treeview.append_column(column)

		# column for product
		column = gtk.TreeViewColumn('Product', gtk.CellRendererText(),
                                     text=COLUMN_PRODUCT)
		column.set_sort_column_id(COLUMN_PRODUCT)
		treeview.append_column(column)

	def on_search_clicked(self, widget, lstore):
		self._do_widgets_insensitive()
		self.pgbar = ProgressBar("Searching bugs")	
		thread.start_new_thread(self.on_search_conn, (lstore,))		
		
	def on_search_conn(self, lstore):
		pybugz = self.Settings.create_bugzilla_client()
		if (pybugz == None):
			self.pgbar.stop_pg()
			thread.start_new_thread(MsgDialog, (gtk.MESSAGE_ERROR, "Error creating Bugzilla client, please check settings."))
			return

		search_term = self.entry1.get_text()

		try:
			if self.Settings.Comments == 'False':
				search_comm = False
			elif self.Settings.Comments == 'True':
				search_comm = True
		except:
			search_comm = False

		try:
			assigned_term = self.enAsisearch
		except:
			assigned_term = None
			
		try:
			reporter_term = self.enRepSearch
		except:
			reporter_term = None

		try:
			component_term = self.enCompSearch
		except:
			component_term = None

		try:
			product_term = self.enProSearch
		except:
			product_term = None
			
		try:
			result = pybugz.search(search_term, comments = search_comm, status = status_list, severity = severity_list, priority = priority_list, assigned_to = assigned_term, reporter = reporter_term, component = component_term, product = product_term)
			thread.start_new_thread(self.on_search_trat, (lstore, result))
		except ValueError:
			self.pgbar.stop_pg()
			self._do_widgets_sensitive()
			thread.start_new_thread(MsgDialog, (gtk.MESSAGE_ERROR, "Error: Bad Url."))			
		except RuntimeError:
			self.pgbar.stop_pg()
			self._do_widgets_sensitive()
			thread.start_new_thread(MsgDialog, (gtk.MESSAGE_ERROR, "Error: Failed to login."))
		except urllib2.URLError:
			self.pgbar.stop_pg()
			self._do_widgets_sensitive()
			thread.start_new_thread(MsgDialog, (gtk.MESSAGE_ERROR, "Error: Please check settings"))

	def on_search_trat(self, lstore, result):
		#Clear the before search at the ListStore
		gtk.gdk.threads_enter()
		lstore.clear()
		gtk.gdk.threads_leave()

		if result == None:
			self.pgbar.stop_pg()
			self._do_widgets_sensitive()
			thread.start_new_thread(MsgDialog, (gtk.MESSAGE_ERROR, "Error: Failed to perform search"))

		if len(result) == 0:
			#TODO: create dialog??
			iter = lstore.append()
			gtk.gdk.threads_enter()
			lstore.set (iter,
				COLUMN_NUMBER, 0,
				COLUMN_DESCRIPTION, 'No bugs found',
				COLUMN_STATUS, '',
				COLUMN_SEVERITY, '',
				COLUMN_PRODUCT, '')
			self.pgbar.stop_pg()
			gtk.gdk.threads_leave()
			self._do_widgets_sensitive()
			return


		for row in result:
			bugid = row['bugid']
			desc = row['desc']
			status = row['status']
			severity = row['severity']
			assignee = row['assignee'].split('@')[0]

			one_result = (int(bugid), str(desc), str(status), str(severity), str(assignee))
			data.append(one_result)

			iter = lstore.append()

			gtk.gdk.threads_enter()
			lstore.set (iter,
				COLUMN_NUMBER, one_result[COLUMN_NUMBER],
				COLUMN_DESCRIPTION, one_result[COLUMN_DESCRIPTION],
				COLUMN_STATUS, one_result[COLUMN_STATUS],
				COLUMN_SEVERITY, one_result[COLUMN_SEVERITY],
				COLUMN_PRODUCT, one_result[COLUMN_PRODUCT])
			gtk.gdk.threads_leave()

		self.pgbar.stop_pg()
		self._do_widgets_sensitive()

	def on_get_clicked(self, widget, lstore):
		self._do_widgets_insensitive()
		a = thread.start_new_thread(self.on_get_trat, (widget, lstore))
		self.pgbar = ProgressBar("Getting bug")


	def on_get_trat(self, widget, lstore):
		#get the bug text
		hele = self.treeview1.get_selection()
		model, iter = hele.get_selected()
		if iter:
			bugid = lstore.get_value(iter, COLUMN_NUMBER)
		else:
			self._do_widgets_sensitive()
			self.pgbar.stop_pg()
			thread.start_new_thread(MsgDialog, (gtk.MESSAGE_ERROR, "Error: No Bug ID."))
			return
		# descargar el texto del bug
		pybugz = self.Settings.create_bugzilla_client()
		if (pybugz == None):
			self._do_widgets_sensitive()
			self.pgbar.stop_pg()
			thread.start_new_thread(MsgDialog, (gtk.MESSAGE_ERROR, "Error creating Bugzilla client."))
			return
		try:
			result = pybugz.get(int(bugid))
		except urllib2.URLError, e:
			self._do_widgets_sensitive()
			self.pgbar.stop_pg()
			thread.start_new_thread(MsgDialog, (gtk.MESSAGE_ERROR, "Error: Please try again."))
			return
		except:
			self._do_widgets_sensitive()
			self.pgbar.stop_pg()	
			thread.start_new_thread(MsgDialog, (gtk.MESSAGE_ERROR, "Error getting bug."))
			return

		if result == None:
			self._do_widgets_sensitive()
			self.pgbar.stop_pg()				
			error_text = 'Error: Bug %s not found' % bugid
			thread.start_new_thread(MsgDialog, (gtk.MESSAGE_ERROR, error_text))
			
        # Print out all the fields below by extract the text
        # directly from the tag, and just ignore if we don't
        # see the tag.
		FIELDS = (
			('short_desc', 'Title'),
			('assigned_to', 'Assigneed To'),            
			('creation_ts', 'Reported'),
			('delta_ts', 'Updated'),
			('bug_status', 'Status'),
			('resolution', 'Resolution'),
			('bug_file_loc', 'URL'),
			('bug_severity', 'Severity'),
			('priority', 'Priority'),
			('reporter', 'Reporter'),
		)

		MORE_FIELDS = (
			('product', 'Product'),
			('component', 'Component'),
			('status_whiteboard', 'Whiteboard'),
			('keywords', 'Keywords'),
		)

		text_bug = ''

		try:
			self.enc = locale.getdefaultlocale()[1]
		except:
			self.enc = 'utf-8'

		for field, name in FIELDS + MORE_FIELDS:
			try:
				value = result.find('//%s' % field).text
			except AttributeError:
				continue
			text_bug += '%s: %s\n' % (name, value.encode(self.enc))

        # Print out the cc'ed people
		cced = result.findall('.//cc')
		for cc in cced:
			text_bug += '%s: %s\n' %  ('CC', cc.text)

        # print out depends
		dependson = ', '.join([d.text for d in result.findall('.//dependson')])
		blocked = ', '.join([d.text for d in result.findall('.//blocked')])
		if dependson:
			text_bug += '%s: %s\n' % ('DependsOn', dependson)

		if blocked:
			text_bug += '%s: %s\n' % ('Blocked', blocked)

		bug_comments = result.findall('//long_desc')
		bug_attachments = result.findall('//attachment')

		config = bugz.BugzConfig()
		text_bug += '%s: %d\n' % ('Comments', len(bug_comments))
		text_bug += '%s: %d\n' % ('Attachments', len(bug_attachments))
		text_bug += '%s: %s' % ('URL', '%s/%s?id=%s' % (self.Settings.URL, config.urls['show'], bugid))

		if len(bug_comments) == 0:
			text_bug += '\nNo comments.\n'
		else:
			import textwrap
			i = 0
			wrapper = textwrap.TextWrapper(width = 80)
			for comment in bug_comments:
				who = comment.find('.//who').text.encode(self.enc)
				when = comment.find('.//bug_when').text.encode(self.enc)
				what =  comment.find('.//thetext').text
				i += 1

				text_bug += '\n\n\n[Comment #%d] %s : %s\n' % (i, who, when)
#				text_bug += '-' * (80 - 1)

                # textcomment
				text_bug += '%s' % what

		if len(bug_attachments) == 0:
#			text_bug += '-' * (80 - 1)
			text_bug += '\n\nNo attachments'
		else:
			for attachment in bug_attachments:
				aid = attachment.find('.//attachid').text
				desc = attachment.find('.//desc').text
				when = attachment.find('.//date').text
				text_bug += '\n\n[Attachment] [%s] [%s]' % (aid, desc.encode(self.enc))
			
		if self.window_in_fullscreen == True:
			fulls = True
		elif self.window_in_fullscreen == False:
			fulls = False
		try:
			text_color = self.Settings.Text_Color
		except:
			text_color = "blue"
		
		thread.start_new_thread(self.start_bugwin, (text_bug, bugid, fulls, text_color, bug_attachments, pybugz))
		self.pgbar.stop_pg()
		self._do_widgets_sensitive()

	def start_bugwin(self, text_bug, bugid, fulls, text_color, bug_attachments, pybugz):
		gtk.gdk.threads_enter()
		GetBug(text_bug, bugid, fulls, text_color, bug_attachments, pybugz)
		gtk.gdk.threads_leave()
		
	def _do_widgets_sensitive(self):
		self.treeview1.set_sensitive(True)
		self.button1.set_sensitive(True)
		self.button2.set_sensitive(True)
		self.button3.set_sensitive(True)
		self.button4.set_sensitive(True)
		
	def _do_widgets_insensitive(self):
		self.treeview1.set_sensitive(False)
		self.button1.set_sensitive(False)
		self.button2.set_sensitive(False)
		self.button3.set_sensitive(False)
		self.button4.set_sensitive(False)

class GetBug:
	def __init__(self, text_bug, bugid, fulls, text_color, bug_attachments, pybugz):	
		def bugwin_destroy(widget):
			self.BugWindow.destroy()
		##Crear una ventana nueva 
		self.BugWindow = hildon.Window()
		self.BugWindow.set_title('Bug #' + str(bugid))
		self.BugWindow.set_default_size(800, 480)
		self.BugWindow.connect("destroy", bugwin_destroy)
		self.BugWindow.connect("key-press-event", self.on_key_press)
		self.BugWindow.connect("window-state-event", self.on_window_state_change)

		if fulls == True:
			self.BugWindow.fullscreen()
			self.bugwindow_in_fullscreen = True
		else:
			self.bugwindow_in_fullscreen = False

		self.menubar = gtk.Menu()
		self.menubar.show()
		for child in self.menubar.get_children():
			child.reparent(menu)
		self.BugWindow.set_menu(self.menubar)
		
		self.menu_attach = gtk.ImageMenuItem("Get attachments")		
		attach_img = gtk.Image()
		if os.path.exists("/usr/share/mabugz/pixmaps/gtk-attachment.png"):
			attach_img.set_from_file("/usr/share/mabugz/pixmaps/gtk-attachment.png")
		else:
			attach_img.set_from_file("pixmaps/gtk-attachment.png")
		self.menu_attach.set_image(attach_img)
		self.menu_attach.show()
		self.menu_attach.connect("activate", self.on_get_attach_clicked, bug_attachments, pybugz)
		
		self.menu_save = gtk.ImageMenuItem("Save as text")		
		save_img = gtk.Image()
		if os.path.exists("/usr/share/mabugz/pixmaps/gtk-save.png"):
			save_img.set_from_file("/usr/share/mabugz/pixmaps/gtk-save.png")
		else:
			save_img.set_from_file("pixmaps/gtk-save.png")
		self.menu_save.set_image(save_img)
		self.menu_save.show()
		self.menu_save.connect("activate", self.on_save_clicked)
		
		self.menu_close = gtk.ImageMenuItem("Close")		
		close_img = gtk.Image()
		if os.path.exists("/usr/share/mabugz/pixmaps/gtk-close.png"):
			close_img.set_from_file("/usr/share/mabugz/pixmaps/gtk-close.png")
		else:
			close_img.set_from_file("pixmaps/gtk-close.png")
		self.menu_close.set_image(close_img)
		self.menu_close.show()
		self.menu_close.connect("activate", bugwin_destroy)
		
		self.menubar.append(self.menu_attach)
		self.menubar.append(self.menu_save)
		self.menubar.append(self.menu_close)
				
		self.scrolledwindow2 = gtk.ScrolledWindow()
		self.scrolledwindow2.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_AUTOMATIC)
		self.scrolledwindow2.set_shadow_type(gtk.SHADOW_ETCHED_IN)

		self.view = gtk.TextView()
		self.buffer1 = self.view.get_buffer()
		self.view.set_wrap_mode(gtk.WRAP_WORD)
		self.view.set_editable(False)
		self.view.set_cursor_visible(False)
		self.buffer1.create_tag("monospace", family="monospace")
		self.buffer1.create_tag("blue_foreground", foreground=text_color)
		iter = self.buffer1.get_iter_at_offset(0)
		self.buffer1.insert_with_tags_by_name(iter, text_bug, "blue_foreground", "monospace")

		self.scrolledwindow2.add(self.view)

		self.BugWindow.add(self.scrolledwindow2)
		self.BugWindow.show_all()

	def scroll_to(self, x=0, y=0):
		v = self.scrolledwindow2.get_vadjustment()
		#TextBuffer haven't size_request but it work well ;)
		#TODO: look this
		child_height = self.scrolledwindow2.child.child.size_request()[1]
		new_adj = gtk.Adjustment(y, 0, child_height)
#		child_height = self.buffer1.size_request()[1]
#		new_adj = gtk.Adjustment(y, 0, child_height)
#		new_adj = gtk.Adjustment(y, 0, None)
		self.scrolledwindow2.set_vadjustment(new_adj)

	def scroll_by(self, dx=0, dy=0):
		v = self.scrolledwindow2.get_vadjustment()
		new_y = min(v.upper, v.value + dy)
#		print v.upper, v.value
		self.scroll_to(0, new_y)
#		print new_y

	#Functions for fullscreen
	def on_window_state_change(self, widget, event, *args):           
		if event.new_window_state & gtk.gdk.WINDOW_STATE_FULLSCREEN:
			self.bugwindow_in_fullscreen = True
		else:
			self.bugwindow_in_fullscreen = False

	def on_key_press(self, widget, event, *args): 
# Los valores de 100 y -100 son los 'pixels' que avanza el scroll
		if event.keyval == gtk.keysyms.Down:
			self.scroll_by(0, 100)
		elif event.keyval == gtk.keysyms.Up:
			self.scroll_by(0, -100)
		elif event.keyval == gtk.keysyms.F6:
			if self.bugwindow_in_fullscreen:
				self.BugWindow.unfullscreen()
			else:
				self.BugWindow.fullscreen()
		elif event.keyval == gtk.keysyms.Escape:
			self.BugWindow.destroy()

	def on_save_clicked(self, widget):
		self.save_dlg = hildon.FileChooserDialog(self.BugWindow, gtk.FILE_CHOOSER_ACTION_SAVE)
		self.save_dlg.set_title("Save Bug")
		self.save_dlg.set_default_response(gtk.RESPONSE_OK)
		self.save_dlg.show()
		
		buffer = self.view.get_buffer()
		startiter = buffer.get_start_iter()
		enditer = buffer.get_end_iter()
		body = buffer.get_text(startiter, enditer, include_hidden_chars=1)
		
		response = self.save_dlg.run()
		if response == gtk.RESPONSE_OK:
			try:
				self.file = self.save_dlg.get_filename()
				saveFile = open(self.file, "w")
				saveFile.write(body)
				saveFile.close()
			except:
				print "An error occurred in saving the file."				
				thread.start_new_thread(MsgDialog, (gtk.MESSAGE_ERROR, "An error occurred in saving file."))
		self.save_dlg.destroy()
		
	def on_get_attach_clicked(self, widget, bug_attachments, pybugz):		
		self.attachments_dlg = gtk.Dialog(title='Attachments', parent=None, flags=gtk.WIN_POS_CENTER, buttons=(gtk.STOCK_OK, gtk.RESPONSE_OK, gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL))

		self.attachments_dlg.set_border_width(4)
		self.attachments_dlg.set_default_size(-1, 250)

		vbox1 = gtk.VBox(False, 8)

		sw = gtk.ScrolledWindow()
		sw.set_shadow_type(gtk.SHADOW_ETCHED_IN)
		sw.set_policy(gtk.POLICY_NEVER, gtk.POLICY_AUTOMATIC)
		vbox1.pack_start(sw)

		# clear categories chosen before
		del attach_gets[:]
		del attach_list[:]
		self.GetAttachmentsList(bug_attachments)

		if attach_list == []:
			thread.start_new_thread(MsgDialog, (gtk.MESSAGE_ERROR, "Error: No attachments."))
			return
		model = self.__attach_model()

        # create tree view
		treeview = gtk.TreeView(model)
		treeview.set_rules_hint(True)
		treeview.set_property("allow-checkbox-mode", False)
		treeview.set_search_column(COLUMN_ATTACH)

		sw.add(treeview)

        # add columns to the tree view
		self.__attach_columns(treeview)

		self.attachments_dlg.vbox.pack_start(vbox1, True, True, 0)
		self.attachments_dlg.show_all()

		result = self.attachments_dlg.run()
		if (result==gtk.RESPONSE_OK):
			## This is for debug
			self.download_attachments(attach_gets, pybugz)
#			print 'attachs added: ', cats2

		#we are done with the dialog, destroy it
		self.attachments_dlg.destroy()

		#return the result
		return result
		
	def GetAttachmentsList(self, bug_attachments):
		try:
			#aid --> attachment id
			#desc --> attach name
			
			if len(bug_attachments) == 0:
				print 'No attachments'
				#Error dialog
			else:
				for attachment in bug_attachments:
					aid = attachment.find('.//attachid').text
					desc = attachment.find('.//desc').text
					c = (False, desc, aid)
					attach_list.append(c)
				return attach_list

		except:
			print 'error getting attachments list.'
			thread.start_new_thread(MsgDialog, (gtk.MESSAGE_ERROR, "Error getting attachment list."))


	def __attach_model(self):
		lstore = gtk.ListStore(gobject.TYPE_BOOLEAN, gobject.TYPE_STRING, gobject.TYPE_STRING)
		#Added the category list to lstore
		for item in attach_list:
			iter = lstore.append()
			lstore.set(iter, COLUMN_FIXED, item[COLUMN_FIXED], COLUMN_ATTACH, item[COLUMN_ATTACH], COLUMN_AID, item[COLUMN_AID])
		return lstore

	def fixed_toggled(self, cell, path, model):
        # get toggled iter
		iter = model.get_iter((int(path),))
		fixed = model.get_value(iter, COLUMN_FIXED)
        # do something with the value
		fixed = not fixed
        # set new value
		model.set(iter, COLUMN_FIXED, fixed)

		#If togglebutton is choose, add category name
		#to [cats]
		if fixed == True:
			a = model.get_value(iter, COLUMN_AID)
			attach_gets.append(a)
		#If togglebutton is choose and delete,
		#delete category name from [cats]
		elif fixed == False:
			b = model.get_value(iter, COLUMN_AID)
#			print 'delete attach: ', b
			numero = attach_gets.index(b)
#			print 'cat index: ', numero
			del attach_gets[numero]

	def __attach_columns(self, treeview):
		model = treeview.get_model()

        # column for fixed toggles
		renderer = gtk.CellRendererToggle()
		renderer.connect('toggled', self.fixed_toggled, model)

		column = gtk.TreeViewColumn('Fixed', renderer, active=COLUMN_FIXED)
        # set this column to a fixed sizing(of 50 pixels)
		column.set_sizing(gtk.TREE_VIEW_COLUMN_FIXED)
		column.set_fixed_width(50)
		treeview.append_column(column)

        # column for attachments
		column = gtk.TreeViewColumn('Description', gtk.CellRendererText(), text=COLUMN_ATTACH)
		treeview.append_column(column)
		
        # column for attachments
		column = gtk.TreeViewColumn('ID', gtk.CellRendererText(), text=COLUMN_AID)
		treeview.append_column(column)		
		
	def download_attachments(self, attach_gets, pybugz):
		self.attachments_dlg.destroy()
		self.down_dlg = hildon.FileChooserDialog(self.BugWindow, gtk.FILE_CHOOSER_ACTION_SELECT_FOLDER)
		self.down_dlg.set_title("Save Attachments")
		self.down_dlg.set_default_response(gtk.RESPONSE_OK)
		self.down_dlg.show()
			
		response = self.down_dlg.run()
		
		if response == gtk.RESPONSE_OK:
			download_dir = self.down_dlg.get_current_folder()
			thread.start_new_thread(self.__on_getting_attachments, (attach_gets, pybugz, download_dir))
			self.pgbar = ProgressBar("Download attachments")
			
		self.down_dlg.destroy()
		
	def __on_getting_attachments(self, attach_gets, pybugz, download_dir):
		try:
			for i in attach_gets:
				attachid = int(i)
				print 'Getting attachment %s' % attachid
				result = pybugz.attachment(attachid)
				if not result:
					print 'Unable to get attachment'
					thread.start_new_thread(MsgDialog, (gtk.MESSAGE_ERROR, "Error: Unable to get attachment."))

				safe_filename = os.path.basename(re.sub(r'\.\.', '', result['filename']))

				file_save = download_dir + '/' + safe_filename
				open(file_save, 'wb').write(result['fd'].read())
			self.pgbar.stop_pg()
			thread.start_new_thread(MsgDialog, (gtk.MESSAGE_INFO, "Attachments downloaded."))			
		except:
			self.pgbar.stop_pg()
			thread.start_new_thread(MsgDialog, (gtk.MESSAGE_ERROR, "An error occurred in saving the file."))



class Settings:
	"""This class holds the necessary bugzilla settings
	URL - The bugzilla URL
	Username - The username if were necessary
	Password - The password if were necessary
	Color - Color text of Bug textview
	Comments - Search in bugs' comments
	"""
	def __init__(self, File="", URL="", Username="", Password="", Text_Color="", Comments=""):
		self.URL = URL
		self.Username = Username
		self.Password = Password
		self.Text_Color = Text_Color
		self.Comments = Comments
		if (File != ""):
			# Load from file
			try:
				file = open(File, 'rb')
				self.URL = cPickle.load(file)
				self.Username = cPickle.load(file)
				self.Password = cPickle.load(file)
				self.Text_Color = cPickle.load(file)
				self.Comments = cPickle.load(file)
				dec_pass=base64.decodestring(self.Password)
				self.Password=dec_pass
				file.close()
			except:
				thread.start_new_thread(MsgDialog, (gtk.MESSAGE_ERROR, "Error loading settings."))
				return

	def save(self, File):
		"""cPickle the information into the file"""
		try:
			save_file = open(File, 'wb')
			cPickle.dump(self.URL, save_file)
			cPickle.dump(self.Username, save_file)
			enc_pass=base64.encodestring(self.Password)
			self.Password=enc_pass
			cPickle.dump(self.Password, save_file)
			cPickle.dump(self.Text_Color, save_file)
			cPickle.dump(self.Comments, save_file)
			save_file.close()
		except:
			thread.start_new_thread(MsgDialog, (gtk.MESSAGE_ERROR, "Error saving settings"))
			return

	def create_bugzilla_client(self):
		"""Quick helper routine used to create the bugzilla
		client"""
		# prepare client object
		try:
			if self.Username == '':
				pybugz = bugz.Bugz(self.URL, None, None, False, False)
			else:
				pybugz = bugz.Bugz(self.URL, self.Username, self.Password, False, False)
		except:
			return None

		return pybugz

class Credits:
	def __init__(self, widget):
		dialog = gtk.AboutDialog()
		dialog.set_name("Mabugz")
		dialog.set_version("0.0.2")
		dialog.set_copyright("Copyright © 2007")
		dialog.set_website("https://garage.maemo.org/projects/mabugz/")
		dialog.set_authors(["Daniel Martín Yerga <dyerga@gmail.com>", "", "PyBugz module written by:", "Alastair Tse <alastair@liquidx.net>"])
		dialog.set_artists(["Icons from Gartoon Iconset. GPL License."])
		try:
 			logo = gtk.gdk.pixbuf_new_from_file("/usr/share/mabugz/pixmaps/logo.png")
		except:
			logo = gtk.gdk.pixbuf_new_from_file("pixmaps/logo.png")
		dialog.set_logo(logo)
		dialog.set_license("This program is released under the GNU\nGeneral Public License. Please visit \nhttp://www.gnu.org/copyleft/gpl.html\nfor details.")
		dialog.run()
		dialog.destroy()

class ProgressBar:
	def __init__(self, pg_text):
		self.w = gtk.Dialog(None)
		vbox = gtk.VBox(False, 5)
		self.progress = gtk.ProgressBar()
		self.progress.set_size_request(250,-1)
		self.progress.set_text(pg_text)
		vbox.add(self.progress)
		self.w.vbox.add(vbox)
		self.w.show_all()

		self.active = True
		self.progress.pulse()
		self.timeout_cb = gobject.timeout_add(200, self.increment)

	def stop_pg(self):
		self.active = False
		self.w.destroy()

	def increment(self):        
		if not self.active:
            # we were disabled, so stop pulsating
			return False
		self.progress.pulse()
		return True

class MsgDialog:
	def __init__(self, type, msg):
		msg_dlg = gtk.MessageDialog(type=type, message_format=msg, buttons=gtk.BUTTONS_CLOSE)
		gtk.gdk.threads_enter()
		msg_dlg.run()
		gtk.gdk.threads_leave()
		msg_dlg.destroy()

if __name__ == "__main__":
	PyBugz()
	gtk.gdk.threads_enter()
	gtk.main()
	gtk.gdk.threads_leave()
