/**
  This file belong to the KMPlayer project, a movie player plugin for Konqueror
  Copyright (C) 2007  Koos Vriezen <koos.vriezen@gmail.com>

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**/

#ifndef KMPLAYER_VIEW_AREA_H
#define KMPLAYER_VIEW_AREA_H

#include <gtk/gtkwidget.h>

#include "kmplayertypes.h"

typedef struct _Application Application;

namespace KMPlayer {

class View;
class ViewAreaPrivate;

/*
 * The area in which the video widget and controlpanel are laid out
 */
class KMPLAYER_EXPORT ViewArea {
public:
    ViewArea ();
    ~ViewArea ();
    KDE_NO_EXPORT bool isFullScreen () const { return m_fullscreen; }
    SurfacePtr getSurface (NodePtr node);
    void setAudioVideoGeometry (int x, int y, int w, int h, unsigned int * bg);
    void setAudioVideoNode (NodePtr n);
    void scheduleRepaint (int x, int y, int w, int h);
    void resizeEvent ();
    void fullScreen ();
    void scale (int);
    void setAspect (float a);
    void mousePressEvent (int x, int y);
    void mouseDoubleClickEvent ();
    void paintEvent (const Rect &);
    void timeoutPaintEvent ();
    KDE_NO_EXPORT Rect videoGeometry () const { return m_av_geometry; }
    int width () const;
    int height () const;
    GtkWidget * viewWidget () const { return widget; }
    GdkWindow * videoWindow () const { return video; }
    void setOutputWidget (Application *, GtkWidget * w); 
private:
    void syncVisual (const IRect & rect);
    void updateSurfaceBounds ();
    ViewAreaPrivate * d;
    Rect m_av_geometry;
    float aspect;
    IRect m_repaint_rect;
    GtkWidget * widget;
    GdkWindow * video;
    SurfacePtr surface;
    NodePtrW video_node;
    int m_repaint_timer;
    bool m_fullscreen;
};

} // namespace KMPlayer

#endif
