/* This file is part of the KMPlayer application
   Copyright (C) 2006 Koos Vriezen <koos.vriezen@gmail.com>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#ifndef _K_GST_PLAYER_H_
#define _K_GST_PLAYER_H_

#include "kmplayertypes.h"
/*
struct GstSizeEvent : public QEvent {
    GstSizeEvent (int l, int w, int h);
    int length;
    int width;
    int height;
};

struct GstProgressEvent : public QEvent {
    GstProgressEvent (int p);
    int progress;
};
*/

#include <pthread.h>

class Thread {
    friend void * threadStartRoutine (void *);
    pthread_t thread;
public:
    Thread () {}
    virtual ~Thread () {}
    void start ();
    void wait (int ms);
protected:
    virtual void run () = 0;
};

class Mutex {
    pthread_mutex_t mutex;
public:
    Mutex (bool);
    void lock () { pthread_mutex_lock (&mutex); }
    void unlock () { pthread_mutex_unlock (&mutex); }
};

#include <glib.h>

class Application {
    GMainLoop * event_loop;
public:
    Application (int argc, char ** argv)
        : event_loop (g_main_loop_new (0L, false)) {}
    void exec () { g_main_loop_run (event_loop); }
    void quit () { g_main_loop_quit (event_loop); }
};

class KGStreamerPlayer : public Application {
public:
    KGStreamerPlayer (int argc, char ** argv);
    ~KGStreamerPlayer ();

    void init ();
    void finished ();
    void saturation (int val);
    void hue (int val);
    void contrast (int val);
    void brightness (int val);
    void volume (int val);
    void seek (int val);
//    bool event (QEvent * e);
//public slots:
    void play ();
    void stop ();
    void pause ();
    void updatePosition ();
    //void postFinished ();
protected:
  //  void saveState (QSessionManager & sm);
};

#endif //_K_GST_PLAYER_H_
