/* This file is part of the KMPlayer project
 *
 * Copyright (C) 2006 Koos Vriezen <koos.vriezen@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _KMPLAYER_LISTS_H_
#define _KMPLAYER_LISTS_H_

#include "kmplayer.h"
#include "kmplayerplaylist.h"

namespace KMPlayer {

static const short id_node_recent_document = 28;
static const short id_node_recent_node = 29;
static const short id_node_disk_document = 30;
static const short id_node_disk_node = 31;

class KMPLAYER_NO_EXPORT FileDocument : public KMPlayer::Document {
public:
    FileDocument (short id, const String &, KMPlayer::PlayListNotify * notify = 0L);
    KMPlayer::NodePtr childFromTag (const String & tag);
    void readFromFile (const String & file);
    void writeToFile (const String & file);
    unsigned int load_tree_version;
};


/*class KMPLAYER_NO_EXPORT ListsSource : public KMPlayer::URLSource {
public:
    KDE_NO_CDTOR_EXPORT ListsSource (KMPlayer::PartBase * p)
        : KMPlayer::URLSource (p, "lists://") {}
    void jump (KMPlayer::NodePtr e);
    void activate ();
    void setDocument (KMPlayer::NodePtr doc, KMPlayer::NodePtr cur);
    String prettyName () { return m_document->mrl ()->pretty_name; }
};*/

class KMPLAYER_NO_EXPORT Recents : public FileDocument {
public:
    Recents (Application *a);
    void defer ();
    void activate ();
    void childDone (KMPlayer::NodePtr);
    KMPlayer::NodePtr childFromTag (const String & tag);
    KDE_NO_EXPORT const char * nodeName () const { return "playlist"; }
    Application * app;
};

class KMPLAYER_NO_EXPORT Recent : public KMPlayer::Mrl {
public:
    Recent (KMPlayer::NodePtr & doc, Application *a, const String &url = String());
    void activate ();
    void closed ();
    KDE_NO_EXPORT const char * nodeName () const { return "item"; }
    Application * app;
};

class KMPLAYER_NO_EXPORT Group : public KMPlayer::Mrl {
public:
    Group (KMPlayer::NodePtr &doc, Application *a, const String &pn=String());
    KMPlayer::NodePtr childFromTag (const String & tag);
    void defer () {} // TODO lazy loading of largish sub trees
    void closed ();
    KDE_NO_EXPORT const char * nodeName () const { return "group"; }
    Application * app;
};

class KMPLAYER_NO_EXPORT Playlist : public FileDocument {
public:
    Playlist (Application *a, KMPlayer::PlayListNotify *n, bool plmod = false);
    void childDone (KMPlayer::NodePtr);
    void defer ();
    void activate ();
    KMPlayer::NodePtr childFromTag (const String & tag);
    KDE_NO_EXPORT const char * nodeName () const { return "playlist"; }
    Application * app;
    bool playmode;
};

class KMPLAYER_NO_EXPORT PlaylistItem : public KMPlayer::Mrl {
public:
    PlaylistItem (KMPlayer::NodePtr & doc, Application *a, const String &url = String());
    void activate ();
    void closed ();
    void setNodeName (const String &);
    KDE_NO_EXPORT const char * nodeName () const { return "item"; }
    Application * app;
};

class KMPLAYER_NO_EXPORT PlaylistGroup : public KMPlayer::Mrl {
public:
    PlaylistGroup (KMPlayer::NodePtr &doc, Application *a, const String &pn);
    PlaylistGroup (KMPlayer::NodePtr &doc, Application *a, bool plmode=false);
    KMPlayer::NodePtr childFromTag (const String & tag);
    void closed ();
    void setNodeName (const String &);
    KDE_NO_EXPORT const char * nodeName () const { return "group"; }
    Application * app;
    bool playmode;
};

}  // KMPlayer namespace

#endif //_KMPLAYER_LISTS_H_

