/* GStreamer
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __GST_PLAYBINMAEMO_H__
#define __GST_PLAYBINMAEMO_H__

#include <gst/gst.h>

G_BEGIN_DECLS

#define GST_TYPE_PLAY_BIN_MAEMO \
    (gst_play_bin_maemo_get_type())
#define GST_PLAY_BIN_MAEMO(obj) \
    (G_TYPE_CHECK_INSTANCE_CAST((obj),GST_TYPE_PLAY_BIN_MAEMO,GstPlayBinMaemo))
#define GST_PLAY_BIN_MAEMO_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_CAST((klass),GST_TYPE_PLAY_BIN_MAEMO,GstPlayBinMaemoClass))
#define GST_IS_PLAY_BIN_MAEMO(obj) \
    (G_TYPE_CHECK_INSTANCE_TYPE((obj),GST_TYPE_PLAY_BIN_MAEMO))
#define GST_IS_PLAY_BIN_MAEMO_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_TYPE((klass),GST_TYPE_PLAY_BIN_MAEMO))
#define GST_PLAY_BIN_MAEMO_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS ((obj), GST_TYPE_PLAY_BIN_MAEMO,GstPlayBinMaemoClass))

typedef struct _GstPlayBinMaemo GstPlayBinMaemo;
typedef struct _GstPlayBinMaemoClass GstPlayBinMaemoClass;

struct _GstPlayBinMaemo {
  GstPipeline    pipeline;

  /* properties */
  guint64        queue_size;
  guint64        queue_min_threshold;
  gboolean       is_stream;
  gboolean       parse_metadata;
  glong          xid;
  gdouble        volume;

  /* currently loaded media */
  gboolean      need_rebuild;
  gboolean      has_metadata;
  gchar         *uri;
  GstElement    *volume_element;
  GstElement    *source;
  GstElement    *video_sink;
  GList         *elements;
  GList         *factories;
};

struct _GstPlayBinMaemoClass {
  GstPipelineClass parent_class;
};

GType gst_play_bin_maemo_get_type (void);

G_END_DECLS

#endif /* __GST_PLAYBINMAEMO_H__ */

