// -*- c++ -*-
//------------------------------------------------------------------------------
// $Id: MyDialogWithCheckbutton.h,v 1.1 2006/08/30 12:23:36 vlg Exp $
//------------------------------------------------------------------------------
//                            MyDialogWithCheckbutton.h
//------------------------------------------------------------------------------
//  Copyright (c) 2006 by Vladislav Grinchenko 
//
//  This program is free software; you can redistribute it and/or 
//  modify it under the terms of the GNU General Public License   
//  as published by the Free Software Foundation; either version  
//  2 of the License, or (at your option) any later version.      
//------------------------------------------------------------------------------
//
// Date   : Sat Aug 26 19:20:12 EDT 2006
//
//------------------------------------------------------------------------------
#ifndef MY_DIALOG_WITH_CHECKBUTTON_H
#define MY_DIALOG_WITH_CHECKBUTTON_H

#include <gtkmm/checkbutton.h>
#include <gtkmm/messagedialog.h>

/* @class MyDialogWithCheckbutton

   A standard question dialog and two buttons, 'Yes' and 'No',
   with additional checkbutton framed with the text.
*/
class MyDialogWithCheckbutton : public Gtk::MessageDialog
{
public:
	MyDialogWithCheckbutton (const Glib::ustring& message_, 
							 const Glib::ustring& checkbutton_message_, 
							 bool activate_checkbutton_ = false,
							 bool use_markup_ = false);

	bool get_checkbutton_status () const { return m_checkbutton->get_active ();}

private:
	Gtk::CheckButton* m_checkbutton;
};

#endif /* MY_DIALOG_WITH_CHECKBUTTON_H */
