/* Geoclue - A DBus api and wrapper for geography information
 * Copyright (C) 2006-2007 by Garmin Ltd. or its subsidiaries
 * 
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2 as published by the Free Software Foundation; 
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <stdio.h>
#include <geoclue/position.h>
#include <glib.h>
/**
 *
 * Call the test program with no arguments (default backend will be used),
 * or use the name of the backend as argument:
 *     ./geoclue-position-example gpsd
 *
**/


static void cb (void* userdata,
		char* country,
                char* region,
                char* locality,
                char* area,
                char* postalcode,
                char* street,
                char* building,
                char* floor,
                char* room,
                char* description,
                char* text)
{
    g_debug ("callback!\ncountry: %s, locality  %s, %s, %s, %s, %s,%s, %s, %s",
                country,
                locality,
                postalcode,
                street,
                building,
                floor,
                room,
                description,
                text);
}

int main (int argc, char** argv)
{
    position_provider* provider = NULL;
   
    g_type_init ();
    g_thread_init (NULL);

    if (argv[1] != NULL) {
        g_debug ("Testing specified backend: %s", argv[1]);
        provider = g_malloc(sizeof(position_provider));	
        provider->service = g_strdup_printf ("org.freedesktop.geoclue.position.%s", argv[1]);
        provider->path = g_strdup_printf ("/org/freedesktop/geoclue/position/%s", argv[1]);
        provider->connection = NULL;
        provider->proxy = NULL;
        provider->ref = 1;
    } else {
        g_debug ("Testing default backend");        
    }
    if (geoclue_position_init (provider) != GEOCLUE_POSITION_SUCCESS){
        g_printerr ("Initialization failed");
        return 1;
    }

    /*set callback*/
    if (geoclue_position_add_civic_callback (provider, cb, NULL) != GEOCLUE_POSITION_SUCCESS) {
        g_printerr ("Adding civic callback failed");
        return 1;
    }

    g_debug ("Running main loop");
    GMainLoop *loop = g_main_loop_new (NULL, TRUE);
    g_main_loop_run (loop);
    g_main_loop_unref (loop);

    return 0;   
}
