#!/bin/sh

APT_GET="apt-get -y --force-yes -q"
DPKG="dpkg --abort-after 999999"
BASE_PACKAGES="\
 libeet0 \
 libevas0 \
 libecore0 \
 libembryo0 \
 libepeg0 \
 libdownloadmanager0 \
 libimlib2 \
 liblightmediascanner0 \
 atabake \
 python2.5-dispatcher \
 python2.5-downloadmanager \
 python2.5-efl-utils"


EXTRA_PACKAGES="\
 canola-tuning \
 python2.5-edje-demo \
 expedite \
 python-efl-core-demo \
 python-efl-core \
 ogg-support-lms"


CLEAN_PATHS="\
 /home/user/.canola \
 /home/user/.atabake \
 /usr/lib/python2.5/site-packages/atabake \
 /usr/lib/python2.5/site-packages/canolad \
 /usr/lib/python2.5/site-packages/dispatcher \
 /usr/lib/python2.5/site-packages/downloadmanager \
 /usr/lib/python2.5/site-packages/ecore \
 /usr/lib/python2.5/site-packages/edbus \
 /usr/lib/python2.5/site-packages/edje \
 /usr/lib/python2.5/site-packages/efl_utils \
 /usr/lib/python2.5/site-packages/epsilon \
 /usr/lib/python2.5/site-packages/etk \
 /usr/lib/python2.5/site-packages/evas \
 /usr/lib/python2.5/site-packages/lightmediascanner \
 /usr/lib/python2.5/site-packages/terra"


ALL_PACKAGES=" \
 efl-core efl-core-dev \
 libecore0 libecore0-all libecore0-con libecore0-desktop libecore0-dev libecore0-evas libecore0-file libecore0-imf libecore0-imf-evas libecore0-ipc libecore0-job libecore0-txt libecore0-x \
 libedbus0 libedbus0-dev \
 libedje0 libedje0-dev edje0-bin \
 libeet0 libeet0-dev \
 libembryo0 libembryo0-dev embryo0-bin \
 libepeg0 libepeg0-dev epeg0-bin \
 libepsilon0 libepsilon0-dev epsilon0-bin \
 libetk0 libetk0-dev libetk0-engine-all libetk0-engine-evas libetk0-engine-evas-software-x11 libetk0-engine-evas-software-x11-16 libetk0-engine-evas-x11 \
 libevas0 libevas0-all libevas0-dev libevas0-engine-buffer libevas0-engine-software-generic libevas0-engine-software-x11 libevas0-engine-software-x11-16 libevas0-engines-all libevas0-loader-eet libevas0-loader-jpeg libevas0-loader-png libevas0-loaders-all libevas0-saver-eet libevas0-saver-jpeg libevas0-saver-png libevas0-savers-all \
 libimlib2 libimlib2-dev \
 python2.5-ecore \
 python2.5-edbus python2.5-dbus-ecore \
 python2.5-edje python2.5-edje-demo \
 python2.5-efl-core \
 python2.5-efl-utils \
 python2.5-epsilon \
 python2.5-etk \
 python2.5-evas \
 python2.5-dispatcher \
 liblightmediascanner0 liblightmediascanner0-dev lightmediascanner0-asf lightmediascanner0-audio-dummy lightmediascanner0-flac lightmediascanner0-id3 lightmediascanner0-id3lib lightmediascanner0-jpeg lightmediascanner0-mp4 lightmediascanner0-ogg lightmediascanner0-playlists lightmediascanner0-plugins lightmediascanner0-png lightmediascanner0-rm lightmediascanner0-video-dummy python2.5-lightmediascanner \
 hildon-imf-ecore \
 canola2 atabake canolad python2.5-terra python2.5-downloadmanager libdownloadmanager0 downloadmanager0-server \
 "

die()
{
    echo "### ERROR: $*"
    exit 1
}

info()
{
    echo "### INFO: $*"
}

warning()
{
    echo "### WARN: $*"
}

important()
{
    echo "### IMPORTANT: $*"
}

report_exit()
{
    if [ $1 -eq 0 ]; then
        STATUS="OK"
    else
        STATUS="FAILED, code=$1"
    fi
    echo "### COMMAND_STATUS: $STATUS"
}

report_cmd()
{
    echo "### COMMAND: $*"
    sh -c "$*"
    ret=$?
    report_exit $ret
    return $ret
}

get_software_raw()
{
    cut -d_ -f2 /etc/osso_software_version
}

get_software()
{
    HW=$1
    VER=`get_software_raw`
    case $HW in
        770)
            case $VER in
                2006SE)
                    echo "gregale"
                    ;;
                2007HACKER)
                    echo "hackeredition"
                    ;;
                *)
                    echo "UNKNOWN"
                    ;;
            esac
            ;;
        N800)
            case $VER in
                2007SE)
                    echo "bora"
                    ;;
                2008SE)
                    echo "chinook"
                    ;;
                *)
                    echo "UNKNOWN"
                    ;;
            esac
            ;;
        N810)
            case $VER in
                2008SE)
                    echo "chinook"
                    ;;
                *)
                    echo "UNKNOWN"
                    ;;
            esac
            ;;
        *)
            echo "UNKNOWN"
            ;;
    esac
}

get_hardware_raw()
{
    grep product /proc/component_version | \
        sed 's/^[^ ]\+[ ]\+\([a-zA-Z0-9]\+\)/\1/g'
}

get_hardware()
{
    N=`get_hardware_raw`
    case $N in
        SU-18)
            echo "770"
            ;;
        RX-34)
            echo "N800"
            ;;
        RX-44)
            echo "N810"
            ;;
        *)
            echo "UNKNOWN"
            ;;
    esac
}

plat_info_report()
{
    important "Platform Information to Report"
    important "HARDWARE: `get_hardware_raw`"
    important "SOFTWARE: `get_software_raw`"
}

apt_clean()
{
    important "Trying to clean apt-get cache"
    report_cmd $APT_GET clean
}

apt_remove()
{
    important "Trying to remove packages using apt-get"
    report_cmd $APT_GET --purge remove $BASE_PACKAGES
}

apt_f_install()
{
    report_cmd $APT_GET -f install
}

dpkg_configure_pending()
{
    report_cmd $DPKG --force-all --configure -a
}

clean_paths()
{
    for p in $CLEAN_PATHS; do
        if [ -d $p ]; then
            report_cmd rm -fr $p
        fi
    done
}

dpkg_remove_all()
{
    report_cmd $DPKG --purge $EXTRA_PACKAGES $ALL_PACKAGES
}

dpkg_remove()
{
    important "Trying to remove packages with dpkg"
    dpkg_remove_all
}

apt_worker_pid=`pidof apt-worker`
test ! -z "$apt_worker_pid" && die "Application Installer is running."
export HARDWARE=`get_hardware`
export SOFTWARE=`get_software $HARDWARE`
if [ $HARDWARE = "UNKNOWN" ] || [ $SOFTWARE = "UNKNOWN" ]; then
    plat_info_report
    die "Unsupported platform, please report"
fi


apt_clean
apt_f_install
dpkg_configure_pending
apt_remove || dpkg_remove
clean_paths

