#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <errno.h>

#include <sys/types.h>
#include <sys/wait.h>

#include "vba.h"
#include "util.h"


#define XMAEME_VBA_EXE		"vba"
#define XMAEME_VBA_SOUND	"-sound"
#define XMAEME_VBA_FULLSCREEN	"-F"
#define XMAEME_VBA_SINGLERES	"-1"
#define XMAEME_VBA_DOUBLERES	"-2"
#define XMAEME_VBA_FSKIP	"-s"


gint launch_vba(const gchar *romname, gboolean use_sound, gboolean fullscreen, gboolean maxscale, gint frameskip){
	int	status = 0,
		pid = 0;

	if(!romname){
		return 1;
	}//if romname is NULL

	if((pid=fork())){
		waitpid(pid, &status, 0);
	}//parent
	else{
		int	i = 1;
		char*	args[15] = { XMAEME_VBA_EXE, NULL, NULL, NULL, NULL, NULL, NULL, NULL , NULL , NULL , NULL, NULL, NULL };
		char	*fullrom = NULL,
	       		*fskip = NULL;	

		// If filename is relative, prepend rompath
		if(('/' != *romname) && ('\0' != *romname)){
			//hackish win32 check, as if anyone will use this on win32
			if(':' != romname[1]){	
				fullrom = g_strdup_printf("%s%s",XMAEME_ROMPATH_GBA,romname);
			}//if
		}//if

		if(!fullrom){
			fullrom = g_strdup(romname);
		}//if

		// No command-line switch for sound yet AFAIK
		// args[i++] = XMAEME_VBA_SOUND;
		// args[i++] = use_sound?"1":"0";

		if(fullscreen){
			args[i++] = XMAEME_VBA_FULLSCREEN;
		}//if fullscreen

		if(maxscale){
			args[i++] = XMAEME_VBA_DOUBLERES;
		}else{
			args[i++] = XMAEME_VBA_SINGLERES;
		}//if

		if(frameskip>0){
			args[i++] = XMAEME_VBA_FSKIP;
			fskip = g_strdup_printf("%d",frameskip);
			args[i++] = fskip;
		}//skip frames

		args[i++] = (char*)fullrom;
		
 		{ //debug
			int j = 0;

			printf("Child: running ");
			for(j=0;j<15;++j){
				printf("%s ", args[j]);
			}//for
			printf("\n");
		} //debug

		status=execvp(XMAEME_VBA_EXE,args);
		if(status<0){
			fprintf(stderr,"Unable to run %s: %s\n",XMAEME_VBA_EXE,strerror(errno));
		}//if an error occurred

		g_free(fullrom);
		g_free(fskip);

		exit(0);
	}//child

	return status;
}//launch_vba
