#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>

#ifdef HILDON
#  include <hildon-widgets/hildon-banner.h>
#  include <hildon-widgets/hildon-file-chooser-dialog.h>
#endif

#include "callbacks.h"
#include "interface.h"
#include "support.h"
#include "xmame.h"
#include "fceu.h"
#include "util.h"


void show_error_dialog(const char *error_msg);

// MAME
void on_b_ok_clicked                    (GtkButton       *button,
                                        gpointer         user_data) {
	gchar	*romname = NULL,
		*cursor = NULL;
	GtkWidget	*w = NULL,
			*romlist = lookup_widget(GTK_WIDGET(button), "romlist"),
			*mainwindow = lookup_widget(GTK_WIDGET(button), "mainwindow");
	const char*	wnames[4] = { "cb_sound", "cb_fullscreen", "cb_ror", "cb_scale" };
	gboolean	flags[4] = { TRUE, TRUE, TRUE, TRUE };
	gint	i = 0,
		status = 0;

	for(i=0;i<4;++i){
		w=lookup_widget(GTK_WIDGET(button), wnames[i]);
		if(w){
			flags[i] = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(w));
		}//if
	}//for

	romname = gtk_combo_box_get_active_text(GTK_COMBO_BOX(romlist));
	//strip_extension(romname);


#ifdef HILDON
	hildon_banner_show_information(mainwindow, NULL, _("Launching xmame"));
#endif

	status = launch_xmame(romname, flags[0], flags[1], flags[2], flags[3]);

#ifdef HILDON
	if(status<0){
		hildon_banner_show_information(mainwindow, NULL, _("Unable to launch xmame"));
	}//error launching xmame
	else if(status>0){
		hildon_banner_show_information(mainwindow, NULL, _("Unable to load ROM"));
	}//xmame exited unsuccessfully
#else
	if(status<0){
		show_error_dialog("Unable to launch xmame");
	}//error launching xmame
	else if(status>0){
		show_error_dialog("Unable to load ROM");
	}//xmame exited unsuccessfully
#endif

	g_free(romname);
}//on_b_ok_clicked


//NES
void on_b_ok2_clicked                   (GtkButton       *button,
                                        gpointer         user_data) {
	gchar	*romname = NULL,
		*cursor = NULL;
	GtkWidget	*w = NULL,
			*romlist = lookup_widget(GTK_WIDGET(button), "romlist2"),
			*mainwindow = lookup_widget(GTK_WIDGET(button), "mainwindow");
	const char*	wnames[4] = { "cb_sound2", "cb_fullscreen2", "cb_scale2", "frameskip" };
	gint	flags[4] = { TRUE, TRUE, TRUE, 2 };
	gint	i = 0,
		status = 0;

	for(i=0;i<3;++i){
		w=lookup_widget(GTK_WIDGET(button), wnames[i]);
		if(w){
			flags[i] = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(w));
		}//if
	}//for

	w=lookup_widget(GTK_WIDGET(button), wnames[3]);
	flags[3] = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(w));

	romname = gtk_combo_box_get_active_text(GTK_COMBO_BOX(romlist));

#ifdef HILDON
	hildon_banner_show_information(mainwindow, NULL, _("Launching fceu"));
#endif

	status = launch_fceu(romname, flags[0], flags[1], flags[2], flags[3]);

#ifdef HILDON
	if(status<0){
		hildon_banner_show_information(mainwindow, NULL, _("Unable to launch fceu"));
	}//error launching xmame
	else if(status>0){
		hildon_banner_show_information(mainwindow, NULL, _("Unable to load ROM"));
	}//xmame exited unsuccessfully
#else
	if(status<0){
		show_error_dialog("Unable to launch fceu");
	}//error launching fceu
	else if(status>0){
		show_error_dialog("Unable to load ROM");
	}//fceu exited unsuccessfully
#endif

	g_free(romname);
}//on_b_ok2_clicked


// GBA
void on_b_ok3_clicked                   (GtkButton       *button,
                                        gpointer         user_data) {
	gchar	*romname = NULL,
		*cursor = NULL;
	GtkWidget	*w = NULL,
			*romlist = lookup_widget(GTK_WIDGET(button), "romlist3"),
			*mainwindow = lookup_widget(GTK_WIDGET(button), "mainwindow");
	const char*	wnames[3] = { "cb_fullscreen3", "cb_scale3", "frameskip3" };
	gint	flags[3] = { TRUE, TRUE, 5 };
	gint	i = 0,
		status = 0;

	for(i=0;i<2;++i){
		w=lookup_widget(GTK_WIDGET(button), wnames[i]);
		if(w){
			flags[i] = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(w));
		}//if
	}//for

	w=lookup_widget(GTK_WIDGET(button), wnames[2]);
	flags[2] = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(w));

	romname = gtk_combo_box_get_active_text(GTK_COMBO_BOX(romlist));

#ifdef HILDON
	hildon_banner_show_information(mainwindow, NULL, _("Launching vba"));
#endif

	status = launch_vba(romname, FALSE, flags[0], flags[1], flags[2]);

#ifdef HILDON
	if(status<0){
		hildon_banner_show_information(mainwindow, NULL, _("Unable to launch vba"));
	}//error launching vba
	else if(status>0){
		hildon_banner_show_information(mainwindow, NULL, _("Unable to load ROM"));
	}//vba exited unsuccessfully
#else
	if(status<0){
		show_error_dialog("Unable to launch vba");
	}//error launching vba
	else if(status>0){
		show_error_dialog("Unable to load ROM");
	}//vba exited unsuccessfully
#endif

	g_free(romname);
}//on_b_ok3_clicked


// MAME
void on_file_browse_clicked(GtkButton *button, gpointer user_data) {
	GtkWidget	*filedialog = NULL,
			*romlist = lookup_widget(GTK_WIDGET(button), "romlist"),
			*parent = lookup_widget(GTK_WIDGET(button), "mainwindow");
	GList	*cursor = NULL;

#ifdef HILDON
	filedialog = hildon_file_chooser_dialog_new(GTK_WINDOW(parent), GTK_FILE_CHOOSER_ACTION_OPEN);
	gtk_file_chooser_set_current_folder(GTK_FILE_CHOOSER(filedialog), XMAEME_ROMPATH_MAME);
#else
	filedialog = gtk_file_chooser_dialog_new(_("Choose ROM"), GTK_WINDOW(parent), GTK_FILE_CHOOSER_ACTION_OPEN, 
			GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, GTK_STOCK_OPEN, GTK_RESPONSE_OK, NULL);
#endif

	if(GTK_RESPONSE_OK == gtk_dialog_run(GTK_DIALOG(filedialog))){
		gchar	*filename = gtk_file_chooser_get_filename(GTK_FILE_CHOOSER(filedialog));
		
		cursor = g_list_find_custom(filelist, filename, strcmp);  
		if(!cursor){
			//add rom to start of list and select it
			strip_extension(filename);
			gtk_combo_box_prepend_text(GTK_COMBO_BOX(romlist),filename);
			gtk_combo_box_set_active(GTK_COMBO_BOX(romlist), 0);
		}//if rom isn't already in list
		g_free(filename);
	}//if file chosen

	gtk_widget_destroy(filedialog);
}//on_file_browse_clicked


// NES
void on_file_browse2_clicked(GtkButton *button, gpointer user_data) {
	GtkWidget	*filedialog = NULL,
			*romlist = lookup_widget(GTK_WIDGET(button), "romlist2"),
			*parent = lookup_widget(GTK_WIDGET(button), "mainwindow");
	GList	*cursor = NULL;

#ifdef HILDON
	filedialog = hildon_file_chooser_dialog_new(GTK_WINDOW(parent), GTK_FILE_CHOOSER_ACTION_OPEN);
	gtk_file_chooser_set_current_folder(GTK_FILE_CHOOSER(filedialog), XMAEME_ROMPATH_NES);
#else
	filedialog = gtk_file_chooser_dialog_new(_("Choose ROM"), GTK_WINDOW(parent), GTK_FILE_CHOOSER_ACTION_OPEN, 
			GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, GTK_STOCK_OPEN, GTK_RESPONSE_OK, NULL);
#endif

	if(GTK_RESPONSE_OK == gtk_dialog_run(GTK_DIALOG(filedialog))){
		gchar	*filename = gtk_file_chooser_get_filename(GTK_FILE_CHOOSER(filedialog));
		
		cursor = g_list_find_custom(filelist, filename, strcmp);  
		if(!cursor){
			//add rom to start of list and select it
			gtk_combo_box_prepend_text(GTK_COMBO_BOX(romlist),filename);
			gtk_combo_box_set_active(GTK_COMBO_BOX(romlist), 0);
		}//if rom isn't already in list
		g_free(filename);
	}//if file chosen

	gtk_widget_destroy(filedialog);
}//on_file_browse2_clicked


// GBA
void on_file_browse3_clicked(GtkButton *button, gpointer user_data) {
	GtkWidget	*filedialog = NULL,
			*romlist = lookup_widget(GTK_WIDGET(button), "romlist3"),
			*parent = lookup_widget(GTK_WIDGET(button), "mainwindow");
	GList	*cursor = NULL;

#ifdef HILDON
	filedialog = hildon_file_chooser_dialog_new(GTK_WINDOW(parent), GTK_FILE_CHOOSER_ACTION_OPEN);
	gtk_file_chooser_set_current_folder(GTK_FILE_CHOOSER(filedialog), XMAEME_ROMPATH_GBA);
#else
	filedialog = gtk_file_chooser_dialog_new(_("Choose ROM"), GTK_WINDOW(parent), GTK_FILE_CHOOSER_ACTION_OPEN, 
			GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, GTK_STOCK_OPEN, GTK_RESPONSE_OK, NULL);
#endif

	if(GTK_RESPONSE_OK == gtk_dialog_run(GTK_DIALOG(filedialog))){
		gchar	*filename = gtk_file_chooser_get_filename(GTK_FILE_CHOOSER(filedialog));
		
		cursor = g_list_find_custom(filelist, filename, strcmp);  
		if(!cursor){
			//add rom to start of list and select it
			gtk_combo_box_prepend_text(GTK_COMBO_BOX(romlist),filename);
			gtk_combo_box_set_active(GTK_COMBO_BOX(romlist), 0);
		}//if rom isn't already in list
		g_free(filename);
	}//if file chosen

	gtk_widget_destroy(filedialog);
}//on_file_browse3_clicked


#ifdef HILDON
gboolean key_press_cb(GtkWidget * widget, GdkEventKey * event,
		                      HildonWindow * window)
{
	gint	width = 0,
		height = 0;

	switch(event->keyval){
		case GDK_F6:
			gtk_window_get_size(GTK_WINDOW(window), &width, &height);
			if(width >= 800 && height >= 480){
				gtk_window_unfullscreen(GTK_WINDOW(window));
			}//fullscreen?
			else{
				gtk_window_fullscreen(GTK_WINDOW(window));
			}
			return TRUE;
			break;
	}//switch on key pressed

	return FALSE;
}
#endif

void show_error_dialog(const char *error_msg){
		GtkWidget *msgdialog = gtk_message_dialog_new(NULL, 0, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, "Error: %s",error_msg);
		gtk_dialog_run(GTK_DIALOG(msgdialog));
		gtk_widget_destroy(msgdialog);
}//show_error_dialog
