# Copyright (c) 2003-2004 Hyriand. All rights reserved.
#
import gtk

from transferlist import TransferList
from utils import PopupMenu
from pynicotine import slskmessages

class Downloads(TransferList):
	def __init__(self, frame):
		TransferList.__init__(self, frame, frame.DownloadList)

		self.popup_menu = popup = PopupMenu(frame)
		popup.setup(
			("Get place in queue", self.OnGetPlaceInQueue),
			("", None),
			("Copy URL", self.OnCopyURL),
			("Copy folder URL", self.OnCopyDirURL),
			("", None),
			("Send message", popup.OnSendMessage),
			("Show IP address", popup.OnShowIPaddress),
			("Get user info", popup.OnGetUserInfo),
			("Browse files", popup.OnBrowseUser),
			("Give privileges", popup.OnGivePrivileges),
			("$" + "Add user to list", popup.OnAddToList),
			("$" + "Ban this user", popup.OnBanUser),
			("$" + "Ignore this user", popup.OnIgnoreUser),
			("", None),
			("Abort", self.OnAbortTransfer),
			("Abort and remove file(s)", self.OnAbortRemoveTransfer),
			("Retry", self.OnRetryTransfer),
			("Clear", self.OnClearTransfer),
			("", None),
			("Clear finished/aborted", self.OnClearFinishedAborted),
			("Clear finished", self.OnClearFinished),
			("Clear aborted", self.OnClearAborted),
			("Clear queued", self.OnClearQueued),
		)
		frame.DownloadList.connect("button_press_event", self.DownListPop)
	
	def DownListPop(self, widget, event):
		if event.button == 1 and event.type == gtk.gdk._2BUTTON_PRESS:
			return self.OnPopupMenu(widget, event)

	def OnPopupMenu(self, widget, event):
		if event.button == 3:
			return False
		
		self.selected_transfers = []
		self.selected_users = []
		self.widget.get_selection().selected_foreach(self.SelectedTransfersCallback)

		items = self.popup_menu.get_children()

		if len(self.selected_users) == 0:
			items[0].set_sensitive(False)
		else:
			items[0].set_sensitive(True)
		
		act = False
		if len(self.selected_transfers) == 1:
			act = True
		items[2].set_sensitive(act)
		items[3].set_sensitive(act)

		act = False
		if len(self.selected_users) == 1:
			user = self.selected_users[0]
			self.popup_menu.set_user(user)
			act = True
			items[10].set_active(user in [i[0] for i in self.frame.np.config.sections["server"]["userlist"]])
			items[11].set_active(user in self.frame.np.config.sections["server"]["banlist"])
			items[12].set_active(user in self.frame.np.config.sections["server"]["ignorelist"])
			
		for i in range(5, 12):
			items[i].set_sensitive(act)
		
		act = len(self.selected_transfers) and True or False
		for i in range(13, 17):
			items[i].set_sensitive(act)
		
		self.popup_menu.popup(None, None, None, event.button, event.time)
		
		widget.emit_stop_by_name("button_press_event")
		return True
		
	def update(self, transfer = None):
		TransferList.update(self, transfer)
		if transfer is None and self.frame.np.transfers is not None:
			self.frame.np.transfers.SaveDownloads()

	def OnGetPlaceInQueue(self, widget):
		for i in self.selected_transfers:
			if i.status != "Queued":
				continue
			self.frame.np.ProcessRequestToPeer(i.user, slskmessages.PlaceInQueueRequest(None, i.filename))

	def OnRetryTransfer(self, widget):
		for transfer in self.selected_transfers:
			if transfer.status in ["Finished", "Old"]:
				continue
			self.frame.np.transfers.AbortTransfer(transfer)
			transfer.req = None
			self.frame.np.transfers.getFile(transfer.user, transfer.filename, transfer.path, transfer)
		self.frame.np.transfers.SaveDownloads()

	def OnAbortRemoveTransfer(self, widget):
		self.OnAbortTransfer(widget, True)
