#ifndef XMAEME_UTIL_H
#define XMAEME_UTIL_H

#include <glib.h>
#include <gtk/gtk.h>

/*
#define XMAEME_ROMPATH_MAME "mame/"
#define XMAEME_ROMPATH_NES "nes/"
#define XMAEME_ROMPATH_GBA "gba/"
#define XMAEME_ROMPATH_NEOGEO "neogeo/"
*/

#define XMAEME_SEARCH_PATHS_COUNT 2
static const char* XMAEME_SEARCH_PATHS[] = {"/media/mmc1/roms/","/media/mmc2/roms/"};
static const char* XMAEME_SUBPATHS[] = { "mame/","nes/","gba/","neogeo/" };

typedef enum{
	XMAEME_ROMTYPE_MAME,
	XMAEME_ROMTYPE_NES,
	XMAEME_ROMTYPE_GBA,
	XMAEME_ROMTYPE_NEOGEO
} xmaeme_rom_type;


static GList *filelist;


GList* get_installed_roms(xmaeme_rom_type romtype);
int strip_extension(char *filename);
void gfunc_g_free(gpointer data, gpointer user_data);
int gtk_combo_box_text_populate(GtkComboBox *box, const GList *items);
char* get_rom_full_path(const char* romname, xmaeme_rom_type romtype);
const char* get_rom_subpath(xmaeme_rom_type romtype);

#endif
