#include <dirent.h>
#include <errno.h>
#include <string.h>
#include <glib.h>

#include "util.h"


int taksort(const void *a, const void *b);


GList* get_installed_roms(const char *path, xmaeme_rom_type romtype){
	GList	*romlist = NULL;
	gchar	*name = NULL;
	struct dirent	**dirlist = NULL;
	int	numentries = 0,
		i = 0;

	numentries = scandir(path, &dirlist, NULL, taksort);
	
	if(0 > numentries){
		fprintf(stderr,"Error opening %s: %s\n", path, strerror(errno));
		return romlist;
	}//can't read path


	for(i=0;i<numentries;++i){
		if('.' != *(dirlist[i]->d_name)){
			if((!strcmp(dirlist[i]->d_name, "nes")) || 
			(!strcmp(dirlist[i]->d_name, "gba"))){
				continue; //don't add "nes" or "gba" to the dropdown
			}//if

			name = g_strdup(dirlist[i]->d_name);
			if(romtype == XMAEME_ROMTYPE_MAME){
				strip_extension(name);
			}
			romlist = g_list_prepend(romlist,name);
		}//if filename doestn't start with .
		g_free(dirlist[i]);
	}//for each entry
	
	g_free(dirlist);

	return romlist;
}//get_installed_roms


int strip_extension(char *filename){
	char	*cursor = strrchr(filename,'.');
	int	found = FALSE;

	if(cursor){
		found = TRUE;
		*cursor='\0';
	}//strip file extension

	return found;
}//strip_extension


void gfunc_g_free(gpointer data, gpointer user_data){
	g_free(data);
}//gfunc_g_free


int gtk_combo_box_text_populate(GtkComboBox *box, const GList *items){
	int i = 0;
	GList *cursor = (GList*)items;

	for(;cursor;cursor = cursor->next, ++i){
		gtk_combo_box_prepend_text(box, (const gchar*)(cursor->data));
	}//for each item

	if(items){
		gtk_combo_box_set_active(box, 0);
	}//if non-empty list

	return i;
}//gtk_combo_box_text_populate

// I guess not every arch has alphasort in dirent.h
int taksort(const void *a, const void *b){
	return strcoll((*(struct dirent **)a)->d_name, (*(struct dirent **)b)->d_name);
}//taksort
