#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <errno.h>

#include <sys/types.h>
#include <sys/wait.h>

#include "gngeo.h"
#include "util.h"


#define XMAEME_GNGEO_EXE	"gngeo"
#define XMAEME_GNGEO_FULLSCREEN	"--fullscreen"
#define XMAEME_GNGEO_SCREEN	"--screen320"
#define XMAEME_GNGEO_SOUND	"--sound"
#define XMAEME_GNGEO_NOSOUND	"--no-sound"
#define XMAEME_GNGEO_SAMPLERATE "--samplerate=11025"
#define XMAEME_GNGEO_BIOSPATH	"--biospath"
#define XMAEME_GNGEO_SCALE	"--scale"


gint launch_gngeo(const gchar *romname, const gchar *biospath, gboolean use_sound, gboolean maxscale){
	int	status = 0,
		pid = 0;

	if(!romname){
		return 1;
	}//if romname is NULL
	
	if((pid=fork())){
		waitpid(pid, &status, 0);
	}//parent
	else{
		int	i = 1;
		char	*args[8] = { XMAEME_GNGEO_EXE, NULL, NULL, NULL, NULL, NULL, NULL, NULL },
			*fullrom = NULL,
	       		*fskip = NULL,
			*biospatharg = NULL,
			*scalearg = NULL;

		fullrom = get_rom_full_path(romname, XMAEME_ROMTYPE_NEOGEO);
		biospatharg = g_strdup_printf("%s=%s",XMAEME_GNGEO_BIOSPATH,biospath);

		if(!fullrom){
			fullrom = g_strdup(romname);
		}//if

		args[i++] = XMAEME_GNGEO_SOUND;
		args[i++] = XMAEME_GNGEO_FULLSCREEN;

		if(maxscale){
			scalearg = g_strdup_printf("%s=2",XMAEME_GNGEO_SCALE);
			args[i++] = scalearg;
		}//if

		args[i++] = (char*)fullrom;
		
 		{ //debug
			int j = 0;

			printf("Child: running ");
			for(j=0;j<15;++j){
				printf("%s ", args[j]);
			}//for
			printf("\n");
		} //debug

		status=execvp(XMAEME_GNGEO_EXE,args);
		if(status<0){
			fprintf(stderr,"Unable to run %s: %s\n",XMAEME_GNGEO_EXE,strerror(errno));
		}//if an error occurred

		g_free(fullrom);
		g_free(biospatharg);
		g_free(scalearg);

		exit(0);
	}//child


	return status;
}//launch_gngeo
