/*
 * This file is part of vncviewer.
 *
 * Copyright (C) 2005, 2006 Aaron Levinson.
 *
 *
 * This software is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this software; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#ifndef __RFB_H__
#define __RFB_H__

#include <glib.h>

/* some defines so the types in rfbproto.h work ... */
#define CARD8  guint8
#define CARD16 guint16
#define CARD32 guint32

#define INT8   gint8
#define INT16  gint16
#define INT32  gint32

#define SERVERPORT (5900)

#include "rfbproto.h"

int connectToServer(char *display);
gboolean sameMachine(int fd);
gint32 doVersionHandshake(gint fd);
gchar *getFailReason(gint fd);
gint32 performAuth(gint fd, gchar *passwd);
gint sendClientInitMsg(gint fd, gboolean shared);
gint getServerInitMsg(gint fd, guint16 *width, guint16 *height,
                      rfbPixelFormat *format, gchar **name);

/* send a message to the server */
void rfb_send_and_destroy_message(gint fd, rfbClientToServerMsg *msg);

/* these functions will put together an appropriate rfbClientToServerMsg
 * structure for use with rfb_send_and_destroy_message.  You can also
 * g_free the returned structure if you decide not to send it */
rfbClientToServerMsg *newSetPixelFormatMsg(rfbPixelFormat *format);
rfbClientToServerMsg *newFixColourMapEntriesMsg(guint16 firstColour,
						guint16 nColours,
						guint16 *entries);
rfbClientToServerMsg *newSetEncodingsMsg(guint16 nEncodings,
					 guint32 *encodings);
rfbClientToServerMsg *newFramebufferUpdateRequestMsg(guint8 incremental,
						     guint16 x, guint16 y,
						     guint16 w, guint16 h);
rfbClientToServerMsg *newKeyEventMsg(guint8 down, guint32 key);
rfbClientToServerMsg *newPointerEventMsg(guint8 buttonMask,
					 guint16 x, guint16 y);
rfbClientToServerMsg *newClientCutTextMsg(guint32 length, gchar *text);

rfbServerToClientMsg *getServerMsg(gint fd);

typedef struct {
  guint8 width, height; /* for convenience -- not sent over wire */
  guint16 type;
  union {
    gchar raw[1];
    struct {
      guint32 bgcolour, fgcolour; /* only valid if bits set in type */
      guint32 nRects;
      struct {
	guint32 colour; /* only valid if SubrectsColoured */
	guint8 x, y, w, h;
      } rects[1];
    } rects;
  } data;
} rfbHextile;

typedef struct {
  rfbFramebufferUpdateRectHeader header;
  union {
    gchar raw[1];
    rfbCopyRect cr;
    struct {
      CARD32 nSubrects;
      guint32 bgPixel;
      struct {
	guint32 pixel;
	rfbRectangle rect;
      } rects[1];
    } rre;
    struct {
      CARD32 nSubrects;
      guint32 bgPixel;
      struct {
	guint32 pixel;
	rfbCoRRERectangle rect;
      } rects[1];
    } corre;
    struct {
      guint32 nTiles;
      rfbHextile *tiles[1];
    } hextile;
  } data;
} rfbRectangleDescription;

/* Get aditional info passed with a server message.  You can g_free the
 * results of these functions.  bpp is *bytes* per pixel */
rfbRectangleDescription *getNextRectangle(gint fd, gint bpp,
					  gboolean bMessages);
void freeRectangleDescription(rfbRectangleDescription *rd);
guint16 *getColourMapEntries(gint fd, guint16 nColours);
gchar *getServerCutText(gint fd, guint32 length);

#endif
