/*
 * mweather-window.h: Maemo weather main window
 *
 * Copyright (C) 2006 Philip Langdale
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Authors:
 *     Philip Langdale <philipl@mail.utexas.edu>
 */

#ifndef MWEATHER_WINDOW_H
#define MWEATHER_WINDOW_H

#include <gtk/gtk.h>
#include <hildon-widgets/hildon-window.h>
#include <libosso.h>

G_BEGIN_DECLS

#define MWEATHER_TYPE_WINDOW		(mweather_window_get_type())
#define MWEATHER_WINDOW(obj)		(G_TYPE_CHECK_INSTANCE_CAST((obj), MWEATHER_TYPE_WINDOW, MWeatherWindow))
#define MWEATHER_WINDOW_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST((klass), MWEATHER_TYPE_WINDOW, MWeatherWindowClass))
#define MWEATHER_IS_WINDOW(obj)		(G_TYPE_CHECK_INSTANCE_TYPE((obj), MWEATHER_TYPE_WINDOW))
#define MWEATHER_IS_WINDOW_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE((klass), MWEATHER_TYPE_WINDOW))
#define MWEATHER_WINDOW_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS((obj), MWEATHER_TYPE_WINDOW, MWeatherWindowClass))

typedef struct _MWeatherWindow MWeatherWindow;
typedef struct _MWeatherWindowPrivate MWeatherWindowPrivate;
typedef struct _MWeatherWindowClass MWeatherWindowClass;


struct _MWeatherWindow
{
   HildonWindow parent;

   /* private */
   MWeatherWindowPrivate *priv;
};


struct _MWeatherWindowClass
{
   HildonWindowClass parent_class;
};


GType		 mweather_window_get_type	(void);
GtkWidget	*mweather_window_new		(osso_context_t *ctx);
osso_context_t	*mweather_window_get_context	(void);


G_END_DECLS

#endif /* MWEATHER_WINDOW_H */
