/*
 * mweather-pref.c: Maemo weather preferences
 *
 * Copyright (C) 2006 Philip Langdale
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Authors:
 *     Philip Langdale <philipl@mail.utexas.edu>
 *     Papadimitriou Spiros <spapadim+@cs.cmu.edu> (Original GWeather code)
 */


#ifndef __MWEATHER_PREF_H_
#define __MWEATHER_PREF_H_

#include <gtk/gtkdialog.h>
#include "mweather-location.h"

G_BEGIN_DECLS

#define MWEATHER_TYPE_PREF		(mweather_pref_get_type ())
#define MWEATHER_PREF(obj)		(G_TYPE_CHECK_INSTANCE_CAST ((obj), MWEATHER_TYPE_PREF, MWeatherPref))
#define MWEATHER_PREF_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST ((klass), MWEATHER_TYPE_PREF, MWeatherPrefClass))
#define MWEATHER_IS_PREF(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), MWEATHER_TYPE_PREF))
#define MWEATHER_IS_PREF_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass), MWEATHER_TYPE_PREF))
#define MWEATHER_PREF_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS ((obj), MWEATHER_TYPE_PREF, MWeatherPrefClass))

typedef struct _MWeatherPref MWeatherPref;
typedef struct _MWeatherPrefPrivate MWeatherPrefPrivate;
typedef struct _MWeatherPrefClass MWeatherPrefClass;

struct _MWeatherPref
{
   GtkDialog parent;

   /* private */
   MWeatherPrefPrivate *priv;
};


struct _MWeatherPrefClass
{
   GtkDialogClass parent_class;
};

GType		 mweather_pref_get_type	(void);
GtkWidget	*mweather_pref_new	(MWeatherLocation *location);


G_END_DECLS

#endif /* __MWEATHER_PREF_H */

