/*
 * mweather-location.h: Maemo weather location
 *
 * Copyright (C) 2006 Philip Langdale
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Authors:
 *     Philip Langdale <philipl@mail.utexas.edu>
 */


#ifndef MWEATHER_LOCATION_H
#define MWEATHER_LOCATION_H

#include <glib.h>

G_BEGIN_DECLS

#define MWEATHER_TYPE_LOCATION			(mweather_location_get_type())
#define MWEATHER_LOCATION(obj)			(G_TYPE_CHECK_INSTANCE_CAST((obj), MWEATHER_TYPE_LOCATION, MWeatherLocation))
#define MWEATHER_LOCATION_CLASS(klass)		(G_TYPE_CHECK_CLASS_CAST((klass), MWEATHER_TYPE_LOCATION, MWeatherLocationClass))
#define MWEATHER_IS_LOCATION(obj)		(G_TYPE_CHECK_INSTANCE_TYPE((obj), MWEATHER_TYPE_LOCATION))
#define MWEATHER_IS_LOCATION_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE((klass), MWEATHER_TYPE_LOCATION))
#define MWEATHER_LOCATION_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS((obj), MWEATHER_TYPE_LOCATION, MWeatherLocationClass))

typedef struct _MWeatherLocation MWeatherLocation;
typedef struct _MWeatherLocationPrivate MWeatherLocationPrivate;
typedef struct _MWeatherLocationClass MWeatherLocationClass;


struct _MWeatherLocation
{
   GObject parent;

   /* private */
   MWeatherLocationPrivate *priv;
};


struct _MWeatherLocationClass
{
   GObjectClass parent_class;

   /* signals */
   void	(* updated)	(MWeatherLocation *location);
};


GType			 mweather_location_get_type	(void);
MWeatherLocation	*mweather_location_new		(const char *path);

void			 mweather_location_update	(MWeatherLocation *location);
gboolean		 mweather_location_is_valid	(MWeatherLocation *location);

const char		*mweather_location_get_name	(MWeatherLocation *location);
const char		*mweather_location_get_update	(MWeatherLocation *location);
const char		*mweather_location_get_cond	(MWeatherLocation *location);
const char		*mweather_location_get_sky	(MWeatherLocation *location);
const char		*mweather_location_get_temp	(MWeatherLocation *location);
const char		*mweather_location_get_feel	(MWeatherLocation *location);
const char		*mweather_location_get_dewpoint	(MWeatherLocation *location);
const char		*mweather_location_get_humidity	(MWeatherLocation *location);
const char		*mweather_location_get_wind	(MWeatherLocation *location);
const char		*mweather_location_get_pressure	(MWeatherLocation *location);
const char		*mweather_location_get_visi	(MWeatherLocation *location);
const char		*mweather_location_get_sunrise	(MWeatherLocation *location);
const char		*mweather_location_get_sunset	(MWeatherLocation *location);

const char		*mweather_location_get_summary	(MWeatherLocation *location);
GdkPixbuf		*mweather_location_get_pixbuf	(MWeatherLocation *location,
							 gboolean small);

GdkPixbufAnimation	*mweather_location_get_radar	(MWeatherLocation *location);
const char		*mweather_location_get_forecast	(MWeatherLocation *location);

G_END_DECLS

#endif /* MWEATHER_LOCATION_H */
