/*
 * mweather-details.h: Maemo details widget
 *
 * Copyright (C) 2006 Philip Langdale
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Authors:
 *     Philip Langdale <philipl@mail.utexas.edu>
 */

#ifndef MWEATHER_DETAILS_H
#define MWEATHER_DETAILS_H

#include <gtk/gtk.h>

#include "mweather-location.h"

G_BEGIN_DECLS

#define MWEATHER_TYPE_DETAILS			(mweather_details_get_type())
#define MWEATHER_DETAILS(obj)			(G_TYPE_CHECK_INSTANCE_CAST((obj), MWEATHER_TYPE_DETAILS, MWeatherDetails))
#define MWEATHER_DETAILS_CLASS(klass)		(G_TYPE_CHECK_CLASS_CAST((klass), MWEATHER_TYPE_DETAILS, MWeatherDetailsClass))
#define MWEATHER_IS_DETAILS(obj)		(G_TYPE_CHECK_INSTANCE_TYPE((obj), MWEATHER_TYPE_DETAILS))
#define MWEATHER_IS_DETAILS_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE((klass), MWEATHER_TYPE_DETAILS))
#define MWEATHER_DETAILS_GET_CLASS(obj)		(G_TYPE_INSTANCE_GET_CLASS((obj), MWEATHER_TYPE_DETAILS, MWeatherDetailsClass))

typedef struct _MWeatherDetails MWeatherDetails;
typedef struct _MWeatherDetailsPrivate MWeatherDetailsPrivate;
typedef struct _MWeatherDetailsClass MWeatherDetailsClass;


struct _MWeatherDetails
{
   GtkNotebook parent;

   /* private */
   MWeatherDetailsPrivate *priv;
};


struct _MWeatherDetailsClass
{
   GtkNotebookClass parent_class;
};


GType		 mweather_details_get_type	(void);
GtkWidget	*mweather_details_new		(void);

void		 mweather_details_set_location	(MWeatherDetails *details,
						 MWeatherLocation *location);

G_END_DECLS

#endif /* MWEATHER_DETAILS_H */
