/*
 * main.c: Maemo weather application
 *
 * Copyright (C) 2005 Philip Langdale
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Authors:
 *     Philip Langdale <philipl@mail.utexas.edu>
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <libgnomevfs/gnome-vfs-init.h>
#include <hildon-widgets/hildon-program.h>
#include <libosso.h>

#include "mweather-window.h"


static gint
dbus_callback (const gchar *interface, const gchar *method,
               GArray *arguments, gpointer data,
               osso_rpc_t *retval)
{
   if (!strcmp (method, "top_application")) {
      gtk_window_present(GTK_WINDOW(data));
   }

   retval->type = DBUS_TYPE_INVALID;
   return OSSO_OK;
}


int
main (int argc, char *argv[])
{
   HildonProgram *app;
   GtkWidget *window;

   osso_context_t *ctxt;
   osso_return_t ret;

   gtk_init (&argc, &argv);
   gnome_vfs_init ();

   app = HILDON_PROGRAM (hildon_program_get_instance ());
   g_set_application_name ("Weather");

   ctxt = osso_initialize("mweather", PACKAGE_VERSION, TRUE, NULL);
   if (ctxt == NULL) {
      g_error("osso_initialize failed\n");
      exit(EXIT_FAILURE);
   }

   ret = osso_rpc_set_default_cb_f (ctxt, dbus_callback, app);
   if (ret != OSSO_OK)
   {
      g_error("osso_rpc_set_default_cb_f failed: %d.\n", ret);
      exit(EXIT_FAILURE);
   }

   window = mweather_window_new(ctxt);
   gtk_widget_show(window);
   hildon_program_add_window(app, HILDON_WINDOW(window));

#if 0
   gw_applet->gconf = gweather_gconf_new("/apps/gweather/prefs");
   gw_applet->ctxt = ctxt;
   gw_applet->gweather_info = NULL;
   gweather_applet_create(gw_applet);
   gweather_prefs_load(&gw_applet->gweather_pref, gw_applet->gconf);
   gweather_update(gw_applet);
#endif

   gtk_main ();

   gnome_vfs_shutdown ();
   osso_deinitialize (ctxt);

   return EXIT_SUCCESS;
}
