#include "pidinfo.h"
#include "gtk/gtk.h"

#define LOAD_DIALOG_CLOSE 0

enum {
   LOAD_COLUMN_PNAME,
   LOAD_COLUMN_SIZE,
   LOAD_COLUMN_NCOLUMNS
};

void
load_populate_iter (gpointer data, gpointer user_data)
{
	GtkListStore *store = (GtkListStore*)user_data;
	PidInfo *d = (PidInfo*)data;
	GtkTreeIter iter;

	gtk_list_store_append (store, &iter);

	gtk_list_store_set (store, &iter, LOAD_COLUMN_PNAME, d->name, LOAD_COLUMN_SIZE, d->vmrss, -1);
}

GtkListStore*
populate_store (void)
{
	GtkListStore *store;
	GSList *list;

	list = pidinfo_get_processes (-1);
	if (!list)
		return NULL;


	list = g_slist_sort (list, pidinfo_sort_by_size);

	store = gtk_list_store_new (LOAD_COLUMN_NCOLUMNS, G_TYPE_STRING, G_TYPE_INT);

	g_slist_foreach ( list, load_populate_iter, store);

	return store;
}



int
main (int argc, char *argv[])
{
	GtkWidget *dialog;
    GtkWidget *button_close;
    GtkWidget *button_kill;
    GtkWidget *button_watch;
    gint result;
	GtkListStore *store;
	GtkWidget *tree;
	GtkCellRenderer *renderer;
	GtkTreeViewColumn *column;

	gtk_init(&argc, &argv);

    dialog = gtk_dialog_new_with_buttons ("Processes",
                                           NULL,
                                           GTK_DIALOG_MODAL,
                                           NULL);

	button_watch = gtk_dialog_add_button(GTK_DIALOG(dialog), "Watch", LOAD_DIALOG_CLOSE);
	button_kill = gtk_dialog_add_button(GTK_DIALOG(dialog), "Kill", LOAD_DIALOG_CLOSE);
    button_close = gtk_dialog_add_button(GTK_DIALOG(dialog), "Close", LOAD_DIALOG_CLOSE);

	store = populate_store ();
	tree = gtk_tree_view_new_with_model (GTK_TREE_MODEL (store));
	gtk_box_pack_start (GTK_BOX(GTK_DIALOG(dialog)->vbox),
                            tree,
                            TRUE, 
                            TRUE,
                            0);

	renderer = gtk_cell_renderer_text_new ();
	column = gtk_tree_view_column_new_with_attributes ("Process name",
                                                   renderer,
                                                   "text", LOAD_COLUMN_PNAME,
                                                   NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (tree), column);

	renderer = gtk_cell_renderer_text_new ();
	column = gtk_tree_view_column_new_with_attributes ("Size",
                                                   renderer,
                                                   "text", LOAD_COLUMN_SIZE,
                                                   NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (tree), column);


    gtk_widget_show_all(dialog);

    result = gtk_dialog_run (GTK_DIALOG (dialog));
    switch (result) {
    case LOAD_DIALOG_CLOSE:
        gtk_widget_destroy (dialog);
        break;
    default:
		break;
	}
	return 0;
}
