/* 
 * Copyright (c) 2006, Jakub Pavelek <jpavelek@welho.com>
 * All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *        documentation and/or other materials provided with the distribution.
 *     * Neither the name of the University of California, Berkeley nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE REGENTS AND CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef H_PIDINFO
#define H_PIDINFO

#include <stdio.h>
#include <glib.h>
#include <string.h>

typedef struct t_PidInfo {
	gint pid;
	gint ppid;
	gint uid;
	gchar *name;
	gint vmrss;
	gint vmdata;
	gint vmlib;
} PidInfo;

typedef enum { PI_NONE, PI_PID, PI_PPID, PI_UID, PI_NAME, PI_VMRSS, PI_VMDATA, PI_VMLIB } PidInfoFieldsEnum;

typedef struct t_PidFields {
	PidInfoFieldsEnum index;
	const gchar *needle;
} PidFields;

/**
 *
 * Get a list of processes with their data 
 *
 * @param cut_from: integer. List only processes with bigger pid than the cut_from pid
 * @return: Allocated GSList with the PidInfo structure in the data element. To be freed by the user.
 */
GSList*
pidinfo_get_processes (int cut_from);


/**
 *
 * Sort the process list by the VmRSS
 *
 * Operates on GSList 
 */
gint
pidinfo_sort_by_size (gconstpointer a, gconstpointer b);

/**
 *
 * Finds a process description for a PID
 *
 */
const PidInfo*
pidinfo_get_by_pid (const GSList *list, gint pid);

/* TEMPORARY - REMOVE */
void
pidinfo_print_tree (gint pid, GSList *list);

#endif
