
#include <glib.h>

// Disable the 'const' function attribute of the get_type() functions.
// GCC would optimize them out because we don't use the return value.
#undef  G_GNUC_CONST
#define G_GNUC_CONST /* empty */

#include <hildon-widgetsmm/wrap_init.h>
#include <glibmm/error.h>
#include <glibmm/object.h>

// #include the widget headers so that we can call the get_type() static methods:

#include "add-home-dialog.h"
#include "calendar-popup.h"
#include "color-button.h"
#include "color-selector.h"
#include "controlbar.h"
#include "date-editor.h"
#include "font-selection-dialog.h"
#include "get-password-dialog.h"
#include "grid.h"
#include "grid-item.h"
#include "hvolumebar.h"
#include "name-password-dialog.h"
#include "note.h"
#include "number-editor.h"
#include "range-editor.h"
#include "seekbar.h"
#include "set-password-dialog.h"
#include "sort-dialog.h"
#include "telephone-editor.h"
#include "time-editor.h"
#include "time-picker.h"
#include "volumebar.h"
#include "vvolumebar.h"
#include "weekday-picker.h"
#include "wizard-dialog.h"
#include "app.h"
#include "appview.h"
#include "caption.h"
#include "find-toolbar.h"

extern "C"
{

//Declarations of the *_get_type() functions:

GType hildon_add_home_dialog_get_type(void);
GType hildon_app_get_type(void);
GType hildon_appview_get_type(void);
GType hildon_calendar_popup_get_type(void);
GType hildon_caption_get_type(void);
GType hildon_color_button_get_type(void);
GType hildon_color_selector_get_type(void);
GType hildon_controlbar_get_type(void);
GType hildon_date_editor_get_type(void);
GType hildon_find_toolbar_get_type(void);
GType hildon_font_selection_dialog_get_type(void);
GType hildon_get_password_dialog_get_type(void);
GType hildon_grid_get_type(void);
GType hildon_grid_item_get_type(void);
GType hildon_hvolumebar_get_type(void);
GType hildon_name_password_dialog_get_type(void);
GType hildon_note_get_type(void);
GType hildon_number_editor_get_type(void);
GType hildon_range_editor_get_type(void);
GType hildon_seekbar_get_type(void);
GType hildon_set_password_dialog_get_type(void);
GType hildon_sort_dialog_get_type(void);
GType hildon_telephone_editor_get_type(void);
GType hildon_time_editor_get_type(void);
GType hildon_time_picker_get_type(void);
GType hildon_vvolumebar_get_type(void);
GType hildon_volumebar_get_type(void);
GType hildon_weekday_picker_get_type(void);
GType hildon_wizard_dialog_get_type(void);

//Declarations of the *_error_quark() functions:

} // extern "C"


//Declarations of the *_Class::wrap_new() methods, instead of including all the private headers:

namespace Hildon {  class AddHomeDialog_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Hildon {  class App_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Hildon {  class AppView_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Hildon {  class CalendarPopup_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Hildon {  class Caption_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Hildon {  class ColorButton_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Hildon {  class ColorSelector_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Hildon {  class Controlbar_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Hildon {  class DateEditor_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Hildon {  class FindToolbar_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Hildon {  class FontSelectionDialog_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Hildon {  class GetPasswordDialog_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Hildon {  class Grid_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Hildon {  class GridItem_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Hildon {  class HVolumebar_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Hildon {  class NamePasswordDialog_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Hildon {  class Note_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Hildon {  class NumberEditor_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Hildon {  class RangeEditor_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Hildon {  class Seekbar_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Hildon {  class SetPasswordDialog_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Hildon {  class SortDialog_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Hildon {  class TelephoneEditor_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Hildon {  class TimeEditor_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Hildon {  class TimePicker_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Hildon {  class VVolumebar_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Hildon {  class Volumebar_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Hildon {  class WeekdayPicker_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Hildon {  class WizardDialog_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }

namespace Hildon { 

void wrap_init()
{
  // Register Error domains:

// Map gtypes to gtkmm wrapper-creation functions:
  Glib::wrap_register(hildon_add_home_dialog_get_type(), &Hildon::AddHomeDialog_Class::wrap_new);
  Glib::wrap_register(hildon_app_get_type(), &Hildon::App_Class::wrap_new);
  Glib::wrap_register(hildon_appview_get_type(), &Hildon::AppView_Class::wrap_new);
  Glib::wrap_register(hildon_calendar_popup_get_type(), &Hildon::CalendarPopup_Class::wrap_new);
  Glib::wrap_register(hildon_caption_get_type(), &Hildon::Caption_Class::wrap_new);
  Glib::wrap_register(hildon_color_button_get_type(), &Hildon::ColorButton_Class::wrap_new);
  Glib::wrap_register(hildon_color_selector_get_type(), &Hildon::ColorSelector_Class::wrap_new);
  Glib::wrap_register(hildon_controlbar_get_type(), &Hildon::Controlbar_Class::wrap_new);
  Glib::wrap_register(hildon_date_editor_get_type(), &Hildon::DateEditor_Class::wrap_new);
  Glib::wrap_register(hildon_find_toolbar_get_type(), &Hildon::FindToolbar_Class::wrap_new);
  Glib::wrap_register(hildon_font_selection_dialog_get_type(), &Hildon::FontSelectionDialog_Class::wrap_new);
  Glib::wrap_register(hildon_get_password_dialog_get_type(), &Hildon::GetPasswordDialog_Class::wrap_new);
  Glib::wrap_register(hildon_grid_get_type(), &Hildon::Grid_Class::wrap_new);
  Glib::wrap_register(hildon_grid_item_get_type(), &Hildon::GridItem_Class::wrap_new);
  Glib::wrap_register(hildon_hvolumebar_get_type(), &Hildon::HVolumebar_Class::wrap_new);
  Glib::wrap_register(hildon_name_password_dialog_get_type(), &Hildon::NamePasswordDialog_Class::wrap_new);
  Glib::wrap_register(hildon_note_get_type(), &Hildon::Note_Class::wrap_new);
  Glib::wrap_register(hildon_number_editor_get_type(), &Hildon::NumberEditor_Class::wrap_new);
  Glib::wrap_register(hildon_range_editor_get_type(), &Hildon::RangeEditor_Class::wrap_new);
  Glib::wrap_register(hildon_seekbar_get_type(), &Hildon::Seekbar_Class::wrap_new);
  Glib::wrap_register(hildon_set_password_dialog_get_type(), &Hildon::SetPasswordDialog_Class::wrap_new);
  Glib::wrap_register(hildon_sort_dialog_get_type(), &Hildon::SortDialog_Class::wrap_new);
  Glib::wrap_register(hildon_telephone_editor_get_type(), &Hildon::TelephoneEditor_Class::wrap_new);
  Glib::wrap_register(hildon_time_editor_get_type(), &Hildon::TimeEditor_Class::wrap_new);
  Glib::wrap_register(hildon_time_picker_get_type(), &Hildon::TimePicker_Class::wrap_new);
  Glib::wrap_register(hildon_vvolumebar_get_type(), &Hildon::VVolumebar_Class::wrap_new);
  Glib::wrap_register(hildon_volumebar_get_type(), &Hildon::Volumebar_Class::wrap_new);
  Glib::wrap_register(hildon_weekday_picker_get_type(), &Hildon::WeekdayPicker_Class::wrap_new);
  Glib::wrap_register(hildon_wizard_dialog_get_type(), &Hildon::WizardDialog_Class::wrap_new);

  // Register the gtkmm gtypes:
  Hildon::AddHomeDialog::get_type();
  Hildon::App::get_type();
  Hildon::AppView::get_type();
  Hildon::CalendarPopup::get_type();
  Hildon::Caption::get_type();
  Hildon::ColorButton::get_type();
  Hildon::ColorSelector::get_type();
  Hildon::Controlbar::get_type();
  Hildon::DateEditor::get_type();
  Hildon::FindToolbar::get_type();
  Hildon::FontSelectionDialog::get_type();
  Hildon::GetPasswordDialog::get_type();
  Hildon::Grid::get_type();
  Hildon::GridItem::get_type();
  Hildon::HVolumebar::get_type();
  Hildon::NamePasswordDialog::get_type();
  Hildon::Note::get_type();
  Hildon::NumberEditor::get_type();
  Hildon::RangeEditor::get_type();
  Hildon::Seekbar::get_type();
  Hildon::SetPasswordDialog::get_type();
  Hildon::SortDialog::get_type();
  Hildon::TelephoneEditor::get_type();
  Hildon::TimeEditor::get_type();
  Hildon::TimePicker::get_type();
  Hildon::VVolumebar::get_type();
  Hildon::Volumebar::get_type();
  Hildon::WeekdayPicker::get_type();
  Hildon::WizardDialog::get_type();

} // wrap_init()

} //Hildon


