// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _HILDON_WIDGETSMM_TELEPHONE_EDITOR_H
#define _HILDON_WIDGETSMM_TELEPHONE_EDITOR_H


#include <glibmm.h>

/* $Id: number-editor.hg,v 1.10 2005/02/15 10:52:44 murrayc Exp $ */

/* number-editor.h
 *
 * Copyright (C) 1998-2005 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/container.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _HildonTelephoneEditor HildonTelephoneEditor;
typedef struct _HildonTelephoneEditorClass HildonTelephoneEditorClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Hildon
{ class TelephoneEditor_Class; } // namespace Hildon
namespace Hildon
{

/** @addtogroup hildon_widgetsmmEnums Enums and Flags */

/**
 * @ingroup hildon_widgetsmmEnums
 */
enum TelephoneEditorFormat
{
  TELEPHONE_EDITOR_FORMAT_FREE,
  TELEPHONE_EDITOR_FORMAT_COERCE,
  TELEPHONE_EDITOR_FORMAT_COERCE_COUNTRY,
  TELEPHONE_EDITOR_FORMAT_COERCE_AREA
};


/** 
 *
 * @ingroup Widgets
 */

class TelephoneEditor : public Gtk::Container
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef TelephoneEditor CppObjectType;
  typedef TelephoneEditor_Class CppClassType;
  typedef HildonTelephoneEditor BaseObjectType;
  typedef HildonTelephoneEditorClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~TelephoneEditor();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class TelephoneEditor_Class;
  static CppClassType telephoneeditor_class_;

  // noncopyable
  TelephoneEditor(const TelephoneEditor&);
  TelephoneEditor& operator=(const TelephoneEditor&);

protected:
  explicit TelephoneEditor(const Glib::ConstructParams& construct_params);
  explicit TelephoneEditor(HildonTelephoneEditor* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  HildonTelephoneEditor*       gobj()       { return reinterpret_cast<HildonTelephoneEditor*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const HildonTelephoneEditor* gobj() const { return reinterpret_cast<HildonTelephoneEditor*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


private:

public:
  explicit TelephoneEditor(TelephoneEditorFormat format);
  explicit TelephoneEditor(TelephoneEditorFormat format, const Glib::ustring& country, const Glib::ustring& area, const Glib::ustring& number);

  
  /** Specify wheter the fields in coerse format are editable or
   * not. This function is ignored if the editor is in free mode. The
   * number or area and number parameters are ignored if the editor is
   * in HILDON_TELEPHONE_EDITOR_FORMAT_COERCE_AREA or
   * HILDON_TELEPHONE_EDITOR_FORMAT_COERCE_COUNTRY formats,
   * respectively.
   * @param country Set the editable status of the country field in coarce format.
   * @param area Set the editable status of the area field in coarce format.
   * @param number Set the editable status of the number field in coarce format.
   */
  void set_editable(bool country = true, bool area = true, bool number = true);
  
  /** Show or hide the plus sign in front of coerce format's country field.
   * @param show Show the plus sign.
   */
  void set_show_plus(bool show = true);
  
  /** Get the visibility status of the plus sign in
   * front of coerce format's country field.
   * @return <tt>bool</tt>.
   */
  bool get_show_plus() const;
  
  /** Show or hide the border around the widget
   * @param show Show the border.
   */
  void set_show_border(bool show = true);
  
  /** Get the visibility status of the border around the widget.
   * @return <tt>bool</tt>.
   */
  bool get_show_border() const;
  
  /** Set widths of the fields in coecse format. Country and area parameters
   * are ignored, if the editor is in free mode. The number or area and number
   * parameters are ignored if the editor is in
   * HILDON_TELEPHONE_EDITOR_FORMAT_COERCE_AREA or
   * HILDON_TELEPHONE_EDITOR_FORMAT_COERCE_COUNTRY mode, respectively.
   * @param country Width (characters) of the country field in coarce mode.
   * @param area Width (characters) of the area field in coarce mode.
   * @param number Width (characters) of the number field in coarce mode.
   */
  void set_widths(guint country, guint area, guint number);
  
  /** Get text in the country field in coarse format. This function must
   * not be called if in free mode.
   * @return Pointer to the text in the country field. It must not
   * be changed or freed.
   */
  Glib::ustring get_country() const;
  
  /** Set text in the country field in coarse format. This function must
   * not be called if in free mode.
   * @param country Text to be set in country field.
   */
  void set_country(const Glib::ustring& country);
  
  /** Get text in the area field in coarse format. This function must not
   * be called if in free mode or in
   * HILDON_TELEPHONE_EDITOR_FORMAT_COERCE_COUNTRY mode.
   * @return Pointer to the text in the area field. It must not be
   * changed or freed.
   */
  Glib::ustring get_area() const;
  
  /** Set text in the area field in coarse format. This function must not
   * be called if in free mode or in
   * HILDON_TELEPHONE_EDITOR_FORMAT_COERCE_COUNTRY mode.
   * @param area Text to be set in area field.
   */
  void set_area(const Glib::ustring& area);
  
  /** Get text in the number field in all formats. In free mode, this
   * functions returns the whole phone number. In coarce mode, it returns
   * only the number field. This function must not be called if
   * the editor is in HILDON_TELEPHONE_EDITOR_FORMAT_COERCE_AREA or
   * HILDON_TELEPHONE_EDITOR_FORMAT_COERCE_COUNTRY modes.
   * @return Pointer to text in the number field. It must not be
   * changed or freed.
   */
  Glib::ustring get_number() const;
  
  /** Set text in the number field in all formats. In free mode this
   * functions sets the whole phone number. In coerce mode, it sets
   * only the number field. This function must not be called if
   * the editor is in HILDON_TELEPHONE_EDITOR_FORMAT_COERSE_AREA or
   * HILDON_TELEPHONE_EDITOR_FORMAT_COERCE_COUNTRY modes.
   * @param number Text to be set to number field.
   */
  void set_number(const Glib::ustring& number);

  //TODO: These set- prefixes are a bit strange:
  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Country string.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Glib::ustring> property_country() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Country string.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_country() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Area string.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Glib::ustring> property_area() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Area string.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_area() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Number string.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Glib::ustring> property_number() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Number string.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_number() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Wether to show the border around the widget.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_show_border() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Wether to show the border around the widget.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_show_border() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Wether to show the plus sign in front of coerce format's country field.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_show_plus() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Wether to show the plus sign in front of coerce format's country field.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_show_plus() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Sets telephoneditor format.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<TelephoneEditorFormat> property_set_format() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


};

} // namespace Hildon


namespace Glib
{
  /** @relates Hildon::TelephoneEditor
   * @param object The C instance
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   */
  Hildon::TelephoneEditor* wrap(HildonTelephoneEditor* object, bool take_copy = false);
} //namespace Glib


#endif /* _HILDON_WIDGETSMM_TELEPHONE_EDITOR_H */

