// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _HILDON_WIDGETSMM_DATE_EDITOR_H
#define _HILDON_WIDGETSMM_DATE_EDITOR_H


#include <glibmm.h>

/* $Id: date-editor.hg,v 1.10 2005/02/15 10:52:44 murrayc Exp $ */

/* date-editor.h
 *
 * Copyright (C) 1998-2005 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/container.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _HildonDateEditor HildonDateEditor;
typedef struct _HildonDateEditorClass HildonDateEditorClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Hildon
{ class DateEditor_Class; } // namespace Hildon
namespace Hildon
{

/** @addtogroup hildon_widgetsmmEnums Enums and Flags */

/**
 * @ingroup hildon_widgetsmmEnums
 */
enum DateEditorErrorType
{
  MAX_DAY,
  MAX_MONTH,
  MAX_YEAR,
  MIN_DAY,
  MIN_MONTH,
  MIN_YEAR,
  EMPTY_DAY,
  EMPTY_MONTH,
  YEAR,
  DATE
};


/** 
 *
 * @ingroup Widgets
 */

class DateEditor : public Gtk::Container
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef DateEditor CppObjectType;
  typedef DateEditor_Class CppClassType;
  typedef HildonDateEditor BaseObjectType;
  typedef HildonDateEditorClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~DateEditor();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class DateEditor_Class;
  static CppClassType dateeditor_class_;

  // noncopyable
  DateEditor(const DateEditor&);
  DateEditor& operator=(const DateEditor&);

protected:
  explicit DateEditor(const Glib::ConstructParams& construct_params);
  explicit DateEditor(HildonDateEditor* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  HildonDateEditor*       gobj()       { return reinterpret_cast<HildonDateEditor*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const HildonDateEditor* gobj() const { return reinterpret_cast<HildonDateEditor*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


private:

public:
  DateEditor();
  

  /** Sets the date shown in the editor.
   * @param year Year.
   * @param month Month.
   * @param day Day.
   */
  void set_date(guint year, guint month, guint day);

  
  /** 
   * @param year Year.
   * @param month Month.
   * @param day Day.
   * @return The year, month, and day currently on the
   * date editor.
   */
  void get_date(guint& year, guint& month, guint& day);

  
  /** Sets the year shown in the editor.
   * @param year Year.
   * @return <tt>true</tt> if the year is valid.
   */
  bool set_year(guint year);
  
  /** Sets the month shown in the editor.
   * @param month Month.
   * @return <tt>true</tt> if the month is valid.
   */
  bool set_month(guint month);
  
  /** Sets the day shown in the editor.
   * @param day Day.
   * @return <tt>true</tt> if the day is valid.
   */
  bool set_day(guint day);

  
  /** 
   * @return The current year shown in the editor.
   */
  guint get_year() const;
  
  /** Gets the month shown in the editor.
   * @return The current month shown in the editor.
   */
  guint get_month() const;
  
  /** Gets the day shown in the editor.
   * @return The current day shown in the editor.
   */
  guint get_day() const;

  //TODO: This should probably be wrapped as an exception:
  //TODO: Fix registration: _WRAP_SIGNAL(bool date_error(DateEditorErrorType type), "date_error")

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Current year.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<guint> property_year() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Current year.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<guint> property_year() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Current month.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<guint> property_month() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Current month.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<guint> property_month() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Current day.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<guint> property_day() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Current day.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<guint> property_day() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


};

} // namespace Hildon


namespace Glib
{
  /** @relates Hildon::DateEditor
   * @param object The C instance
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   */
  Hildon::DateEditor* wrap(HildonDateEditor* object, bool take_copy = false);
} //namespace Glib


#endif /* _HILDON_WIDGETSMM_DATE_EDITOR_H */

