// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _HILDON_WIDGETSMM_APPVIEW_H
#define _HILDON_WIDGETSMM_APPVIEW_H


#include <glibmm.h>

/* $Id: AppView.hg,v 1.10 2005/02/15 10:52:44 murrayc Exp $ */

/* AppView.h
 *
 * Copyright (C) 1998-2005 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/bin.h>
#include <gtkmm/menu.h>
#include <gtkmm/adjustment.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _HildonAppView HildonAppView;
typedef struct _HildonAppViewClass HildonAppViewClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Hildon
{ class AppView_Class; } // namespace Hildon
namespace Hildon
{

/**
 *
 * @ingroup Widgets
 */

class AppView : public Gtk::Bin
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef AppView CppObjectType;
  typedef AppView_Class CppClassType;
  typedef HildonAppView BaseObjectType;
  typedef HildonAppViewClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~AppView();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class AppView_Class;
  static CppClassType appview_class_;

  // noncopyable
  AppView(const AppView&);
  AppView& operator=(const AppView&);

protected:
  explicit AppView(const Glib::ConstructParams& construct_params);
  explicit AppView(HildonAppView* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  HildonAppView*       gobj()       { return reinterpret_cast<HildonAppView*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const HildonAppView* gobj() const { return reinterpret_cast<HildonAppView*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
  virtual void on_toolbar_changed();
  virtual void on_toolbar_toggle_request();
  virtual void on_fullscreen_state_change(bool is_fullscreen);
  virtual void on_title_change();
  virtual void on_switched_to();
  virtual void on_switched_from();
  virtual void on_increase_button_event(guint newkeytype);
  virtual void on_decrease_button_event(guint newkeytype);
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


private:

public:
  explicit AppView(const Glib::ustring& title);
  

  /** Adds the @a child  to the @a self (HildonAppView) and creates a vertical 
   * scrollbar to it. Similar as adding first a Gtk::ScrolledWindow 
   * and then the @a child  to it.
   * @param child A @a GtkWidget .
   */
  void add_with_scrollbar(Gtk::Widget& child);
  
  /** Sets given Hildon::AppView whether to allow toggling fullscreen mode
   * with a shortcut key.
   * @param allow Wheter it's possible to swith fullscreen on/off with
   * a shortcut key.
   */
  void set_fullscreen_key_allowed(bool allow = true);
  
  /** Check if fullscreening with a shortcut is allowed for given
   * Hildon::AppView.
   * @return Wheter it's possible to swith fullscreen on/off with
   * a shortcut key.
   */
  bool get_fullscreen_key_allowed() const;

  
  /** Gets the current state of fullscreen mode.
   * @return The current state of fullscreen mode.
   */
  bool get_fullscreen() const;
  
  /** Set the fullscreen state of given Hildon::AppView class.
   * @param fullscreen The new state of fullscreen mode. <tt>true</tt> means fullscreen
   * will be set. <tt>false</tt> the opposite.
   */
  void set_fullscreen(bool fullscreen = true);
  
  /** Gets the Gt::Menu assigned to the Hildon::Appview.
   * @return The Gtk::Menu assigned to this application view.
   */
  Gtk::Menu* get_menu();
  
  /** Gets the Gt::Menu assigned to the Hildon::Appview.
   * @return The Gtk::Menu assigned to this application view.
   */
  const Gtk::Menu* get_menu() const;


  //Ingore deprecated functions.
  

  /** Sets an title of an application view. The title is visible only if
   * two-part-title is enabled on the Hildon::App.
   * @param newname The new title of the application view.
   */
  void set_title(const Glib::ustring& newname);
  
  /** Gets the title of given Hildon::AppView.
   * @return The title of the application view.
   */
  Glib::ustring get_title() const;


  /** Sets a Gtk::Adjustment which will change when increase/decrease buttons
   * are pressed.
   * @param adjustment A new Gtk::Adjustment set to reach to increase
   * / decrease hardware keys or <tt>0</tt> to unset.
   */
  void set_connected_adjustment(Gtk::Adjustment& adjustment);
  
  /** Retrieves the Gtk::Adjustment which is connected to this application view
   * and is changed with increase / decrease hardware buttons.
   * @return Currently connectd Gtk::Adjustment assigned to this
   * application view or <tt>0</tt> if it's not set.
   */
  Gtk::Adjustment* get_connected_adjustment();
  
  /** Retrieves the Gtk::Adjustment which is connected to this application view
   * and is changed with increase / decrease hardware buttons.
   * @return Currently connectd Gtk::Adjustment assigned to this
   * application view or <tt>0</tt> if it's not set.
   */
  const Gtk::Adjustment* get_connected_adjustment() const;

  
  Glib::SignalProxy0< void > signal_toolbar_changed();

  
  Glib::SignalProxy0< void > signal_toolbar_toggle_request();

  
  Glib::SignalProxy1< void,bool > signal_fullscreen_state_change();

  
  Glib::SignalProxy0< void > signal_title_change();

  
  Glib::SignalProxy0< void > signal_switched_to();

  
  Glib::SignalProxy0< void > signal_switched_from();

  
  Glib::SignalProxy1< void,guint > signal_increase_button_event();

  
  Glib::SignalProxy1< void,guint > signal_decrease_button_event();


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The GtkAdjustment. The increase and decrease hardware buttons are mapped to this.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Gtk::Adjustment*> property_connected_adjustment() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The GtkAdjustment. The increase and decrease hardware buttons are mapped to this.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Gtk::Adjustment*> property_connected_adjustment() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the fullscreen key is allowed or not.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_fullscreen_key_allowed() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the fullscreen key is allowed or not.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_fullscreen_key_allowed() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the appview should be fullscreen or not.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_fullscreen() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the appview should be fullscreen or not.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_fullscreen() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Appview title.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Glib::ustring> property_title() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Appview title.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_title() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** UI string for application view menu.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Glib::ustring> property_menu_ui() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** UI string for application view menu.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_menu_ui() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


};

} // namespace Hildon


namespace Glib
{
  /** @relates Hildon::AppView
   * @param object The C instance
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   */
  Hildon::AppView* wrap(HildonAppView* object, bool take_copy = false);
} //namespace Glib


#endif /* _HILDON_WIDGETSMM_APPVIEW_H */

