// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _HILDON_WIDGETSMM_APP_H
#define _HILDON_WIDGETSMM_APP_H


#include <glibmm.h>

/* $Id: app.hg,v 1.10 2005/02/15 10:52:44 murrayc Exp $ */

/* app.h
 *
 * Copyright (C) 1998-2005 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/window.h>
#include <gtkmm/uimanager.h>
#include <hildon-widgetsmm/appview.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _HildonApp HildonApp;
typedef struct _HildonAppClass HildonAppClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Hildon
{ class App_Class; } // namespace Hildon
namespace Hildon
{

/**
 *
 * @ingroup Windows
 */

class App : public Gtk::Window
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef App CppObjectType;
  typedef App_Class CppClassType;
  typedef HildonApp BaseObjectType;
  typedef HildonAppClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~App();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class App_Class;
  static CppClassType app_class_;

  // noncopyable
  App(const App&);
  App& operator=(const App&);

protected:
  explicit App(const Glib::ConstructParams& construct_params);
  explicit App(HildonApp* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  HildonApp*       gobj()       { return reinterpret_cast<HildonApp*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const HildonApp* gobj() const { return reinterpret_cast<HildonApp*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
  virtual void on_topmost_status_acquire();
  virtual void on_topmost_status_lose();
  virtual void on_im_close();
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


private:

  
public:
  App();
  

  explicit App(AppView& appview);
  
  
  /** Sets (switches to) appview.
   * @param appview A Hildon::AppView.
   */
  void set_appview(AppView& appview);
  
  /** Gets the currently shown appview.
   * 
   * Returns: the currently shown appview in this HildonApp.
   * If no appview is currently set for this HildonApp,
   * @return <tt>0</tt>.
   */
  AppView* get_appview();
  
  /** Gets the currently shown appview.
   * 
   * Returns: the currently shown appview in this HildonApp.
   * If no appview is currently set for this HildonApp,
   * @return <tt>0</tt>.
   */
  const AppView* get_appview() const;
  
  /** Sets title of the application.
   * @param newtitle The new title assigned to the application.
   */
  void set_title(const Glib::ustring& newtitle);
  
  /** Gets the title of the application.
   * @return The title currently assigned to the application. This
   * value is not to be freed or modified by the calling application.
   */
  Glib::ustring get_title() const;

  //Ignore deprecated functions.
  

  Glib::SignalProxy0< void > signal_topmost_status_acquire();

  
  Glib::SignalProxy0< void > signal_topmost_status_lose();

  //TODO: Fix registration: _WRAP_SIGNAL(void switch_to(), "switch_to")
  

  Glib::SignalProxy0< void > signal_im_close();

  //TODO: Fix registration: _WRAP_SIGNAL(void clipboard_copy(Gtk::Widget* widget), "clipboard_copy")
  //TODO: Fix registration:   _WRAP_SIGNAL(void clipboard_cut(Gtk::Widget* widget), "clipboard_cut")
  //TODO: Fix registration:   _WRAP_SIGNAL(void clipboard_paste(Gtk::Widget* widget), "clipboard_paste")


  /** Sets the two part title.
   * @param istwoparttitle A <tt>bool</tt> indicating wheter to activate
   * a title that has both the application title and application
   * view title separated by a triangle.
   */
  void set_two_part_title(bool istwoparttitle = true);
  
  /** Gets the 'twopart' represention of the title inside Hildon::App.
   * @return A boolean indicating wheter title shown has both
   * application, and application view title separated by a triangle.
   */
  bool get_two_part_title() const;

  
  /** Controls the autoregistration/unregistration of (app)views.
   * @param auto_reg Whether the (app)view autoregistration should be active.
   */
  void set_autoregistration(bool auto_reg = true);

//TODO: The use of gpointer here is awful. Shouldn't it be an AppView?
  
  /** Registers a new view. For appviews, this can be done automatically
   * if autoregistration is set.
   * @param view_ptr Pointer to the view instance to be registered.
   */
  void register_view(gpointer view_ptr);
  
  /** Registers a new view. Allows the application to specify any ID.
   * @param view_ptr Pointer to the view instance to be registered.
   * @param view_id The ID of the view.
   * @return <tt>true</tt> if the view registration succeeded, <tt>false</tt> otherwise.
   * The probable cause of failure is that view with that ID
   * already existed.
   */
  bool register_view(gpointer view_ptr, gulong view_id);
  
  /** Unregisters a view from HildonApp. Done usually when a view is
   * destroyed. For appviews, this is can be automatically
   * if autoregistration is set.
   * @param view_ptr Pointer to the view instance to be unregistered.
   */
  void unregister_view(gpointer view_ptr);
  
  /** Unregisters a view with specified ID, if it exists.
   * @param view_id The ID of the view that should be unregistered.
   */
  void unregister_view(gulong view_id);
  
  /** 
   * @param view_ptr Pointer to the view whose ID we want to acquire.
   * @return The ID of the view, or 0 if not found
   * 
   * Allows mapping of view pointer to its view ID. If <tt>0</tt> is passed
   * as the view pointer, returns the ID of the current view.
   */
  gulong find_view_id(gpointer view_ptr);
  
  /** Updates the X property that contains the currently active view
   * @param view_ptr Pointer to the view that is switched to.
   */
  void notify_view_changed(gpointer view_ptr);

  
  /** Updates information about whether the application can be killed or not by
   * Task Navigator (i.e.\ whether its statesave is up to date)
   * @param killability Truth value indicating whether the app can be killed.
   */
  void set_killable(bool killability = true);

  
  /** Sets the Gtk::UIManager assigned to the Hildon::App.
   * If @a uim  is <tt>0</tt>, unsets the current ui manager.
   * The @a HildonApp  holds a reference to the ui manager until
   * the @a HildonApp  is destroyed or unset.
   * @param uim Gtk::UIManager to be set.
   */
  void set_ui_manager(const Glib::RefPtr<Gtk::UIManager>& uim);
  
  /** Gets the Gtk::UIManager assigned to the Hildon::App.
   * @return The Gtk::UIManager assigned to this application
   * or null if no manager is assigned.
   */
  Glib::RefPtr<Gtk::UIManager> get_ui_manager();
  
  /** Gets the Gtk::UIManager assigned to the Hildon::App.
   * @return The Gtk::UIManager assigned to this application
   * or null if no manager is assigned.
   */
  Glib::RefPtr<const Gtk::UIManager> get_ui_manager() const;

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Set the scroll control ON/OFF.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_scroll_control() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Set the scroll control ON/OFF.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_scroll_control() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  //deprecated: _WRAP_PROPERTY("zoom", )
  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Use two part title or not.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_two_part_title() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Use two part title or not.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_two_part_title() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Set the application title.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Glib::ustring> property_app_title() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Set the application title.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_app_title() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the application is killable or not.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_killable() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the application is killable or not.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_killable() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the application views should be registered automatically.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_autoregistration() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the application views should be registered automatically.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_autoregistration() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The currently active application view.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<AppView*> property_appview() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The currently active application view.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<AppView*> property_appview() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The associated GtkUIManager for this app.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<Gtk::UIManager> > property_ui_manager() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The associated GtkUIManager for this app.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Gtk::UIManager> > property_ui_manager() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


};

} // namespace Hildon


namespace Glib
{
  /** @relates Hildon::App
   * @param object The C instance
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   */
  Hildon::App* wrap(HildonApp* object, bool take_copy = false);
} //namespace Glib


#endif /* _HILDON_WIDGETSMM_APP_H */

