//$Id: examplewindow.cc,v 1.5 2004/03/25 14:35:34 murrayc Exp $ -*- c++ -*-

/* gtkmm example Copyright (C) 2002 gtkmm development team
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "examplewindow.h"
#include <hildon-widgetsmm/calendar-popup.h>
#include <iostream>


ExampleWindow::ExampleWindow()
: m_Button("Test")
{
  set_title("Hildon::CalendarPopup example");

  add(m_ButtonBox);

  m_ButtonBox.pack_start(m_Button);
  m_Button.signal_clicked().connect( sigc::mem_fun(*this, &ExampleWindow::on_button) );

  show_all_children();
}

ExampleWindow::~ExampleWindow()
{
}

void ExampleWindow::on_button()
{
  Hildon::CalendarPopup dialog(*this, 2005, 1, 1);
  //dialog.set_transient_for(*this);

  //Add response buttons the the dialog:
  dialog.add_button(Gtk::Stock::CANCEL, Gtk::RESPONSE_CANCEL);
  dialog.add_button("Select", Gtk::RESPONSE_OK);


  int result = dialog.run();

  //Handle the response:
  switch(result)
  {
    case(Gtk::RESPONSE_OK):
    {
      std::cout << "Select clicked." << std::endl;

      guint year = 0;
      guint month = 0;
      guint day = 0;
      dialog.get_date(year, month, day);
      std::cout << "Date chosen: year=" << year << ", month=" << month << ", day=" << day << std::endl;
      break;
    }
    case(Gtk::RESPONSE_CANCEL):
    {
      std::cout << "Cancel clicked." << std::endl;
      break;
    }
    default:
    {
      std::cout << "Unexpected button clicked." << std::endl;
      break;
    }
  }
}

