// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _HILDON_FMMM_FILE_SELECTION_H
#define _HILDON_FMMM_FILE_SELECTION_H

#include <glibmm.h>

/* $Id: date-editor.hg,v 1.10 2005/02/15 10:52:44 murrayc Exp $ */

/* grid.h
 *
 * Copyright (C) 1998-2005 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/container.h>
#include <gtkmm/filefilter.h>
#include <hildon-fmmm/file-system-model.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _HildonFileSelection HildonFileSelection;
typedef struct _HildonFileSelectionClass HildonFileSelectionClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Hildon
{ class FileSelection_Class; } // namespace Hildon
namespace Hildon
{

/** @addtogroup hildon_fmmmEnums Enums and Flags */

/**
 * @ingroup hildon_fmmmEnums
 */
enum FileSelectionMode
{
  FILE_SELECTION_MODE_LIST,
  FILE_SELECTION_MODE_THUMBNAILS
};


/**
 * @ingroup hildon_fmmmEnums
 */
enum FileSelectionPane
{
  FILE_SELECTION_PANE_NAVIGATION,
  FILE_SELECTION_PANE_CONTENT
};


/**
 * @ingroup hildon_fmmmEnums
 */
enum FileSelectionSortKey
{
  FILE_SELECTION_SORT_NAME,
  FILE_SELECTION_SORT_TYPE,
  FILE_SELECTION_SORT_MODIFIED,
  FILE_SELECTION_SORT_SIZE
};


/** 
 *
 * @ingroup Widgets
 */

class FileSelection
  : public Gtk::Container
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef FileSelection CppObjectType;
  typedef FileSelection_Class CppClassType;
  typedef HildonFileSelection BaseObjectType;
  typedef HildonFileSelectionClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~FileSelection();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class FileSelection_Class;
  static CppClassType fileselection_class_;

  // noncopyable
  FileSelection(const FileSelection&);
  FileSelection& operator=(const FileSelection&);

protected:
  explicit FileSelection(const Glib::ConstructParams& construct_params);
  explicit FileSelection(HildonFileSelection* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  HildonFileSelection*       gobj()       { return reinterpret_cast<HildonFileSelection*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const HildonFileSelection* gobj() const { return reinterpret_cast<HildonFileSelection*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  virtual void on_current_folder_changed();
  virtual void on_file_activated();
  virtual void on_selection_changed();
  virtual void on_navigation_pane_context_menu();
  virtual void on_content_pane_context_menu();
  virtual void on_items_dropped(GtkFilePath* destination, GSList * sources);
  virtual void on_location_insensitive(GtkTreeIter* iter);


private:

public:
  explicit FileSelection(const Glib::RefPtr<FileSystemModel>& model);

  
  /** Swithces file selection between list and thumbnail modes. Note that
   * this function works only after widget is shown because of Gtk::Notebook
   * implementation.
   * @param mode New mode for current folder.
   */
  void set_mode(FileSelectionMode mode);
  
  /** Gets Current view mode for file selection widget. If widget is not
   * shown this will return an invalid mode (-1). 
   * This is because of Gtk::Notebook implementation.
   * @return Current view mode.
   */
  FileSelectionMode get_mode() const;
  
  /** Changes sort settings for views. Key only affects content page,
   * navigation pane is always sorted by name.
   * @param key New sort key.
   * @param order New sort order.
   */
  void set_sort_key(FileSelectionSortKey key, Gtk::SortType order);
//TODO:
  
  /** Currently active sort settings are stored to user provided pointers.
   * @param key A place to store sort key.
   * @param order A place to store sort order.
   */
  void get_sort_key(FileSelectionSortKey& key, Gtk::SortType& order) const;


  /** Changes the content pane to display the given folder.
   * @param folder A new folder.
   * @param error A place to store possible error.
   * @return <tt>true</tt> if directory change was succesful,
   * <tt>false</tt> if error occurred.
   */
  bool set_current_folder(const GtkFilePath* folder);
  
  /** Gets a path to the currently active folder (the folder which is
   * displayed in the content pane). You have to release the returned path
   * with #gtk_file_path_free.
   * @return A Gtk::FilePath.
   */
  GtkFilePath* get_current_folder() const;

  Gtk::TreeModel::iterator get_current_folder_iter() const;
  

  /** Selects the given file. If the path doesn't point to current folder the
   * folder is changed accordingly. If multiple selection is disabled then
   * the previous selection will dissappear.
   * @param path A file to select.
   * @param error A place to store possible error.
   * @return <tt>true</tt> if folder was succesfully selected,
   * <tt>false</tt> if the path doesn't contain a valid folder.
   */
  bool select_path(const GtkFilePath* path);


  /** Unselects a currently selected filename. If the filename is not in
   * the current directory, does not exist, or is otherwise not currently
   * selected, does nothing.
   * @param path File to unselect.
   */
  void unselect_path(const GtkFilePath* path);
  
  /** Selects all files from the content pane. Multiple selection must be
   * enabled before calling this.
   */
  void select_all();
  
  /** Clears current selection from content pane.
   */
  void unselect_all();
  
  /** Otherwise similar to #hildon_file_selection_unselect_all,
   * but keeps the node with cursor selected. Thus,
   * this function don't have any efect in single selection mode.
   */
  void clear_multi_selection();

//TODO:
  
  /** Gets list of selected paths from content pane. You have to release
   * the returned list with #gtk_file_paths_free. If you are interested
   * in item that (probably) has active focus, you have to first get
   * the active pane and then call either #hildon_file_selection_get_selected_paths
   * or #hildon_file_selection_get_current_folder.
   * @return A G::SList containing Gtk::FilePath objects.
   */
  GSList* get_selected_paths();

  
  /** If multiple selection is enabled, checkboxes will appear to the last
   * item to the content pane. Multiple selection must be enabled if one
   * wants to call #hildon_file_selection_select_all.
   * @param select_multiple Either <tt>true</tt> or <tt>false</tt>.
   */
  void set_select_multiple(bool select_multiple = true);
  
  /** Gets state of multiple selection.
   * @return <tt>true</tt> If multiple selection is currently enabled.
   */
  bool get_select_multiple() const;

  
  /** Only the files matching the filter will be displayed in content pane.
   * Use <tt>0</tt> to remove filtering.
   * @param filter A new Gtk::FileFilter.
   */
  void set_filter(const Gtk::FileFilter& filter);
  
  /** Get currently active filter set by #hildon_file_selection_set filter.
   * Can be <tt>0</tt> if no filter is set.
   * @return A Gtk::FileFilter or <tt>0</tt>.
   */
  Gtk::FileFilter* get_filter();
  
  /** Get currently active filter set by #hildon_file_selection_set filter.
   * Can be <tt>0</tt> if no filter is set.
   * @return A Gtk::FileFilter or <tt>0</tt>.
   */
  const Gtk::FileFilter* get_filter() const;

  
  /** Appends currently selected paths to set of dimmed paths.
   * Note that dimmed paths cannot be selected, so selection
   * no longer contains the same paths after this function.
   */
  void dim_current_selection() const;
  
  /** Undims all from model that are dimmed by code. Simply calls
   * #hildon_file_system_model_reset_available for underlying model.
   */
  void undim_all();

  
  /** Gets the pane that either has active focus or 
   * (in case of no pane has it) last time had it.
   * @return Currently active pane.
   */
  FileSelectionPane get_active_pane() const;

  
  /** Hides the content pane. This is used in certain file management dialogs.
   */
  void hide_content_pane();
  
  /** Shows the content pane. This is used in certain file management dialogs. 
   * The content pane is shown by default. Calling this is needed only if
   * you have hidden
   */
  void show_content_pane();

  //Ignoring deprecated functions.
  

  Glib::SignalProxy0< void > signal_current_folder_changed();

  
  Glib::SignalProxy0< void > signal_file_activated();

  
  Glib::SignalProxy0< void > signal_selection_changed();

  
  Glib::SignalProxy0< void > signal_navigation_pane_context_menu();

  
  Glib::SignalProxy0< void > signal_content_pane_context_menu();

  
  Glib::SignalProxy2< void,GtkFilePath*,GSList * > signal_items_dropped();
 //TODO
  

  Glib::SignalProxy1< void,GtkTreeIter* > signal_location_insensitive();
 //TODO

  /** Set the HildonFileSystemModel to display.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<FileSystemModel> > property_model() const;


  /** Ask file selection to enable drag'n'drop support.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_drag_enabled() const;


  /** String to use when selected folder is empty.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Glib::ustring> property_empty_text() ;

/** String to use when selected folder is empty.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_empty_text() const;

  /** Defines the columns shown on content pane.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_visible_columns() const;


  /** Safe folder to use as fallback in various operations.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<GtkFilePath*> property_safe_folder() ;

/** Safe folder to use as fallback in various operations.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<GtkFilePath*> property_safe_folder() const;
 //TODO: GtkFilePath* is not public API.
  /** Which pane (navigation or content) has (or last time had) active focus.This in formation can be used to find which pane should be used to query selection.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<int> property_active_pane() ;

/** Which pane (navigation or content) has (or last time had) active focus.This in formation can be used to find which pane should be used to query selection.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_active_pane() const;

  /** Show hidden files in file selector widgets.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_show_hidden() ;

/** Show hidden files in file selector widgets.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_show_hidden() const;

  /** Whether or not all the displayed items should have a local file path.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_local_only() ;

/** Whether or not all the displayed items should have a local file path.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_local_only() const;


};

} // namespace Hildon


namespace Glib
{
  /** @relates Hildon::FileSelection
   * @param object The C instance
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   */
  Hildon::FileSelection* wrap(HildonFileSelection* object, bool take_copy = false);
}
#endif /* _HILDON_FMMM_FILE_SELECTION_H */

