// Author: Zelea
// Date: 14 April 2007
// License: http://www.gnu.org/licenses/gpl.txt

#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>
#include <string.h>
#include <signal.h>
#include <esd.h>

extern int    sound;

static char   tile_match[] = {
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 3, 1, -9, -4, 10, 8, -5, -6, 1, -4, -5, 7, 13, 1,
  -14, -10, 6, 13, 3, -7, -5, 0, 2, 0, 2, 3, 0, -6, -3, 5, 3, -4,
  0, 3, 1, -3, -2, 0, 0, 4, 4, -3, -9, 1, 6, 1, 0, 2, -3, -7, -1,
  7, 8, 0, -10, -8, 3, 11, 2, -5, -1, 1, -6, -2, 10, 9, -7, -14,
  0, 13, 4, -8, -3, 5, -1, -6, 1, 11, 0, -10, -5, 7, 7, -2, -6, 0,
  4, -1, -4, 1, 6, -1, -7, -1, 7, 1, -4, 0, 2, 0, -2, 0, 1, 1, 0,
  -1, -2, 0, 3, 2, -2, -3, 1, 1, -1, 0, 4, 1, -5, -5, 2, 7, 3, -4,
  -6, 1, 4, -2, 0, 5, 2, -8, -7, 6, 10, -1, -8, -2, 3, 0, -2, 4,
  6, -3, -10, -3, 9, 6, -2, -5, 0, 1, -4, 0, 7, 3, -4, -7, -1, 6,
  4, -2, -1, 0, -3, -2, 2, 5, 2, -3, -5, -2, 2, 5, 2, -2, -3, -1,
  -1, 1, 4, 2, -1, -5, -3, 3, 4, 2, -3, -3, 1, 0, -1, 1, 5, 0, -6,
  -4, 5, 5, -2, -3, 1, 2, -3, -2, 3, 5, -2, -6, -1, 4, 2, -3, 0,
  3, 0, -4, -2, 5, 4, -4, -4, 1, 3, 0, -1, 0, 1, -2, -1, 1, 3, 0,
  -2, -3, 2, 2, 1, -1, -2, 0, 1, 0, 1, 0, 0, -2, -2, 2, 3, 1, -3,
  -3, 1, 3, 1, -2, -1, 1, -1, -1, 1, 4, 0, -5, -1, 3, 2, -1, -2,
  2, 1, -2, -3, 2, 4, -1, -4, 0, 3, 0, -3, 1, 4, -1, -4, -2, 4, 2,
  0, -2, -1, 0, -1, 1, 3, 2, -3, -4, -1, 3, 4, 0, -2, -3, 0, 1, 1,
  2, 1, -3, -3, 0, 3, 3, 0, -3, -2, 0, 2, 0, 0, 1, -1, -1, -1, 2,
  2, 0, -3, 0, 2, 0, -2, 0, 3, 0, -2, -2, 2, 1, 0, -1, 1, 1, -3,
  -2, 2, 4, 0, -3, 0, 2, 0, -2, 0, 0, -1, -1, 1, 2, 1, -2, -3, 0,
  2, 1, -2, -1, 1, 1, 0, 1, 1, -1, 0, -1, 0, 2, 0, -1, -1, 2, 2,
  0, -2, 0, 0, 0, -1, -1, 1, -1, -2, -1, 3, 3, 0, -2, -1, 2, 0,
  -2, -1, 1, 0, -1, 0, 2, 1, -2, -1, 1, 1, -1, 0, 2, 3, 1, -2, -1,
  1, -1, -1, 0, 1, 0, -2, -1, 2, 1, -1, -3, -1, 0, 0, 0, 1, 0, 1,
  0, 0, 2, 1, -1, -2, 0, 1, 1, -1, -1, 1, 0, 0, 0, 0, 1, 0, -1, 0,
  1, 0, 0, 0, 0, -1, -1, -2, 2, 1, 0, 1, 0, -1, 0, 0, 0, 0, 0, -1,
  1, 0, 1, 1, 0, 0, -1, 0, -3, -2, 1, 1, 2, 1, -1, -1, 0, 1, 0, 1,
  0, 0, -1, 0, 0, -1, -2, 0, 0, 2, 1, 1, 0, -1, 0, -1, 0, 0, 0, 1,
  0, -1, 0, 0, 2, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 1, 1,
  0, -1, -1, -1, -1, 0, 0, 0, -2, 0, 0, 0, 1, 1, 0, -1, -3, -1, 2,
  1, 1, 3, 1, 0, 1, 0, 0, 0, 1, -1, 0, 0, -2, 0, 0, 1, -1, 0, 0,
  -2, -1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 2, 1, 0, -1, -2, 0, 1, 0,
  0, 1, 0, -1, -1, 0, 0, 1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0,
  0, 1, 0, 1, 0, -1, 0, 1, 0, -1, 0, 1, 1, 1, 1, -2, 0, 1, -2, -1,
  2, 0, -2, -1, -2, 0, 1, 0, 1, 2, 2, 0, -1, -2, -2, 1, 0, 2, 2,
  -1, 0, -1, -3, -2, 2, 2, 2, 1, -2, -2, -2, -1, 1, 3, 1, 1, 1,
  -2, -2, 0, 1, 0, 2, 1, 0, -2, -3, -1, 4, 3, 0, 1, -3, -6, 1, 1,
  2, 4, 3, -2, -5, -4, -1, 3, 5, 0, -2, 1, 0, -5, -3, 2, 1, 4, 5,
  0, -6, -5, 0, 4, 0, -1, 2, 3, 2, 1, -3, -5, -2, 0, 2, 2, 0, 0,
  2, 1, 0, -2, -1, 2, -2, -5, 0, 4, 5, 2, -5, -7, -3, 1, 5, 8, 7,
  0, -9, -9, 1, 3, -1, 4, 3, -2, 0, -3, -5, 4, 3, -1, 2, 0, 1, 1,
  -7, -7, 5, 2, 4, 13, -1, -14, -9, -1, 7, 12, 4, -5, -10, -7, 3,
  3, 2, 5, 1, -7, 1, 2, -3, 4, 4, -3, -3, 5, 3, -4, -6, -1, -2,
  -2, 4, 3, 0, 4, 1, -2, -1, -2, -1, 3, 4, 2, 0, -3, -2, 1, 1, 0,
  -3, -6, 0, 5, 5, 1, -3, -3, 0, -2, -1, 3, 1, 0, 0, -3, -2, 0, 2,
  1, -4, -2, 7, 4, -2, 2, -1, -4, -2, 0, 1, 4, 2, -3, -4, -1, 2,
  1, 1, 3, -3, -4, 0, 4, 2, -2, -1, 3, 2, 2, 2, -2, -6, -4, -1, 4,
  2, 0, 2, -1, -6, -5, -1, 8, 12, -1, -8, -5, -2, 0, 5, 3, -3, -2,
  3, 7, 3, -5, -10, -4, 6, 14, 7, -11, -16, -6, 2, 10, 12, 0, -6,
  -3, -6, -9, 4, 15, 8, -1, -10, -10, 3, 14, 6, -8, -13, -3, 8, 7,
  -1, -4, -2, 2, 7, 0, -10, -3, 6, 6, -1, -3, -4, -3, 1, 0, 1, 4,
  6, 2, -3, -3, -2, -1, -1, 1, 1, 0, 3, 3, 2, -1, -6, -5, -2, -3,
  -2, 3, 4, 5, 2, 2, 0, -3, -5, -1, 0, -1, 1, 2, 2, 1, 3, 0, -4,
  -3, -2, -1, -3, 0, 3, 2, 0, 2, 2, -2, -3, 1, -1, -3, -2, 1, 4,
  5, 4, 2, 1, -2, -5, -5, -3, 0, 5, 6, 5, 1, -1, -3, -4, -3, 1, 1,
  3, 5, 2, -4, -3, -2, -3, 0, 3, -1, 0, 3, -1, -2, -2, -1, 1, 1,
  -1, -3, -3, 0, -2, -2, 2, 6, 3, 4, 5, -1, -7, -5, -2, 0, 4, 9,
  5, 1, -1, -5, -12, -5, 3, 5, 5, 4, 1, -1, -5, -6, -4, -4, -2, 3,
  4, 3, 7, 5, -5, -7, -5, -4, 3, 12, 10, 3, -2, -8, -9, -5, 0, 3,
  6, 11, 9, -2, -11, -8, -5, -7, 3, 12, 7, 6, 2, -8, -13, -8, -2,
  7, 7, 4, 3, -3, -6, -1, -4, -5, 4, 8, 4, 0, -4, -5, 0, 2, 1, 2,
  5, 3, -4, -4, 1, 0, -1, 1, 3, 2, 4, 2, -5, -5, -1, -2, -4, 1, 2,
  -1, -3, -3, 0, 5, 7, 2, -1, 0, -2, -6, -4, 1, 3, 1, -2, -1, 0,
  -1, -3, 2, 8, 9, 2, 0, 1, -2, -8, -7, 1, 7, 5, 0, -5, -3, -4,
  -1, 3, 6, 2, 0, 2, 0, -5, -5, -4, -3, 3, 3, -3, 0, 5, 1, -1, 0,
  -2, 1, 3, -3, -1, 4, 2, -1, 3, 2, -2, -3, -1, -1, -1, 1, 2, 3,
  4, 1, -2, -6, -7, -5, 1, 1, -1, 1, 4, 6, 4, 0, 0, 1, -5, -9, -5,
  -2, -1, 2, 5, 5, 5, 3, 1, -1, -1, -4, -3, 2, 3, 3, 2, 3, -4, -7,
  -2, 0, -3, 1, 6, 7, 6, 4, 0, -4, -9, -12, -10, -4, 3, 10, 13,
  10, 5, 0, -9, -10, -5, -5, -3, 0, 1, 1, 4, 4, 0, 0, 0, -2, -4,
  0, 5, 6, 7, 6, 0, -3, -6, -11, -11, -7, 5, 16, 15, 8, 6, -2,
  -14, -11, -6, -6, -2, 2, 2, 3, 3, 1, 2, 5, 2, -2, -6, -9, -7,
  -1, 3, 9, 11, 2, -6, -8, -5, 0, 7, 13, 8, -4, -9, -10, -10, 3,
  15, 12, 8, 1, -10, -11, -4, -5, 0, 5, -1, 0, 5, 4, 6, 7, -1,
  -12, -13, -6, 4, 9, 9, 6, 0, -7, -13, -13, 1, 7, 3, 9, 12, 4,
  -2, -2, -6, -15, -16, -1, 11, 12, 12, 6, -9, -10, -1, 9, 14, 11,
  -3, -25, -28, -7, 3, 11, 24, 21, 1, -9, -17, -22, -6, 9, 12, 10,
  9, 2, -11, -14, -5, -3, -3, 7, 14, 9, 6, 6, -1, -7, -9, -10, -9,
  -3, 2, 5, 17, 17, -6, -12, 1, -1, -8, -2, 5, 3, -5, -1, 12, 0,
  -15, -1, 0, -8, 9, 12, -3, 3, 0, -5, 2, -5, -7, 9, 3, -5, 9, 9,
  -1, -2, -3, 2, 1, -6, 5, 2, -19, -13, 5, 3, 5, 6, 3, 5, 1, -3,
  -1, -9, -8, 10, 18, -3, -27, -5, 20, -8, -17, 13, 2, -11, 13, 9,
  -7, 2, -1, -7, 4, 4, 0, -3, -3, 2, 4, 5, 3, -3, 0, 6, 0, 2, 3,
  -3, 2, 2, -4, -5, -1, 1, 3, -4, -5, -1, 1, 0, 1, -1, -4, -2, -2,
  -1, 1, 4, 3, -1, -5, 2, 3, -1, 1, 4, -3, 1, 8, -5, -12, 7, 8,
  -9, -4, 4, 0, 3, 4, -3, 1, 0, -6, -2, 3, 0, 6, 8, -1, -5, -4,
  -7, -4, -1, -1, 6, 8, 6, 5, 2, -5, -6, -7, -5, -5, 0, 9, 8, 3,
  0, -6, -3, 8, 3, -5, -1, -6, -4, 1, 1, 5, 2, -5, 8, 6, -10, -2,
  5, -4, 3, 4, -7, 1, 5, -1, 0, 1, -4, 0, 0, -3, 0, 2, 0, 0, -1,
  0, 2, 1, -1, 0, 0, -1, -3, -1, 1, 1, 0, 3, 3, -1, -5, -1, 1, 1,
  2, 1, 0, 0, -1, -1, 0, -3, -2, 0, -1, 0, 2, 3, -1, -1, 1, 0, -3,
  -2, 3, 0, -2, 2, 2, 0, 2, -1, -1, 3, 4, 1, 0, 1, -1, -6, -3, 0,
  -2, 0, 1, -3, 1, 2, 2, 4, 5, 1, -3, -5, -2, -4, -1, 2, 0, 0, 7,
  2, -5, -2, -3, -4, 2, 2, 1, 4, 2, -2, -1, -1, -1, -2, 0, 0, 1,
  5, 5, 0, 3, 3, -7, -4, 0, -1, 0, 0, 1, 3, 0, -4, 2, 1, -3, 3, 2,
  -5, 0, 1, -1, 1, 2, -2, -1, -4, -3, 2, 3, 2, 1, 0, 3, 3, -1, -2,
  1, -1, -5, -2, 3, 2, -3, 1, 3, 0, -1, 1, 0, -1, -1, 0, 0, -3,
  -2, 2, -1, -2, 1, 1, 3, 3, 0, 0, 1, -3, -3, 1, -2, -1, 2, 3, 3,
  4, 0, -1, -2, -4, -2, 1, 0, -2, 0, 2, -3, -3, 7, 8, -3, -3, -1,
  -5, -1, 1, -4, 0, 4, -1, 0, 6, 0, -1, 2, -2, -5, -1, 0, 2, 3, 0,
  1, -1, -2, -1, -3, -2, 4, 0, 1, 2, -2, 0, 3, 1, 3, 3, -4, 0, 0,
  -2, 1, 3, 0, 2, -1, -2, -1, -3, -4, -1, 3, 4, 0, -2, 1, 1, -3,
  0, 2, -1, 1, 4, 1, -5, -3, 1, 0, -1, 0, -1, -2, 1, 1, 0, 4, 4,
  -1, 0, -2, -3, 0, 0, 1, -1, -1, -1, 1, 1, 0, -2, -1, 2, 2, 1, 1,
  1, -1, 1, 0, -3, -1, -1, -1, 1, 0, 3, 5, 2, -2, -1, 1, 0, 0, -1,
  -2, -1, 2, 2, 1, -1, -1, -3, 0, 0, 0, -1, -1, 0, -2, 0, 1, -2,
  -2, 1, 2, -1, 0, -1, -1, 1, 1, -2, -2, 0, 1, 3, 3, 2, 0, 0, 1,
  1, 1, -3, -2, 0, 1, 0, 1, 0, -1, -1, -1, 0, 2, 2, 2, 1, -1, -3,
  -1, 0, 1, -1, -1, 1, 1, -3, -2, -1, 1, 1, 0, 1, 1, -1, -2, 0, 2,
  0, -2, -1, 2, 0, -1, 2, 2, 2, 2, 1, -1, -1, 1, -1, 0, 1, -1, 0,
  1, -2, -4, -2, 0, 0, 1, -1, -1, 0, 0, 0, -1, -2, -1, 2, 0, -1,
  0, 0, 3, 4, 1, -1, -1, -3, 1, 4, 3, 1, 1, 0, -2, -2, 0, 0, 1, 3,
  0, -2, -2, 0, 0, 1, 1, 0, 0, -2, -1, 0, -1, -1, -2, 1, 0, -1, 1,
  2, 0, 1, 1, 1, -1, -2, 1, 0, -4, -1, 3, 0, 2, 0, -2, -1, 0, 0,
  1, 0, -1, 1, 0, 2, 3, 1, 0, -2, -3, 0, 0, 0, 3, -2, -4, 3, 0,
  -4, 2, 1, -4, 1, 2, -1, 2, -1, -3, 1, 3, 1, 2, -1, -2, 1, 1, 2,
  2, 0, 1, 3, -1, -1, -1, -3, -2, 4, 1, -3, -1, -2, -1, -1, -2, 2,
  4, 0, 0, 0, -2, 0, -1, -2, 1, 0, 0, 1, 2, 0, 0, 0, 0, 1, -1, 0,
  1, -2, -1, 1, 0, -1, -1, 0, -2, -3, 1, 1, -2, 2, 2, -1, 2, 2,
  -3, 2, 2, -1, 2, 4, -3, -2, 1, 2, 1, 1, 0, -2, -2, -1, -1, -1,
  0, 0, -2, 1, 2, -1, 0, 3, 2, -3, -2, 0, 0, 1, 3, 1, 1, 1, 0, 0,
  -2, -3, -1, 2, 1, -2, -1, 2, 0, -3, 0, 3, -7, -4, 5, 1, -2, 1,
  -3, -2, 5, 4, -3, -1, 3, -2, -3, 2, 1, -1, 0, 4, 3, -3, -2, 3,
  2, -2, 1, 3, -1, 0, -2, -2, 0, 3, 2, -1, -1, 1, 0, -4, 1, 0, -4,
  0, 0, -1, -1, -1, 0, 3, 0, 0, 1, 0, 1, 1, -2, 1, 1, 1, 1, 0, 1,
  1, 0, 1, -1, -3, 1, 0, -1, 2, 0, -2, 0, 0, 0, 3, 0, -2, 0, -1,
  -2, 0, 1, -1, -2, 0, 3, 1, -1, -2, -1, 0, 1, -2, -1, 3, 2, -1,
  1, -1, 0, 0, 1, 1, 1, -1, -1, 0, -1, 1, 2, 0, -1, 1, 2, -1, -2,
  -3, -3, -1, 1, 2, 0, -1, 1, 3, 0, 1, 0, -2, 0, 2, 0, 0, -1, -1,
  0, 1, 0, -1, 1, 2, 2, -1, -1, 1, -2, -1, 2, 0, -1, 0, 3, 2, -1,
  0, 1, -4, -4, 2, 0, -2, 1, 0, -3, 0, 1, -1, 1, 1, -1, 0, 2, 0,
  0, -1, -2, 0, 1, -1, 1, 5, 2, -2, -2, 1, 1, 0, 1, 1, -1, -3, 0,
  2, 1, 0, -2, -5, 2, 5, -3, -1, 0, -1, 4, 5, -5, -3, 3, -1, -3,
  1, 1, 1, 1, -2, -1, -2, 2, 2, 0, 1, 1, -3, 0, 2, 0, 0, 1, 0, 0,
  -1, -1, 1, 1, 0, -1, -1, 0, -1, -3, -2, 2, 0, -2, 1, 1, -2, 1,
  2, -3, -1, 4, 0, 1, 3, 0, 0, 1, 1, 2, -1, -2, 3, -1, -4, 0, -2,
  -1, 4, -2, -2, 3, 1, -2, 2, 1, -2, -2, -1, 0, 2, 2, 3, 0, -4,
  -1, -2, 0, 1, 0, 1, 1, -1, 2, 0, -5, 3, 5, -2, -1, -2, -4, 0, 0,
  3, 1, -4, 2, 3, -3, 1, 4, -1, 2, -1, -4, 2, -1, -3, 1, 2, 0, -1,
  -1, 4, 1, -4, 1, 0, -4, 3, 0, -4, 2, 3, -1, 4, 1, -6, 1, 2, -3,
  0, 5, -2, -3, 2, -2, -3, 7, 6, -1, -2, -1, -4, -1, 4, 3, 0, 1,
  -1, -3, -1, 3, 1, -2, -1, 1, -4, -4, 1, 2, -3, -1, 1, -1, 0, 5,
  2, 0, 0, -2, -5, -2, 2, 2, 1, 0, 0, 2, -2, -3, 5, 3, -2, -1, 4,
  -1, 0, 0, -1, 0, 0, -2, 1, 1, -2, 2, 5, -2, -4, 1, 0, -3, 0, 1,
  0, -1, -1, 0, 0, 1, 1, 1, -2, -3, -1, -1, 2, 0, -1, -1, 0, -2,
  3, 4, 2, 2, 0, -2, 0, 2, 1, 1, 1, 1, 1, -2, -1, -1, 0, -1, -1,
  -1, -1, -1, 1, 0, -3, -1, 0, 0, 1, 0, -1, 0, 1, 0, 0, 1, 1, 1,
  1, 0, 0, 1, 0, 1, 1, 0, -1, 0, 0, 1, 1, -1, -1, 0, -1, -1, -1,
  -1, 0, 1, -2, -1, 1, 1, -1, 0, 0, -1, -1, -1, 3, 2, 1, 2, 1, -2,
  -2, -1, 0, 1, 0, 2, 1, 0, -1, -1, -1, 1, 0, -2, 0, 2, 0, -2, 0,
  0, 0, 0, 1, 1, 1, 0, -1, -2, -1, -1, 1, 0, 0, 1, 1, 0, 1, -1,
  -1, 1, 1, 0, 1, 1, 0, -2, -1, 1, 0, 0, 1, 2, -1, -1, -1, -1, -1,
  1, 1, -1, -1, -2, -1, 0, 0, -1, 0, 1, 0, -1, -1, 1, 0, 2, 3, 1,
  -1, 1, 1, -2, 0, 0, -1, -2, 1, 2, 2, 1, 1, 1, -1, 0, 0, 0, 1, 1,
  0, -1, 0, -1, -1, -1, 0, 1, 0, -2, 0, 0, -1, -2, -3, -1, 1, -1,
  -1, 2, 2, -1, 2, 1, -2, 1, 1, 0, 2, 1, -2, -1, 0, 1, 0, 0, 0, 0,
  0, 2, 2, 1, 2, -1, -1, 0, -1, 0, 1, -2, -1, -1, -1, -1, 0, -1,
  2, 0, 0, -1, -3, -1, 1, 0, 1, 1, 1, 0, -1, -2, -1, -1, 1, 1, 1,
  0, 2, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, -1, -2,
  -1, 0, 0, 1, -1, 0, 0, -1, -1, 0, -1, -1, 1, 0, 0, 1, -1, 0, 1,
  1, 0, 1, -1, 1, 1, 0, 1, 1, -1, 0, 1, -1, 1, -1, 0, 0, 0, -2, 0,
  1, 1, 0, 0, 0, -1, 0, 0, -1, 0, 1, 0, -1, 0, 0, -1, 0, 0, 1, 0,
  -1, 0, 0, -1, 0, 0, 1, 1, 0, 1, 2, 1, 0, 0, 0, 0, -2, 0, 0, -1,
  -2, -1, -1, 0, 0, 0, 1, 2, 0, 0, -1, -1, 0, -1, -1, 1, 1, -1, 0,
  -1, -2, 0, 1, 0, 1, 2, 1, 1, 2, 0, 0, -1, 0, 1, 1, 1, 1, 0, 0,
  1, 0, -2, -1, -3, -1, -2, -2, -1, -1, 1, 0, 1, 1, 1, 0, 0, 1, 0,
  0, 0, 1, 2, 3, 0, -1, -1, -1, 0, 1, 2, 1, 1, 0, 0, -1, -1, -1,
  -1, 0, 0, 1, 0, -1, 0, 0, -1, 0, 0, -2, 1, -2, -1, 1, 0, -2, 0,
  1, 1, 0, -1, 0, -1, 0, 1, 2, 0, 0, 1, 1, 1, -1, 0, 2, 0, 0, -1,
  -2, 0, 1, 0, -1, 1, 1, 0, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0,
  1, 0, 0, 0, 1, 0, 0, -1, 1, 0, 0, 1, 1, 0, -1, -1, 0, 1, 1, 0,
  0, 0, -1, 0, -1, 0, 0, 1, 3, 2, -1, -2, 0, 0, -2, 1, 1, 1, -1,
  0, 1, -1, -1, 2, -1, -1, 0, -2, -2, 0, 1, 0, -1, 0, 0, 1, 0, 0,
  0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, -1, -1, 1, 1, 0, 1, 1, -2, 0,
  1, 1, 2, 1, 1, -1, -1, -2, 0, -1, 0, 2, 1, -2, -1, 1, -1, 0, 0,
  -1, 0, 0, 0, 1, 1, 0, 1, 0, -1, 0, 1, 0, 0, 2, 1, 1, 1, 0, -3,
  -1, -1, -1, 0, 1, 0, 0, 0, -2, -3, -2, 0, -2, 1, 2, 0, -1, 0, 0,
  -1, 1, 1, 0, -1, 1, -1, 0, 2, 2, 1, 1, 0, -1,
};

static char   tile_select[] = {
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 3, 1, -9, -4, 10, 8, -5, -6, 1, -4, -5, 7, 13, 1,
  -14, -10, 6, 13, 3, -7, -5, 0, 2, 0, 2, 3, 0, -6, -3, 5, 3, -4,
  0, 3, 1, -3, -2, 0, 0, 4, 4, -3, -9, 1, 6, 1, 0, 2, -3, -7, -1,
  7, 8, 0, -10, -8, 3, 11, 2, -5, -1, 1, -6, -2, 10, 9, -7, -14,
  0, 13, 4, -8, -3, 5, -1, -6, 1, 11, 0, -10, -5, 7, 7, -2, -6, 0,
  4, -1, -4, 1, 6, -1, -7, -1, 7, 1, -4, 0, 2, 0, -2, 0, 1, 1, 0,
  -1, -2, 0, 3, 2, -2, -3, 1, 1, -1, 0, 4, 1, -5, -5, 2, 7, 3, -4,
  -6, 1, 4, -2, 0, 5, 2, -8, -7, 6, 10, -1, -8, -2, 3, 0, -2, 4,
  6, -3, -10, -3, 9, 6, -2, -5, 0, 1, -4, 0, 7, 3, -4, -7, -1, 6,
  4, -2, -1, 0, -3, -2, 2, 5, 2, -3, -5, -2, 2, 5, 2, -2, -3, -1,
  -1, 1, 4, 2, -1, -5, -3, 3, 4, 2, -3, -3, 1, 0, -1, 1, 5, 0, -6,
  -4, 5, 5, -2, -3, 1, 2, -3, -2, 3, 5, -2, -6, -1, 4, 2, -3, 0,
  3, 0, -4, -2, 5, 4, -4, -4, 1, 3, 0, -1, 0, 1, -2, -1, 1, 3, 0,
  -2, -3, 2, 2, 1, -1, -2, 0, 1, 0, 1, 0, 0, -2, -2, 2, 3, 1, -3,
  -3, 1, 3, 1, -2, -1, 1, -1, -1, 1, 4, 0, -5, -1, 3, 2, -1, -2,
  2, 1, -2, -3, 2, 4, -1, -4, 0, 3, 0, -3, 1, 4, -1, -4, -2, 4, 2,
  0, -2, -1, 0, -1, 1, 3, 2, -3, -4, -1, 3, 4, 0, -2, -3, 0, 1, 1,
  2, 1, -3, -3, 0, 3, 3, 0, -3, -2, 0, 2, 0, 0, 1, -1, -1, -1, 2,
  2, 0, -3, 0, 2, 0, -2, 0, 3, 0, -2, -2, 2, 1, 0, -1, 1, 0, -2,
  -2, 2, 4, -1, -3, -2, 2, 2, -1, 1, 0, -1, -2, 1, 2, 1, -1, -2,
  -1, 2, 1, -1, -1, 1, 0, 0, 0, 1, 0, -1, -1, 1, 1, 0, -2, -1, 1,
  2, 0, -1, -1, 0, 1, 0, 0, 1, 0, -2, -1, 2, 2, -1, -2, 0, 1, 1,
  -1, 0, 1, 0, -2, 0, 2, 1, -2, -1, 1, 1, -1, -1, 1, 2, -1, -2, 0,
  1, 0, 0, 0, 1, -1, -1, -1, 2, 2, -1, -2, -1, 1, 1, 1, 0, 0, -2,
  -1, 1, 2, 1, -1, -2, -1, 1, 2, 0, -1, 0, 0, -1, 0, 1, 1, 0, -2,
  0, 2, 0, -1, -1, 1, 1, -1, -1,
};

static char   tile_nomatch[] = {
  -4, 7, 10, 4, 2, -3, -10, -8, -5, -3, -4, -1, 8, 13, 8, 4, 5,
  -4, -11, -7, -3, -3, -2, -3, -3, 3, 9, 7, 4, 5, 4, -7, -11, -4,
  -3, -5, -3, 0, 5, 10, 9, 6, 3, -1, -6, -8, -6, -4, -3, -4, -1,
  2, 7, 10, 6, 3, 4, -4, -12, -7, -3, -3, -3, 0, 9, 13, 7, 3, 1,
  -6, -9, -6, -2, -1, -2, -4, -2, 3, 7, 7, 8, 5, 0, -7, -8, -6,
  -4, -3, -1, 3, 9, 9, 7, 4, 0, -5, -9, -7, -3, -3, -2, -2, -1, 2,
  10, 8, 4, 4, 0, -8, -10, -6, -3, -2, 2, 8, 12, 6, 2, 3, -3, -10,
  -8, -3, -1, -3, -4, -1, 4, 6, 5, 7, 7, 0, -6, -8, -8, -5, -2, 2,
  7, 8, 7, 4, 2, 2, -4, -10, -7, -3, -4, -3, -3, 1, 7, 9, 6, 3, 4,
  0, -11, -11, -4, -2, 0, 10, 10, 4, 3, 3, 0, -3, -9, -9, -3, -2,
  -5, -2, 3, 8, 6, 4, 6, 4, -4, -8, -6, -6, -6, 3, 9, 8, 4, 4, 4,
  0, -3, -7, -8, -5, -4, -4, -2, 3, 5, 7, 8, 5, 2, -1, -8, -10,
  -7, -3, 1, 8, 10, 7, 3, 2, 2, -5, -10, -7, -3, -5, -3, 0, 1, 5,
  8, 7, 3, 5, 0, -9, -10, -4, -4, 0, 8, 10, 6, 3, 3, 1, -6, -9,
  -6, -2, -5, -4, -1, 0, 3, 8, 7, 6, 6, 2, -6, -11, -9, -4, 0, 7,
  10, 8, 3, 3, 1, -5, -7, -9, -5, -3, -4, -3, 2, 6, 9, 6, 3, 4, 2,
  -8, -12, -6, 0, 6, 10, 5, 1, -1, 2, 3, -3, -7, -8, -5, -5, -5,
  1, 9, 10, 3, 0, -1, -2, -5, -3, 5, 7, 0, 3, 3, -8, -5, 9, 4, -4,
  0, -8, -13, -3, -1, 0, 11, 11, 1, -5, -4, -3, -1, 5, 9, 5, 0, 1,
  -5, -10, 2, 6, 1, 0, -3, -12, -7, -2, -1, 7, 11, 9, -1, -8, -8,
  -2, 3, 6, 10, 5, 1, -2, -9, -8, 3, 6, 4, 0, -9, -11, -5, -2, 2,
  10, 11, 6, 1, -10, -13, -3, 8, 10, 6, 4, -1, -12, -11, 3, 7, 7,
  5, -6, -13, -5, -3, -1, 9, 11, 5, 3, -6, -14, -6, 10, 11, 5, 3,
  -5, -10, -8, -4, 3, 14, 10, -7, -12, -5, -5, -1, 9, 12, 6, -1,
  -11, -12, 4, 12, 6, 5, 2, -7, -12, -8, -2, 7, 13, 4, -8, -9, -7,
  -4, 5, 12, 7, 0, -6, -8, -2, 8, 8, 6, 2, -5, -11, -7, -3, 4, 9,
  4, -5, -8, -7, -3, 5, 10, 6, 0, -2, -5, -3, 5, 7, 4, 3, -6, -10,
  -4, 1, 2, 6, 1, -7, -7, -3, 0, 6, 9, 4, 0, 1, -2, -3, 1, 4, 0,
  -3, -6, -8, -3, 5, 6, 4, 1, -5, -8, 0, 6, 5, 4, 7, 1, -5, -2,
  -2, -2, 3, 0, -7, -6, -2, -3, -1, 3, 4, 2, 2, 2, 3, 3, 4, 2, 2,
  1, -2, -4, -2, -1, -4, -3, -1, -3, -3, -2, -4, -1, 2, 6, 8, 9,
  3, -1, 1, 2, 0, 0, 0, -3, -9, -5, -2, -5, -3, 1, 0, 3, 4, 3, 2,
  0, 2, 4, 4, 3, 0, 1, 0, 0, -1, -5, -8, -6, -3, -4, 0, 5, 5, 0,
  -2, -1, 2, 6, 5, 3, 4, 2, -1, -3, -4, -5, -4, 0, 2, 1, -3, -5,
  -4, -2, 1, 3, 3, 4, 4, 3, 4, 3, 2, -2, -4, -4, 0, 0, 1, -1, -5,
  -7, -2, -1, 0, 3, 3, 2, 1, 3, 1, 2, 3, 3, 0, -1, -2, -1, -1, 0,
  -1, -2, -4, -4, -1, -1, 1, 4, 3, 0, 1, 0, 0, 3, 5, 3, 1, 0, -5,
  -5, -1, 0, -1, -1, -1, -3, -1, 1, 1, 2, 3, 2, -1, -1, 1, 3, 3,
  0, -1, 0, -2, -3, 1, 1, 0, 0, -1, -5, -2, 0, 0, 1, 3, 1, 0, 2,
  1, 1, 1, 2, -1, -1, 1, -1, -2, -1, -1, -1, -2, -1, 0, -1, 0, 0,
  0, 3, 4, 1, 0, 0, 2, 1, 1, -1, 0, -2, -1, -2, -2, -1, -1, 0, -1,
  -1, 2, 0, 1, 2, 1, 2, 1, 0, 1, 0, -6,
};

struct sSounds
{
  char         *data;
  int           len;
  int           rate;
  int           size;
  int           channels;
};

struct sSounds Sounds[] = {
  {tile_match, sizeof( tile_match ), 11025, 8, 1}
  ,
  {tile_select, sizeof( tile_select ), 11025, 8, 1}
  ,
  {tile_nomatch, sizeof( tile_nomatch ), 11025, 8, 1}
  ,
};
int           max_sounds = sizeof( Sounds ) / sizeof( struct sSounds );

void
play_sound( int nr )
{
  struct sSounds *S;
  int           esd;
  esd_format_t  format = ESD_BITS16 | ESD_STEREO | ESD_STREAM | ESD_PLAY;
  int           i, l;
  char          v;
  char         *snd, *d, *s;
  sigset_t      sigset, oldset;

  if ( nr >= max_sounds )
    return;
  S = &Sounds[nr];
  if ( sound )
  {
    // make sure we are not interrupted by the ALRM signal
    sigemptyset( &sigset );
    sigaddset( &sigset, SIGALRM );
    sigprocmask( SIG_BLOCK, &sigset, &oldset );
    l = S->len * 4;
    if ( ( snd = malloc( l ) ) == NULL )
      return;
    esd = esd_play_stream_fallback( format, S->rate, NULL, NULL );
    s = S->data;
    d = snd;
    for ( v = 0, i = 0; i < S->len; i++ )
    {
      v += *s++;
      *d++ = 0;
      *d++ = v;
      *d++ = 0;
      *d++ = v;
    }
    // play back the sound
    write( esd, snd, l );
    free( snd );
    esd_close( esd );
    sigprocmask( SIG_SETMASK, &oldset, NULL );
  }
  // delay for the length of sound
  usleep( 500000L * S->len / S->rate );
}
